// <!-- 厄 虫 退 散
// $Id: TypeViolationException.java 106 2008-05-29 15:06:37Z yo-zi $
// Copyright 2005 Ito Yo-zi.
// Licensed under the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License. You may obtain
// a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// -->

package jp.sourceforge.greflect;

import java.text.*;

/**
 * TypeViolationException will throw when the target type is unmatch to the specified generic type
 * <BR/>対象が指定したジェネリック型に一致しないときスローされます。
 * .
 * <DT><B> Responsibilities &amp; Collaborations: </B></DT>
 * 
 * <OL><LI> 
 * <B>with</B> {@link }
 * 
 * </LI></OL>
 *
 * 
 * <DT><B> Notes &amp; Descriptions: </B></DT>
 * <DD>
 * (none)
 * 
 * 
 * </DD>
 * <DT><B> SourceInfo: </B></DT>
 * <DD> $Id: TypeViolationException.java 106 2008-05-29 15:06:37Z yo-zi $
 * </DD>
 * 
 * @author yo-zi
 *
 */
public class TypeViolationException extends Exception //DiforgTypeViolationException
{

    /**
     * <code>serialVersionUID</code>
     */
    private static final long serialVersionUID = 3617297813579512119L;

    public TypeViolationException(){
        super();
    }

    public TypeViolationException(String mes, Object... args){
        super(MessageFormat.format(mes, args));
    }

    public TypeViolationException(Throwable th, String mes, Object... args){
        super(MessageFormat.format(mes, args), th);
    }

    /*
     public TypeViolationException(String mes, Throwable th){
     super(mes, th);
     }

     public TypeViolationException(String mes, Type to){
     super(mes + ": " + to);
     }

     public TypeViolationException(String mes, Type from, Type to){
     super(mes + ": " + from + "->" + to);
     }
     */

}
