// <!-- 厄 虫 退 散
// $Id: ReflectionError.java 103 2008-05-29 02:51:11Z yo-zi $
// Copyright 2005 Ito Yo-zi.
// Licensed under the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License. You may obtain
// a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// -->

package jp.sourceforge.greflect;

import java.text.*;

/**
 * ReflectionError will throw when the situation outside assumption is happened and when the operation can not be continued
 * <BR/> リフレクション操作において想定外の事態が発生し、処理を継続できないときスローされます。
 * .
 * <DT><B> Responsibilities &amp; Collaborations: </B></DT>
 * 
 * <OL><LI> 
 * <B>with</B> {@link }
 * 
 * </LI></OL>
 *
 * 
 * <DT><B> Notes &amp; Descriptions: </B></DT>
 * <DD>
 * (none)
 * 
 * 
 * </DD>
 * <DT><B> SourceInfo: </B></DT>
 * <DD> $Id: ReflectionError.java 103 2008-05-29 02:51:11Z yo-zi $
 * </DD>
 * 
 * @author yo-zi
 *
 */
public class ReflectionError extends Error
{

    /**
     * <code>serialVersionUID</code>
     */
    private static final long serialVersionUID = 3617297813579512119L;

    public ReflectionError(Throwable th, String mes, Object... args){
        super(MessageFormat.format(mes, args), th);
    }

}
