// <!-- Encoding Fixer: 厄 虫 退 散
// $Id: Param.java 107 2008-05-30 13:25:40Z yo-zi $
// Copyright 2007 Yo-zi.
// Licensed under the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License. You may obtain
// a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//-->

package jp.sourceforge.greflect;

import java.lang.reflect.*;

import jp.sourceforge.greflect.impl.*;

/**
 * [ungeneric]
 * <BR/> A parameter holder with the specification of the generic type
 * <BR/> ジェネリック型の指定とともにパラメータ値を保持します。
 * .
 * <DT><B> Responsibilities &amp; Collaborations: </B></DT>
 * 
 * <OL><LI> Creates ungeneric object.
 * <B>with</B> {@link Reflection.Instantiator}
 * 
 * </LI><LI> Invoke method.
 * <B>with</B> {@link Reflection.Invoker}
 * 
 * </LI></OL>
 *
 * 
 * <DT><B> Notes &amp; Descriptions: </B></DT>
 * <DD>
 * (none)
 * 
 * 
 * </DD>
 * <DT><B> SourceInfo: </B></DT>
 * <DD> $Id: Param.java 107 2008-05-30 13:25:40Z yo-zi $
 * </DD>
 * 
 * @author yo-zi
 *
 */
public abstract class Param<T>
{
    T value;

    /**
     * Create Param object that keeps null value
     * <BR/> null値を保持するParamオブジェクトを作成します。
     * .
     * <DL>
     * <DT><B> Pre-conditions : </B></DT>
     * <DD>
     * </DD>
     *
     * <DT><B> Post-conditions : </B></DT>
     * <DD>
     * </DD>
     *
     * </DL>
     */
    public Param(){
        this(null);
    }

    /**
     * Create Param object that keeps the specified value
     * <BR/> 指定した値を保持するParamオブジェクトを作成します。
     * .
     * <DL>
     * <DT><B> Pre-conditions : </B></DT>
     * <DD>
     * </DD>
     *
     * <DT><B> Post-conditions : </B></DT>
     * <DD>
     * </DD>
     *
     * </DL>
     * @param value
     */
    public Param(T value){
        this.value = value;
    }

    /**
     * 
     * .
     * <DL>
     * <DT><B> Pre-conditions : </B></DT>
     * <DD>
     * </DD>
     *
     * <DT><B> Post-conditions : </B></DT>
     * <DD>
     * </DD>
     *
     * </DL>
     * @return
     */
    public T getValue(){
        return value;
    }

    /**
     * 
     * .
     * <DL>
     * <DT><B> Pre-conditions : </B></DT>
     * <DD>
     * </DD>
     *
     * <DT><B> Post-conditions : </B></DT>
     * <DD>
     * </DD>
     *
     * </DL>
     * @return
     */
    Type getType()
        throws TypeViolationException
    {
        return Param.class.getTypeParameters()[0];
    }

    /**
     * 
     * .
     * <DL>
     * <DT><B> Pre-conditions : </B></DT>
     * <DD>
     * </DD>
     *
     * <DT><B> Post-conditions : </B></DT>
     * <DD>
     * </DD>
     *
     * </DL>
     * @return
     */
    TypeVarScope getTypeVarScope()
        throws TypeViolationException
    {
        return ClassTypeVarScope.getTypeScopeWithEnclosings(getClass());
    }

}
