/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.greflect.impl;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import jp.sourceforge.greflect.TypeViolationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypeVisitor<R> {
    public R visit(Type type) throws TypeViolationException {
        if (type instanceof Class) {
            return this.visit((Class)type);
        }
        if (type instanceof TypeVariable) {
            return this.visit((TypeVariable)type);
        }
        if (type instanceof ParameterizedType) {
            return this.visit((ParameterizedType)type);
        }
        if (type instanceof WildcardType) {
            return this.visit((WildcardType)type);
        }
        if (type instanceof GenericArrayType) {
            return this.visit((GenericArrayType)type);
        }
        return this.visitSusupportedType(type);
    }

    public R visit(Class type) throws TypeViolationException {
        return this.visitSusupportedType(type);
    }

    public R visit(TypeVariable<?> type) throws TypeViolationException {
        return this.visitSusupportedType(type);
    }

    public R visit(ParameterizedType type) throws TypeViolationException {
        return this.visitSusupportedType(type);
    }

    public R visit(WildcardType type) throws TypeViolationException {
        return this.visitSusupportedType(type);
    }

    public R visit(GenericArrayType type) throws TypeViolationException {
        return this.visitSusupportedType(type);
    }

    public R visitSusupportedType(Type type) throws TypeViolationException {
        throw new TypeViolationException("The visitor of ''{0}'' is not implemented.", type);
    }
}

