/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.greflect.impl;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import jp.sourceforge.greflect.TypeViolationException;
import jp.sourceforge.greflect.impl.GenericTypeRef;
import jp.sourceforge.greflect.impl.SimpleGenericTypeRef;
import jp.sourceforge.greflect.impl.TypeVarScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassTypeVarScope
implements TypeVarScope {
    private final Class<?> rawClass;
    private final TypeVarMap typeVarMap;

    public static TypeVarScope getTypeScopeWithEnclosings(Class<?> cls) throws TypeViolationException {
        return new ClassTypeVarScope(cls);
    }

    public ClassTypeVarScope(Class<?> cls) throws TypeViolationException {
        if (cls == null) {
            throw new NullPointerException("cls");
        }
        this.rawClass = cls;
        TypeVarMap map = new TypeVarMap();
        ClassTypeVarScope.garbageTypeVarsStage1(map, cls);
        this.typeVarMap = map;
    }

    private static <T> void garbageTypeVarsStage1(TypeVarMap map, Class<T> cls) throws TypeViolationException {
        Type t = cls.getGenericSuperclass();
        if (t != null) {
            ClassTypeVarScope.garbageTypeVarsStage2(map, t);
        }
        for (Type t2 : cls.getGenericInterfaces()) {
            ClassTypeVarScope.garbageTypeVarsStage2(map, t2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void garbageTypeVarsStage2(TypeVarMap map, Type type) throws TypeViolationException {
        if (type instanceof Class) {
            Class t = (Class)type;
            ClassTypeVarScope.garbageTypeVarsStage1(map, t);
            return;
        } else {
            if (!(type instanceof ParameterizedType)) throw new TypeViolationException("The type ''{0}'' is not supported. Report it as a bug.", type);
            ParameterizedType t = (ParameterizedType)type;
            Type rtr = t.getRawType();
            Type[] ptps = t.getActualTypeArguments();
            if (!(rtr instanceof Class)) throw new TypeViolationException("The raw class ''{0}'' of the parameterized type is not a class. Report it as a bug.", type);
            Class rt = (Class)rtr;
            TypeVariable<Class<T>>[] tvs = rt.getTypeParameters();
            if (tvs.length != ptps.length) {
                throw new TypeViolationException("The number of types ''{0}'' is not match with the number of type parameters of ''{1}'' Revise the specifications.", ptps.length, rt.getName());
            }
            int i = tvs.length;
            while (--i >= 0) {
                TypeVariable tv = tvs[i];
                GenericTypeRef o = (GenericTypeRef)map.get(tv);
                if (o != null) continue;
                o = new SimpleGenericTypeRef(ptps[i]);
                map.put(tv, o);
            }
            ClassTypeVarScope.garbageTypeVarsStage1(map, rt);
        }
    }

    public Class<?> getRawType() {
        return this.rawClass;
    }

    @Override
    public GenericTypeRef resolveTypeVariable(TypeVariable<? extends GenericDeclaration> key) {
        GenericTypeRef ref = (GenericTypeRef)this.typeVarMap.get(key);
        return ref;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getRawType().getSimpleName());
        boolean first = true;
        buf.append("{");
        first = true;
        for (TypeVariable key : this.typeVarMap.keySet()) {
            if (first) {
                first = false;
            } else {
                buf.append(',');
            }
            Object gd = key.getGenericDeclaration();
            if (gd instanceof Class) {
                if (!gd.equals(this.getRawType())) {
                    buf.append(((Class)gd).getSimpleName());
                    buf.append(':');
                }
            } else if (gd instanceof Method) {
                buf.append(((Method)gd).getName());
                buf.append(':');
            } else {
                buf.append(gd.toString());
                buf.append(':');
            }
            buf.append(key.getName());
            buf.append('=');
            GenericTypeRef tr = (GenericTypeRef)this.typeVarMap.get(key);
            if (tr != null) {
                buf.append(this.typeVarMap.get(key));
                continue;
            }
            buf.append('?');
        }
        buf.append('}');
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TypeVarMap
    extends HashMap<TypeVariable<? extends GenericDeclaration>, GenericTypeRef> {
        TypeVarMap() {
        }
    }
}

