/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.greflect.impl;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import jp.sourceforge.greflect.TypeViolationException;
import jp.sourceforge.greflect.impl.GenericTypeRef;
import jp.sourceforge.greflect.impl.SimpleGenericTypeRef;
import jp.sourceforge.greflect.impl.TypeVarScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainedTypeVarScope
implements TypeVarScope {
    private final TypeVarScope scope;
    private final TypeVariable<? extends GenericDeclaration> typeVar;
    private final GenericTypeRef fixedType;

    public ChainedTypeVarScope(TypeVarScope scope, TypeVariable<? extends GenericDeclaration> tvar, GenericTypeRef fixed) {
        if (tvar == null) {
            throw new IllegalArgumentException("tvar");
        }
        if (fixed == null) {
            throw new IllegalArgumentException("fixed");
        }
        this.scope = scope;
        this.typeVar = tvar;
        this.fixedType = fixed;
    }

    private static GenericTypeRef[] createGenericTypeRefArray(Type ... arg) {
        GenericTypeRef[] r = new GenericTypeRef[arg.length];
        int i = arg.length;
        while (--i >= 0) {
            r[i] = new SimpleGenericTypeRef(arg[i]);
        }
        return r;
    }

    public static <T> TypeVarScope chain(TypeVarScope scope, Class<T> cls, Type[] types) throws TypeViolationException {
        return ChainedTypeVarScope.chain(scope, cls, ChainedTypeVarScope.createGenericTypeRefArray(types));
    }

    public static <T> TypeVarScope chain(TypeVarScope scope, Class<T> cls, GenericTypeRef[] types) throws TypeViolationException {
        TypeVariable<Class<T>>[] tvs = cls.getTypeParameters();
        if (tvs.length != types.length) {
            throw new TypeViolationException("The number of type variable is not match. Revise the specification.", new Object[0]);
        }
        for (int i = 0; i < tvs.length; ++i) {
            scope = new ChainedTypeVarScope(scope, tvs[i], types[i]);
        }
        return scope;
    }

    @Override
    public GenericTypeRef resolveTypeVariable(TypeVariable<? extends GenericDeclaration> key) {
        if (key != null && key.equals(this.typeVar)) {
            return this.fixedType;
        }
        return this.scope.resolveTypeVariable(key);
    }

    public String toString() {
        GenericDeclaration gd = this.typeVar.getGenericDeclaration();
        String name = gd instanceof Class ? ((Class)gd).getSimpleName() : (gd instanceof Method ? ((Method)gd).getName() : gd.toString());
        return "{" + name + ":" + this.typeVar.getName() + "=" + this.fixedType + "," + this.scope + "}";
    }
}

