
/*
GL_TEXTURE_RECTANGLE_NVgƂ
samplerRECT + texture2DRect
GL_TEXTURE_2DgƂ
sampler2D + texture2D
*/
//uniform samplerRECT	Texture0;
//uniform sampler2D	Texture1;
uniform vec3		CameraPos;
uniform vec3		CameraFrontDir;
uniform vec3		CameraUpDir;
uniform float		CameraNear;
uniform float		CameraFar;

uniform	float		AnimCounter;
uniform int			NumLoop;
uniform mat4		ModelMatrixInv;

int					nLoop;

vec3 virtual_tex(vec2 uv)
{
	return
		vec3
		(
			0.0,	
			sin(uv.x*7.0)/2.0+0.5,
			sin(uv.y*14.0)/2.0+0.5
		);
}

vec3 gen_outer_normal(vec3 normal)
{
	return normalize
	(
		normal*2.0
		+
		vec3
		(
			sin(normal.x*6.0),
			sin(normal.y*24.0 +AnimCounter*2.0),
			0.0
		)
	);
}

vec4 lighting(vec3 position, vec3 inner_normal, vec3 outer_normal, vec3 camera_ray[2])
{
	//Directional light
	const vec3 light_dir = normalize(vec3(0.4, -0.5, -0.2));
	const float light_power = 1.0;

	float diffuse = dot(-light_dir, inner_normal);	
	vec4 ret_color = vec4(0.6, 0.3, 0.1, 1.0)*0.1;
	if (diffuse > 0.0)
	{
		vec3 reflected = reflect(light_dir, outer_normal);
		float specular = pow(max(dot(reflected, -light_dir), 0.0), 64.0);

		ret_color.xyz
		+=
		virtual_tex
		(
			vec2
			(
				inner_normal.x/2.0+0.5,
				inner_normal.y/2.0+0.5
			)
		) * diffuse
		+
		specular*4.0;

		ret_color.xyz *= light_power;
	}

	return ret_color;
}

bool getNextRayOrigin(inout vec3 ray0, vec3 ray1)
{
	const float delta = 0.0017;	//This delta value is used for a small moving ray0 in direction of ray1.
	vec3 local_ray_origin = vec3(fract(ray0.xz), ray0.y).xzy;

	//ʂƌ?
	vec3 cross_point = local_ray_origin + ray1*(-local_ray_origin.y/ray1.y);
	if(cross_point.x < 1.0 && cross_point.x > 0.0 && cross_point.z < 1.0 && cross_point.z > 0.0)
	{
		//ʂƌ
	//	cross_point = vec3(cross_point.xz, 0.0).xzy;
		return true;
	}else
	{
		if(ray1.x > 0.0)
		{
			// Eʂƌ?
			cross_point = local_ray_origin + ray1*((1.0-local_ray_origin.x)/ray1.x);
			if(cross_point.z >= 1.0 || cross_point.z <= 0.0)
			{
				if(ray1.z < 0.0)
				{
					// Oʂƌ
					cross_point = local_ray_origin + ray1*((-local_ray_origin.z)/ray1.z);
				}else
				{
					// ʂƌ
					cross_point = local_ray_origin + ray1*((1.0-local_ray_origin.z)/ray1.z);
				}
			}
		}else
		{
			// ʂƌ?
			cross_point = local_ray_origin + ray1*(-local_ray_origin.x/ray1.x);
			if(cross_point.z >= 1.0 || cross_point.z <= 0.0)
			{
				if(ray1.z < 0.0)
				{
					// Oʂƌ
					cross_point = local_ray_origin + ray1*((-local_ray_origin.z)/ray1.z);
				}else
				{
					// ʂƌ
					cross_point = local_ray_origin + ray1*((1.0-local_ray_origin.z)/ray1.z);
				}
			}
		}
	
		ray0 = vec3(cross_point.xz+floor(ray0.xz), cross_point.y).xzy + ray1*delta;	
		return false;
	}
}

bool isCrossSphere(vec3 ray[2], out vec3 cross_point, out vec3 cross_normal)
{
	vec3 center = vec3(0.5, 0.5, 0.5);
	float rad = 0.4;

	vec3 moved = ray[0] - center;
	float a = dot(ray[1], ray[1]);
	float b = 2.0*dot(moved, ray[1]);
	float c = dot(moved, moved) - rad*rad;
	float d2 = b*b - 4.0*a*c;

	bool ret;
	if(d2 <= 0.0)
	{
		ret = false;
	}else
	{
		float t = (-b-sqrt(d2))/(2.0*a);
		if(t <= 0.0)
		{
			ret = false;
		}else
		{
			cross_point = ray[0] + t*ray[1];
			cross_normal = normalize(cross_point - center);
			ret = true;
		}
	}

	return ret;
}

bool castRayInblock(vec3 ray[2], out vec3 cross_point, out vec3 cross_normal)
{
	vec3 local_ray[2];

	local_ray[0] = vec3(fract(ray[0]).xz, ray[0].y).xzy; // blockł̃[JW
	local_ray[1] = ray[1];

	vec3 local_pos;
	bool ret = /*isCrossObject*/isCrossSphere
	(
		local_ray, local_pos, cross_normal
	);

	if(ret)
	{
		cross_point.xz = local_pos.xz + floor(ray[0].xz);
		cross_point.y = local_pos.y;
	}

	return ret;
}

bool castRay(vec3 ray[2], out vec3 cross_point, out vec3 cross_normal)
{
	const float upper = 3.0, bottom = 0.0;

	if((ray[0].y >= upper && ray[1].y >= 0.0)
	||  (ray[0].y <= bottom && ray[1].y <= 0.0))
	{
		return false;
	}else
	{
		vec3 new_ray_pos;
		if(ray[0].y >= upper)
		{
			new_ray_pos = ray[0] + ray[1]*((upper-ray[0].y)/ray[1].y);
		}else
		{
			new_ray_pos = ray[0];
		}

		bool ret;
		int count = 0;
		bool is_bottom;

		do
		{
			vec3 tmp_ray[2];
			tmp_ray[0] = new_ray_pos;
			tmp_ray[1] = ray[1];

			ret=castRayInblock(tmp_ray, cross_point, cross_normal);
			is_bottom =	getNextRayOrigin(new_ray_pos, ray[1]);

			count++;
		}while
		(
			!(
				ret
				|| is_bottom
				|| count > nLoop
			)
		);

		return ret;
	}
}

vec4 lighting_with_ref(vec3 position, vec3 normal, vec3 camera_ray[2])
{
	const float delta = 0.05;//0.0005;

	vec3 inner_normal = normal;
	vec3 outer_normal
	= gen_outer_normal(normal);

	vec3 ray[2];

	ray[1] = reflect(camera_ray[1], outer_normal);
	ray[0] = position + ray[1]*delta;

	vec3 cross_point, cross_normal;

	const float ref_rate = 0.4;

	return
		(
			castRay(ray, cross_point, cross_normal)
			?
				lighting
				(
					cross_point,
					cross_normal, gen_outer_normal(cross_normal),
					ray
				)
			:
				vec4(0.0, 0.0, 0.0, 0.0)
		)*ref_rate
		+
		lighting(position, inner_normal, outer_normal, camera_ray)*(1.0-ref_rate);
}

void main (void)
{
	vec3 camera_side_dir = normalize
	(
		cross(CameraFrontDir, CameraUpDir)
	) * (gl_TexCoord[0].x*2.0-1.0);

	vec3 ray[2];

	ray[0] = (ModelMatrixInv*vec4(CameraPos, 1.0)).xyz;
	ray[1] =
	(
		ModelMatrixInv
		*
		vec4
		(
			normalize
			(
				CameraFrontDir*CameraNear
				+
				camera_side_dir
				+
				(gl_TexCoord[0].y*2.0-1.0)*CameraUpDir
			),
			0.0
		)
	).xyz;

	vec3 cross_point, cross_normal;

	nLoop = NumLoop/2;
	bool is_cross = castRay(ray, cross_point, cross_normal);

	//Without tmp variable, GLSL compiler doesnt assing value to gl_FragDepth.
	float tmp_depth;
	vec4 tmp_color;

	if(is_cross && dot(cross_normal, ray[1]) < 0.0)
	{
		float z = -dot(cross_point - CameraPos, CameraFrontDir);
		float A = 2.0*CameraNear*CameraFar/(CameraFar-CameraNear);
		float B = (CameraFar+CameraNear)/(CameraFar-CameraNear);
		//nvidia depth
	//	tmp_depth = (A/z+B+1.0)/2.0;
		//ati depth, but it seems that this works in nvidia...
		tmp_depth =
		clamp
		(
			1.00425*(A/z+B+1.0)/2.0,
			0.0,
			1.0	
		);

		nLoop = 2;
		tmp_color = lighting_with_ref/*lighting*/(cross_point, cross_normal, ray);
	}else
	{
		tmp_depth= 1.0;
		tmp_color = vec4(0.0, 0.0, 0.0, 1.0);
	}

	gl_FragDepth = tmp_depth;
	gl_FragColor = tmp_color;
}

