package nu.mine.kino.plugin.google.ui.views.fields;

import org.eclipse.swt.graphics.Image;

/**
 * e[u`̃r[̃JC^[tF[XłB
 * 
 * @author Masatomi KINO
 * @version $Revision: 1.2 $
 */
public interface IField {

    /**
     * @return the description of the field.
     */
    // String getDescription();
    /**
     * @return the image associated with the description of the field or
     *         <code>null<code>.
     */
    // Image getDescriptionImage();
    /**
     * @return The text to be displayed in the column header for this field.
     */
    String getColumnHeaderText();

    /**
     * @return The image to be displayed in the column header for this field or
     *         <code>null<code>.
     */
    Image getColumnHeaderImage();

    /**
     * @param obj
     * @return The String value of the object for this particular field to be
     *         displayed to the user.
     */
    String getValue(Object obj);

    /**
     * @param obj
     * @return The image value of the object for this particular field to be
     *         displayed to the user or <code>null<code>.
     */
    Image getImage(Object obj);

    /**
     * @param obj1
     * @param obj2
     * @return Either:
     *         <li>a negative number if the value of obj1 is less than the
     *         value of obj2 for this field.
     *         <li><code>0</code> if the value of obj1 and the value of obj2
     *         are equal for this field.
     *         <li>a positive number if the value of obj1 is greater than the
     *         value of obj2 for this field.
     */
    int compare(Object obj1, Object obj2);
}
