//$Id: Log4jPlugin.java,v 1.1 2005/05/20 14:43:56 cvsuser Exp $
package nu.mine.kino.log4j;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The main plugin class to be used in the desktop.
 */
public class Log4jPlugin extends AbstractUIPlugin {
    /**
     * Logger for this class
     */
    private static final Logger logger = Logger.getLogger(Log4jPlugin.class);

    //The shared instance.
    private static Log4jPlugin plugin;

    //Resource bundle.
    private ResourceBundle resourceBundle;

    /**
     * The constructor.
     */
    public Log4jPlugin() {
        super();
        plugin = this;
        try {
            resourceBundle = ResourceBundle
                    .getBundle("nu.mine.kino.log4j.Log4jPluginResources");
        } catch (MissingResourceException x) {
            resourceBundle = null;
        }
    }

    /**
     * This method is called upon plug-in activation
     */
    public void start(BundleContext context) throws Exception {
        super.start(context);
        configure();
    }

    public void configure() {
        String log4jPath = getPreferenceStore().getString(
                PreferenceConstants.DEFAULT_LOG4J_PATH);
        DOMConfigurator.configure(log4jPath);
        logger.debug(log4jPath + " Log4j܂B");
        print();
    }

    /**
     * This method is called when the plug-in is stopped
     */
    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    /**
     * Returns the shared instance.
     */
    public static Log4jPlugin getDefault() {
        return plugin;
    }

    /**
     * Returns the string from the plugin's resource bundle, or 'key' if not
     * found.
     */
    public static String getResourceString(String key) {
        ResourceBundle bundle = Log4jPlugin.getDefault().getResourceBundle();
        try {
            return (bundle != null) ? bundle.getString(key) : key;
        } catch (MissingResourceException e) {
            return key;
        }
    }

    /**
     * Returns the plugin's resource bundle,
     */
    public ResourceBundle getResourceBundle() {
        return resourceBundle;
    }

    public static void log(String message, Exception e) {
        IStatus status = new Status(IStatus.ERROR, getPluginId(),
                IStatus.ERROR, message, e);
        getDefault().getLog().log(status);
    }

    public static void log(String message) {
        log(message, null);
    }

    public static void log(Exception e) {
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        String message = stringWriter.getBuffer().toString();
        log(message, e);
    }

    public static String getPluginId() {
        return getDefault().getBundle().getSymbolicName();
    }

    private void print() {
        Logger rootLogger = Logger.getRootLogger();
        logger.info("---------------------------------------");
        //root̃xmF邽߂ɁARoot LoggergpĂ
        rootLogger.debug("Root Logger  DEBUG o͂܂B");
        rootLogger.info("Root Logger  INFO  o͂܂B");
        rootLogger.warn("Root Logger  WARN  o͂܂B");
        rootLogger.error("Root Logger  ERROR o͂܂B");
        rootLogger.fatal("Root Logger  FATAL o͂܂B");
        logger.info("---------------------------------------");
    }

    //    public void configure() {
    //        String log4jPath = getPreferenceStore().getString(
    //                PreferenceConstants.DEFAULT_LOG4J_PATH);
    //        configure(log4jPath);
    //
    //    }

}