
#ifndef _SC_TESTBENCH_
#define _SC_TESTBENCH_


SC_MODULE(TESTBENCH)
{
        SC_CTOR(TESTBENCH) : m_consumer("consumer"), m_producer("producer")
        {
                SC_CTHREAD(testbench,m_clk.pos());
                m_consumer.m_clk(m_clk);
                m_consumer.m_ready(m_ready);
                m_consumer.m_reset(m_reset);
                m_consumer.m_valid(m_valid);
                m_consumer.m_value(m_value);
                m_producer.m_clk(m_clk);
                m_producer.m_ready(m_ready);
                m_producer.m_reset(m_reset);
                m_producer.m_valid(m_valid);
                m_producer.m_value(m_value);
        }
        void testbench()
        {
                for ( int state = 0; state < 100; state++ )
                {
                        m_reset = ( state%20 == 12 ) ? false : true;
                        wait();
                }
                sc_stop();
        }
        sc_in_clk       m_clk;
        CONSUMER        m_consumer;
        PRODUCER        m_producer;
        sc_signal<bool> m_ready;
        sc_signal<bool> m_reset;
        sc_signal<bool> m_valid;
        sc_signal<int>  m_value;
};

#endif

