#------------------------------------------------------------------------------
#    59Tracker, weblog software for personal publisher.
#    Copyright (C) 2004-2010 Kaga, Hiroaki
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#------------------------------------------------------------------------------

package Lib::Language;

use Lib::Conf;
my $conf = Lib::Conf->new();
my $language = $conf->get_language();

# auto:自動判定 ja:日本語 en:英語
if ($language eq 'auto') {
    my $hal = $ENV{'HTTP_ACCEPT_LANGUAGE'};
    my @langlist = split(/,/, $hal);
    $language = substr($langlist[0], 0, 2); # 2byteじゃないものもあるけど...
    if ($language ne 'ja') {
        $language = 'en';
    }
}
if (($language ne 'ja') && ($language ne 'en')) {
    $language = 'en';
}
require "Lang/$language.cgi";

sub new {
    my $self = {};

    $self->{langcode} = $language;

    bless($self);
    return $self;
}

sub get_langcode {
    my $self = shift;
    return $self->{langcode};
}

sub get_statictext {
    my $self = shift;
    my $key = shift;
    return $STATICTEXT{$key};
}

sub get_message {
    my $self = shift;
    my $key = shift;
    return $MESSAGE{$key};
}

sub get_usererror {
    my $self = shift;
    my $key = shift;
    return $USERERROR{$key};
}

sub get_systemerror {
    my $self = shift;
    my $key = shift;
    return $SYSTEMERROR{$key};
}

sub get_trackbackerror {
    my $self = shift;
    my $key = shift;
    return $TRACKBACKERROR{$key};
}

1;
# End of Language.pm
