#------------------------------------------------------------------------------
#    59Tracker, weblog software for personal publisher.
#    Copyright (C) 2004-2010 Kaga, Hiroaki
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#------------------------------------------------------------------------------

package Lib::Ads;

use strict;
use warnings;

use constant {
    LOCK_SH => 1,
    LOCK_EX => 2,
    LOCK_NB => 4,
    LOCK_UN => 8,
};

use Lib::Logger;
use Lib::Language;

my $logger = Lib::Logger->new();

# コンストラクタ
sub new {
    my $self = {};

    use Lib::Conf;
    my $conf = Lib::Conf->new();

    $self->{system_dir} = $conf->get_system_dir();

    $self->{ad1} = '';      # 広告コード1（記事上）
    $self->{ad2} = '';      # 広告コード2（記事下）
    $self->{ad3} = '';      # 広告コード3（サイドバー）
    $self->{adlist} = '';   # お知らせ

    bless($self);
    $self->load();
    return $self;
}

# 広告コード1の取得
sub get_ad1 {
    my $self = shift;
    return $self->{ad1};
}

# 広告コード1の設定
sub set_ad1 {
    my $self = shift;
    $self->{ad1} = shift;
}

# 広告コード2の取得
sub get_ad2 {
    my $self = shift;
    return $self->{ad2};
}

# 広告コード2の設定
sub set_ad2 {
    my $self = shift;
    $self->{ad2} = shift;
}

# 広告コード3の取得
sub get_ad3 {
    my $self = shift;
    return $self->{ad3};
}

# 広告コード3の設定
sub set_ad3 {
    my $self = shift;
    $self->{ad3} = shift;
}

# お知らせの取得
sub get_adlist {
    my $self = shift;
    return $self->{adlist};
}

# お知らせの設定
sub set_adlist {
    my $self = shift;
    $self->{adlist} = shift;
}

# デフォルト広告コード、お知らせの読み込み
sub load {
    my $self = shift;
    my $systemdir = $self->{system_dir};

    # 広告ファイルを読み込む
    my $adfile = "$systemdir/adlink.txt";
    if (-f $adfile) {
        open my $adfh, '<', $adfile;
        my $data = <$adfh>;
        chomp $data;
        my ($ad1, $ad2, $ad3) = split(/\,/, $data);
        close $adfh;

        $ad1 =~ s/enc_conma/,/g;
        $ad2 =~ s/enc_conma/,/g;
        $ad3 =~ s/enc_conma/,/g;
        $ad1 =~ s/enc_crlf/\n/g;
        $ad2 =~ s/enc_crlf/\n/g;
        $ad3 =~ s/enc_crlf/\n/g;

        $self->{ad1} = $ad1;
        $self->{ad2} = $ad2;
        $self->{ad3} = $ad3;
    }

    # お知らせファイルを読み込む
    my $adlistfile = "$systemdir/adlist.txt";
    if (-f $adlistfile) {
        my $adlist = '';
        open my $adlistfh, '<', $adlistfile;
        while (my $data = <$adlistfh>) {
            if ($data ne '') {
                $adlist .= $data;
            }
        }
       close $adlistfh;
        $self->{adlist} = $adlist;
    }
}

# デフォルト広告コード、お知らせの更新
sub update {
    my $self = shift;
    my $systemdir = $self->{system_dir};

    my $ad1 = $self->{ad1};
    my $ad2 = $self->{ad2};
    my $ad3 = $self->{ad3};
    my $adlist = $self->{adlist};

    $ad1 =~ s/,/enc_conma/g; 
    $ad2 =~ s/,/enc_conma/g; 
    $ad3 =~ s/,/enc_conma/g; 
    $ad1 =~ s/\r?\n/enc_crlf/g;
    $ad2 =~ s/\r?\n/enc_crlf/g;
    $ad3 =~ s/\r?\n/enc_crlf/g;

    $adlist =~ s/,/enc_conma/g; 
    $adlist =~ s/\r?\n/\n/g;

    # 広告ファイルを更新
    my $adfile = "$systemdir/adlink.txt";
    open my $adfh, '>', $adfile;
    flock $adfh, LOCK_EX;
    print {$adfh} "$ad1,$ad2,$ad3\n";
    flock $adfh, LOCK_UN;
    close $adfh;

    chmod 0766, $adfile;

    # お知らせファイルを更新
    my $adlistfile = "$systemdir/adlist.txt";
    open my $adlistfh, '>', $adlistfile;
    flock $adlistfh, LOCK_EX;
    print {$adlistfh} "$adlist";
    flock $adlistfh, LOCK_UN;
    close $adlistfh;

    chmod 0766, $adlistfile;
}

# お知らせ一覧の取得
sub get_adlist_table {
    my $self = shift;

    my $list = '';
    my $adlist = $self->{adlist};
    if ($adlist ne '') {
        my $language = Lib::Language->new();
        my $noticelabel = $language->get_statictext('notice');
        $adlist =~ s/\n/<br \/>/g; 
        $list = <<"END_TABLE";
<h3>$noticelabel</h3>
$adlist
<br />
END_TABLE
    }

    return $list;
}

1;
# End of Ads.pm
