#!/usr/bin/perl
#------------------------------------------------------------------------------
#    59bbs, blog like bulletin board system.
#    Copyright (C) 2007-2009 Kaga, Hiroaki
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#------------------------------------------------------------------------------

use strict;
use warnings;

use Lib::Logger;
use Lib::Error;
use Lib::User;
use Lib::Ping;
use Lib::App::Conf;

my $logger = Lib::Logger->new();
my $error = Lib::Error->new();
my $user = Lib::User->new();
my $ping = Lib::Ping->new();
my $conf = Lib::App::Conf->new();

sub act() {
    my ($act, $cgi) = @_;

    my $sessionid = $cgi->cookie('cookie59b');
    if ($sessionid eq '') {
        $error->print_error('00003e');
    }
    my $session_userid = $user->check_session($sessionid);
    if ($session_userid eq '') {
        $error->print_error('00003e');
    }

    if (!$user->is_admin($session_userid)) {
        $error->print_error('00004e');
    }

    if ($act eq 'edit_pinglist') {
        _edit_pinglist();
    }
    elsif ($act eq 'update_pinglist') {
        _update_pinglist($cgi);
    }
    else {
        $error->print_error('00002e');
    }
}

# Ping送信先の編集
sub _edit_pinglist() {

    # Ping送信先の取得
    $ping->load();
    my @items = $ping->get_pinglist();

    my $itemlist = '';
    foreach my $item (@items) {
        $itemlist .= "$item\n";
    }

    # 編集画面表示
    _show_page($itemlist);
}

# Ping送信先の更新
sub _update_pinglist() {
    my ($cgi) = @_;

    my $itemlist = $cgi->param('itemlist');
    $itemlist =~ s/\r?\n/ /g;

    my @items = split(/ /, $itemlist);

    # Ping送信先ファイルを更新
    $ping->set_pinglist(@items);
    $ping->update();

    print "Location: ./", "\n\n";
}

# Ping設定画面の表示
sub _show_page() {
    my ($itemlist) = @_;

    my $caption = 'Ping設定';

    my $path = <<"END_PATH";
<p><strong>
<a href="./" class="path">ホーム</a>&nbsp;
&gt;&nbsp;
$caption
</strong></p>
END_PATH

    my $systemdir = $conf->get_system_dir();

    open my $templatefh, '<', "$systemdir/tmpl/pinglist.tmpl";
    my $template = do { local $/; <$templatefh> };
    close $templatefh;

    $template =~ s/\$CAPTION\$/$caption/g;
    $template =~ s/\$PATH\$/$path/g;
    $template =~ s/\$ITEMLIST\$/$itemlist/g;

    print "Content-Type: text/html\n\n";
    print $template;

    exit;
}

1;
