#!/usr/bin/perl
#------------------------------------------------------------------------------
#    59bbs, blog like bulletin board system.
#    Copyright (C) 2007-2009 Kaga, Hiroaki
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#------------------------------------------------------------------------------

use strict;
use warnings;

use Lib::Logger;
use Lib::Error;
use Lib::User;
use Lib::App::Conf;

use constant {
    LOCK_SH => 1,
    LOCK_EX => 2,
    LOCK_NB => 4,
    LOCK_UN => 8,
};

my $logger = Lib::Logger->new();
my $error = Lib::Error->new();
my $user = Lib::User->new();
my $conf = Lib::App::Conf->new();

sub act() {
    my ($act, $cgi) = @_;

    my $sessionid = $cgi->cookie('cookie59b');
    if ($sessionid eq '') {
        $error->print_error('00003e');
    }
    my $session_userid = $user->check_session($sessionid);
    if ($session_userid eq '') {
        $error->print_error('00003e');
    }

    if (!$user->is_admin($session_userid)) {
        $error->print_error('00004e');
    }

    if ($act eq 'edit_template') {
        _edit_template($cgi);
    }
    elsif ($act eq 'update_template') {
        _update_template($cgi);
    }
    else {
        $error->print_error('00002e');
    }
}

# 編集画面の表示
sub _edit_template() {
    my ($cgi) = @_;

    my $filecode = $cgi->param('filecode');
    if ($filecode eq '') {
        $filecode = 1;
    }

    _show_page($filecode, '');
}

# 編集内容をファイルに保存
sub _update_template() {
    my ($cgi) = @_;

    my $filecode = $cgi->param('filecode');
    my $filedata = $cgi->param('filedata');
    if ($filedata eq '') {
        _show_page($filecode, 'ファイルデータが空です');
    }

    my $systemdir = $conf->get_system_dir();

    my $filepath;
    if ($filecode == 1) {
        $filepath = "$systemdir/tmpl/list.tmpl";
    }
    elsif ($filecode == 2) {
        $filepath = "$systemdir/tmpl/detail.tmpl";
    }
    else {
        $filepath = 'basic.css';
    }

    $filedata =~ s/\r?\n/\n/g;

    open my $datafh, '>', $filepath;
    flock $datafh, LOCK_EX;
    print {$datafh} $filedata;
    flock $datafh, LOCK_UN;
    close $datafh;

    # 編集画面に戻る
    _show_page($filecode, '');
}

# 画面表示
sub _show_page() {
    my ($filecode, $msg) = @_;

    # ファイルリストの設定
    my $filename = '';
    my $filelist = '';
    if ($filecode == 1) {
        $filename = 'list.tmpl';
        $filelist = <<"END_LIST";
<select name="filecode">
<option selected value="1">list.tmpl
<option value="2">detail.tmpl
<option value="3">basic.css
</select>
END_LIST
    }
    elsif ($filecode == 2) {
        $filename = 'detail.tmpl';
        $filelist = <<"END_LIST";
<select name="filecode">
<option value="1">list.tmpl
<option selected value="2">detail.tmpl
<option value="3">basic.css
</select>
END_LIST
    }
    else {
        $filename = 'basic.css';
        $filelist = <<"END_LIST";
<select name="filecode">
<option value="1">list.tmpl
<option value="2">detail.tmpl
<option selected value="3">basic.css
</select>
END_LIST
    }

    my $systemdir = $conf->get_system_dir();
    my $filepath;
    if ($filecode < 3) {
        $filepath = "$systemdir/tmpl/$filename";
    }
    else {
        $filepath = $filename;
    }

    # 編集ファイルの読み込み
    open my $datafh, '<', $filepath;
    my $filedata = do { local $/; <$datafh> };
    close $datafh;

    $msg = "<p><strong><font color=\"message\" size=\"+1\">$msg</font></strong></p>";

    my $caption = 'テンプレートファイル編集';

    my $path = <<"END_PATH";
<p><strong>
<a href="./" class="path">ホーム</a>&nbsp;
&gt;&nbsp;
$caption
</strong></p>
END_PATH

    open my $templatefh, '<', "$systemdir/tmpl/template.tmpl";
    my $template = do { local $/; <$templatefh> };
    close $templatefh;

    $template =~ s/\$CAPTION\$/$caption/g;
    $template =~ s/\$PATH\$/$path/g;
    $template =~ s/\$MSG\$/$msg/g;
    $template =~ s/\$FILELIST\$/$filelist/g;
    $template =~ s/\$FILENAME\$/$filename/g;
    $template =~ s/\$FILECODE\$/$filecode/g;
    $template =~ s/\$FILEDATA\$/$filedata/g;

    print "Content-Type: text/html\n\n";
    print $template;

    exit;
}

1;
