/*
 * Decompiled with CFR 0.152.
 */
package kawa.standard;

import gnu.bytecode.ZipLoader;
import gnu.expr.Language;
import gnu.expr.ModuleBody;
import gnu.kawa.reflect.ClassMemberLocation;
import gnu.lists.Consumer;
import gnu.lists.VoidConsumer;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure1;
import gnu.mapping.Values;
import gnu.mapping.WrappedException;
import gnu.text.FilePath;
import gnu.text.Path;
import gnu.text.SyntaxException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import kawa.Shell;

public class load
extends Procedure1 {
    boolean relative;
    public static final load load = new load("load", false);
    public static final load loadRelative = new load("load-relative", true);

    public load(String name, boolean relative) {
        super(name);
        this.relative = relative;
    }

    public static final void loadClassFile(String name, Environment env) {
        Environment orig_env = Environment.getCurrent();
        try {
            if (env != orig_env) {
                Environment.setCurrent(env);
            }
            Class<?> clas = Class.forName(name);
            Object inst = clas.newInstance();
            ClassMemberLocation.defineAll(inst, env);
            if (inst instanceof Runnable) {
                ((Runnable)inst).run();
            }
        }
        catch (Throwable ex) {
            throw new WrappedException("exception during load of \"" + name + '\"', ex);
        }
        finally {
            if (env != orig_env) {
                Environment.setCurrent(orig_env);
            }
        }
    }

    public static final void loadCompiled(Path path, Environment env) throws Throwable {
        Environment orig_env = Environment.getCurrent();
        String name = path.toString();
        try {
            Object proc;
            if (env != orig_env) {
                Environment.setCurrent(env);
            }
            if (!(path instanceof FilePath)) {
                throw new RuntimeException("load: " + name + " - not a file path");
            }
            File zfile = ((FilePath)path).toFile();
            if (!zfile.exists()) {
                throw new RuntimeException("load: " + name + " - not found");
            }
            if (!zfile.canRead()) {
                throw new RuntimeException("load: " + name + " - not readable");
            }
            ZipLoader loader = new ZipLoader(name);
            Class clas = loader.loadAllClasses();
            Object v0 = proc = clas == null ? null : clas.newInstance();
            if (!(proc instanceof ModuleBody)) {
                throw new RuntimeException("load: " + name + " - no module in archive");
            }
            ClassMemberLocation.defineAll(proc, env);
            ((ModuleBody)proc).run();
        }
        catch (IOException ex) {
            throw new WrappedException("load: " + name + " - " + ex.toString(), ex);
        }
        catch (InstantiationException ex) {
            throw new WrappedException("class not instantiable: in load", ex);
        }
        catch (IllegalAccessException ex) {
            throw new WrappedException("class illegal access: in load", ex);
        }
        finally {
            if (env != orig_env) {
                Environment.setCurrent(orig_env);
            }
        }
    }

    public static final void loadSource(InPort port, Environment env, URL url) throws SyntaxException, Throwable {
        boolean print = ModuleBody.getMainPrintValues();
        Language language = Language.getDefaultLanguage();
        Consumer out = print ? Shell.getOutputConsumer(OutPort.outDefault()) : new VoidConsumer();
        Shell.run(language, env, port, out, OutPort.errDefault(), url);
    }

    @Override
    public final Object apply1(Object arg1) throws Throwable {
        return this.apply2(arg1, Environment.getCurrent());
    }

    @Override
    public final Object apply2(Object name, Object arg2) throws Throwable {
        try {
            Environment env = (Environment)arg2;
            kawa.standard.load.apply(Path.valueOf(name), env, this.relative, 0);
            return Values.empty;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("load: file not readable: " + name);
        }
        catch (SyntaxException ex) {
            throw new RuntimeException("load: errors while compiling '" + name + "':\n" + ex.getMessages().toString(20));
        }
    }

    public static final void apply(Path path, Environment env, boolean relative, int skipLines) throws Throwable {
        int char3;
        int char2;
        int char1;
        String name = path.toString();
        if (name.endsWith(".zip") || name.endsWith(".jar")) {
            kawa.standard.load.loadCompiled(path, env);
            return;
        }
        URL url = path.toURL();
        char file_separator = System.getProperty("file.separator").charAt(0);
        if (name.endsWith(".class")) {
            name = name.substring(0, name.length() - 6);
            name = name.replace('/', '.');
            if (file_separator != '/') {
                name = name.replace(file_separator, '.');
            }
            kawa.standard.load.loadClassFile(name, env);
            return;
        }
        BufferedInputStream fs = new BufferedInputStream(path.openInputStream());
        ((InputStream)fs).mark(5);
        int char0 = ((InputStream)fs).read();
        if (char0 == -1) {
            return;
        }
        if (char0 == 80 && (char1 = ((InputStream)fs).read()) == 75 && (char2 = ((InputStream)fs).read()) == 3 && (char3 = ((InputStream)fs).read()) == 4) {
            ((InputStream)fs).close();
            kawa.standard.load.loadCompiled(path, env);
            return;
        }
        ((InputStream)fs).reset();
        InPort src = InPort.openFile(fs, path);
        while (--skipLines >= 0) {
            src.skipRestOfLine();
        }
        kawa.standard.load.loadSource(src, env, url);
        src.close();
    }
}

