/*
 * Decompiled with CFR 0.152.
 */
package kawa.standard;

import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.LetExp;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.mapping.Symbol;
import java.util.Stack;
import kawa.lang.Syntax;
import kawa.lang.SyntaxForm;
import kawa.lang.TemplateScope;
import kawa.lang.Translator;

public class let
extends Syntax {
    public static final let let = new let();

    @Override
    public Expression rewrite(Object obj, Translator tr) {
        int i;
        if (!(obj instanceof Pair)) {
            return tr.syntaxError("missing let arguments");
        }
        Pair pair = (Pair)obj;
        Object bindings = pair.car;
        Object body = pair.cdr;
        int decl_count = Translator.listLength(bindings);
        if (decl_count < 0) {
            return tr.syntaxError("bindings not a proper list");
        }
        Expression[] inits = new Expression[decl_count];
        LetExp let2 = new LetExp(inits);
        Stack<Declaration> renamedAliases = null;
        int renamedAliasesCount = 0;
        SyntaxForm syntaxRest = null;
        for (i = 0; i < decl_count; ++i) {
            Pair init;
            Object binding_cdr;
            Declaration decl;
            Object name;
            Pair binding;
            SyntaxForm syntax2;
            Pair bind_pair;
            block24: {
                block26: {
                    block25: {
                        TemplateScope templateScope;
                        while (bindings instanceof SyntaxForm) {
                            syntaxRest = (SyntaxForm)bindings;
                            bindings = syntaxRest.form;
                        }
                        bind_pair = (Pair)bindings;
                        Object bind_pair_car = bind_pair.car;
                        syntax2 = syntaxRest;
                        if (bind_pair_car instanceof SyntaxForm) {
                            syntax2 = (SyntaxForm)bind_pair_car;
                            bind_pair_car = syntax2.form;
                        }
                        if (!(bind_pair_car instanceof Pair)) {
                            return tr.syntaxError("let binding is not a pair:" + bind_pair_car);
                        }
                        binding = (Pair)bind_pair_car;
                        name = binding.car;
                        if (name instanceof SyntaxForm) {
                            SyntaxForm sf = (SyntaxForm)name;
                            name = sf.form;
                            templateScope = sf.scope;
                        } else {
                            TemplateScope templateScope2 = templateScope = syntax2 == null ? null : syntax2.scope;
                        }
                        if (!(name instanceof String) && !(name instanceof Symbol)) {
                            return tr.syntaxError("variable " + name + " in let binding is not a symbol: " + obj);
                        }
                        decl = let2.addDeclaration(name);
                        if (templateScope != null) {
                            Declaration alias = tr.makeRenamedAlias(decl, templateScope);
                            if (renamedAliases == null) {
                                renamedAliases = new Stack<Declaration>();
                            }
                            renamedAliases.push(alias);
                            ++renamedAliasesCount;
                        }
                        binding_cdr = binding.cdr;
                        while (binding_cdr instanceof SyntaxForm) {
                            syntax2 = (SyntaxForm)binding_cdr;
                            binding_cdr = syntax2.form;
                        }
                        if (!(binding_cdr instanceof Pair)) {
                            return tr.syntaxError("let has no value for '" + name + "'");
                        }
                        binding = (Pair)binding_cdr;
                        binding_cdr = binding.cdr;
                        while (binding_cdr instanceof SyntaxForm) {
                            syntax2 = (SyntaxForm)binding_cdr;
                            binding_cdr = syntax2.form;
                        }
                        if (!tr.matches(binding.car, "::")) break block24;
                        if (!(binding_cdr instanceof Pair)) break block25;
                        binding = (Pair)binding_cdr;
                        if (binding.cdr != LList.Empty) break block26;
                    }
                    return tr.syntaxError("missing type after '::' in let");
                }
                binding_cdr = binding.cdr;
                while (binding_cdr instanceof SyntaxForm) {
                    syntax2 = (SyntaxForm)binding_cdr;
                    binding_cdr = syntax2.form;
                }
            }
            if (binding_cdr == LList.Empty) {
                init = binding;
            } else if (binding_cdr instanceof Pair) {
                decl.setType(tr.exp2Type(binding));
                decl.setFlag(8192);
                init = (Pair)binding_cdr;
            } else {
                return tr.syntaxError("let binding for '" + name + "' is improper list");
            }
            inits[i] = tr.rewrite_car(init, syntax2);
            if (init.cdr != LList.Empty) {
                return tr.syntaxError("junk after declaration of " + name);
            }
            decl.noteValue(inits[i]);
            bindings = bind_pair.cdr;
        }
        i = renamedAliasesCount;
        while (--i >= 0) {
            tr.pushRenamedAlias((Declaration)renamedAliases.pop());
        }
        tr.push(let2);
        let2.body = tr.rewrite_body(body);
        tr.pop(let2);
        tr.popRenamedAlias(renamedAliasesCount);
        return let2;
    }

    static {
        let.setName("let");
    }
}

