/*
 * Decompiled with CFR 0.152.
 */
package kawa.standard;

import gnu.bytecode.ClassType;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.ModuleExp;
import gnu.expr.QuoteExp;
import gnu.expr.ScopeExp;
import gnu.expr.SetExp;
import gnu.kawa.reflect.Invoke;
import gnu.lists.FString;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.math.BaseUnit;
import gnu.math.NamedUnit;
import gnu.math.Quantity;
import gnu.math.Unit;
import java.util.Vector;
import kawa.lang.Syntax;
import kawa.lang.Translator;

public class define_unit
extends Syntax {
    public static final define_unit define_unit = new define_unit(false);
    public static final define_unit define_base_unit;
    boolean base;

    public define_unit(boolean base) {
        this.base = base;
    }

    @Override
    public boolean scanForDefinitions(Pair st, Vector forms, ScopeExp defs, Translator tr) {
        if (st.cdr instanceof Pair) {
            Pair p = (Pair)st.cdr;
            Object q = p.car;
            if (q instanceof String) {
                String name = (String)q;
                String sym = (name + "$unit").intern();
                Declaration decl = defs.getDefine(sym, 'w', tr);
                tr.push(decl);
                Translator.setLine(decl, (Object)p);
                decl.setFlag(16384);
                if (defs instanceof ModuleExp) {
                    decl.setCanRead(true);
                }
                NamedUnit unit = null;
                if (this.base && p.cdr == LList.Empty) {
                    unit = BaseUnit.make(name, (String)null);
                } else if (p.cdr instanceof Pair) {
                    Object v = ((Pair)p.cdr).car;
                    if (this.base && v instanceof FString) {
                        unit = BaseUnit.make(name, v.toString());
                    } else if (!this.base && v instanceof Quantity) {
                        unit = Unit.make(name, (Quantity)v);
                    }
                }
                if (unit != null) {
                    decl.noteValue(new QuoteExp(unit));
                }
                p = Translator.makePair(p, decl, p.cdr);
                st = Translator.makePair(st, this, p);
                forms.addElement(st);
                return true;
            }
        }
        tr.error('e', "missing name in define-unit");
        return false;
    }

    @Override
    public Expression rewriteForm(Pair form, Translator tr) {
        Pair p1;
        Expression value;
        block11: {
            block10: {
                Object obj = form.cdr;
                value = null;
                if (!(obj instanceof Pair)) break block10;
                p1 = (Pair)obj;
                if (p1.car instanceof Declaration) break block11;
            }
            return tr.syntaxError("invalid syntax for " + this.getName());
        }
        Declaration decl = (Declaration)p1.car;
        String name = decl.getName();
        String unit = name.substring(0, name.length() - 5).intern();
        ClassType unitType = ClassType.make("gnu.math.Unit");
        decl.setType(unitType);
        value = decl.getValue();
        if (!(value instanceof QuoteExp) || !(((QuoteExp)value).getValue() instanceof Unit)) {
            if (this.base) {
                String dimension = null;
                if (p1.cdr != LList.Empty) {
                    dimension = ((Pair)p1.cdr).car.toString();
                }
                BaseUnit bunit = BaseUnit.make(unit, dimension);
                value = new QuoteExp(bunit);
            } else {
                Object quantity;
                if (!(p1.cdr instanceof Pair)) {
                    return tr.syntaxError("missing value for define-unit");
                }
                Pair p2 = (Pair)p1.cdr;
                value = tr.rewrite(p2.car);
                if (value instanceof QuoteExp && (quantity = ((QuoteExp)value).getValue()) instanceof Quantity) {
                    value = new QuoteExp(Unit.make(unit, (Quantity)quantity));
                } else {
                    Expression[] args = new Expression[]{new QuoteExp((Object)unit), value};
                    value = Invoke.makeInvokeStatic(unitType, "make", args);
                }
            }
        }
        SetExp sexp = new SetExp(decl, value);
        sexp.setDefining(true);
        decl.noteValue(value);
        return sexp;
    }

    static {
        define_unit.setName("define-unit");
        define_base_unit = new define_unit(true);
        define_base_unit.setName("define-base-unit");
    }
}

