/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prubae;

import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.math.IntNum;
import java.util.List;
import java.util.Vector;
import javax.swing.JTextField;
import jp.sourceforge.glj.lisp.Lisp;
import jp.sourceforge.gnp.prubae.PrubaeControllerFunction;
import jp.sourceforge.gnp.prubae.PrubaeModel;
import jp.sourceforge.gnp.prubae.PrubaeViewFunction;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseWriter;

public class PrubaeModelFunction
extends PrubaeModel {
    public static final int SPA = 1;
    public static final int APDP = 2;
    public static final int EXTF = 3;
    public static final int PART = 4;
    public static final int MINFROMDATE = 19800101;
    public static final int MAXFROMDATE = 99991231;
    public static final int MINTODATE = 19800101;
    public static final int MAXTODATE = 99991231;
    public static final int ExtfReturnJudgement = 1;
    public static final int ExtfReturnAction = 2;
    public static final int ExtfReturnValue = 3;
    private int functionType = 0;
    private String carrier = null;
    private String tkCarrier = null;
    private String name = null;
    private int fromDate = 0;
    private int toDate = 0;
    private List common = null;
    private List actions = null;
    private int extfReturnType = 3;
    private List args;

    public PrubaeModelFunction() {
        this.setView(new PrubaeViewFunction());
        this.getView().setModel(this);
        this.setController(new PrubaeControllerFunction());
        this.getController().setModel(this);
        this.getView().setController(this.getController());
        this.getController().setView(this.getView());
        this.setCommon(new Vector());
        this.setActions(new Vector());
    }

    @Override
    public void close() {
        this.getEditor().updateUrlname(this.getRegist(), this.getCarrier(), this.getTkCarrier(), this.getName(), this.getFromDate(), this.getToDate());
        while (this.getCommon() != null && this.getCommon().size() > 0) {
            ((PrubaeModel)this.getCommon().get(0)).close();
        }
        while (this.getActions() != null && this.getActions().size() > 0) {
            ((PrubaeModel)this.getActions().get(0)).close();
        }
        super.close();
    }

    @Override
    public String toFilename() {
        if (this.getFunctionType() == 1) {
            return this.describe() + this.getFromDate() + this.getToDate() + ".xml";
        }
        if (this.getFunctionType() == 2) {
            return this.describe() + this.getFromDate() + this.getToDate() + ".xml";
        }
        if (this.getFunctionType() == 3) {
            return this.describe() + ".xml";
        }
        if (this.getFunctionType() == 4) {
            return this.describe() + ".xml";
        }
        return "";
    }

    public String toRuleSubdir() {
        if (this.getFunctionType() == 1) {
            return "spa";
        }
        if (this.getFunctionType() == 2) {
            return "apdp";
        }
        if (this.getFunctionType() == 3) {
            return "extf";
        }
        if (this.getFunctionType() == 4) {
            return "part";
        }
        return "";
    }

    @Override
    public String describe() {
        if (this.getFunctionType() == 1) {
            return "SPA(" + this.getCarrier() + "," + this.getTkCarrier() + ")";
        }
        if (this.getFunctionType() == 2) {
            return "APDP(" + this.getCarrier() + ")";
        }
        if (this.getFunctionType() == 3) {
            return "EXTF(" + this.getName() + ")";
        }
        if (this.getFunctionType() == 4) {
            return "PART(" + this.getName() + ")";
        }
        return "Function";
    }

    @Override
    public void writeModel(ProrateRulebaseWriter rulebase) {
        rulebase.writeFunction(this);
    }

    @Override
    public int getSize(ProrateRulebaseWriter rulebase) {
        return rulebase.getFunctionSize(this);
    }

    public void updateArgs() {
        if (this.getArgs() == null) {
            return;
        }
        System.err.println("updateArgs : " + this.getArgs().size());
        for (int i = 0; i < this.getArgs().size(); ++i) {
            PrubaeControllerFunction cntl = (PrubaeControllerFunction)this.getController();
            JTextField argField = cntl.getArgFields().get(i);
            String arg = argField.getText();
            if (arg.startsWith("$$")) {
                this.getArgs().set(i, arg);
                continue;
            }
            if (arg.startsWith("$")) {
                this.getArgs().set(i, "$" + arg);
                continue;
            }
            this.getArgs().set(i, "$$" + arg);
        }
        System.err.println("updateArgsCount() : nthCdr 35 prubae.savedVarList = " + Lisp.nthCdr(35, this.getEditor().getSavedVarList()));
        LList addedVarList = this.getEditor().getSavedVarList();
        System.err.println("updateArgsCount() : nthCdr 35 addedVarList = " + Lisp.nthCdr(35, addedVarList));
        if (addedVarList == null) {
            return;
        }
        int registInit = 1536;
        for (int i = 0; i < this.getArgs().size(); ++i) {
            IntNum regist = new IntNum(registInit + i);
            Object obj = this.getArgs().get(i);
            Pair insList = Lisp.cons(regist, Lisp.cons(obj, Lisp.cons(obj, Lisp.cons("any", Lisp.nil))));
            addedVarList = Lisp.append(addedVarList, Lisp.cons(insList, Lisp.nil));
        }
        System.err.println("updateArgsCount() : nthCdr 35 addedVarList = " + Lisp.nthCdr(35, addedVarList));
        this.getEditor().setVarList(addedVarList);
        System.err.println("prubae.varList nthCdr 35 = " + Lisp.nthCdr(35, this.getEditor().getVarList()));
    }

    @Override
    public Object clone() {
        int i;
        PrubaeModelFunction clone = null;
        clone = (PrubaeModelFunction)super.clone();
        if (this.getCommon() != null) {
            clone.setCommon((List)((Vector)this.getCommon()).clone());
            for (i = 0; i < this.getCommon().size(); ++i) {
                clone.getCommon().set(i, ((PrubaeModel)this.getCommon().get(i)).clone());
                ((PrubaeModel)clone.getCommon().get(i)).initialize(this.getEditor(), clone, clone.getCommon());
            }
        }
        if (this.getActions() != null) {
            clone.setActions((List)((Vector)this.getActions()).clone());
            for (i = 0; i < this.getActions().size(); ++i) {
                clone.getActions().set(i, ((PrubaeModel)this.getActions().get(i)).clone());
                ((PrubaeModel)clone.getActions().get(i)).initialize(this.getEditor(), clone, clone.getActions());
            }
        }
        return clone;
    }

    @Override
    public boolean check(List errors) {
        int i;
        switch (this.getFunctionType()) {
            case 1: {
                if (this.getCarrier() == null || this.getCarrier().equals("")) {
                    errors.add("carrier not defined");
                    return false;
                }
                if (this.getTkCarrier() == null || this.getTkCarrier().equals("")) {
                    errors.add("tkCarrier not defined");
                    return false;
                }
                if (this.getFromDate() < 19800101 || this.getFromDate() > 99991231) {
                    errors.add("validStart is out of range");
                    return false;
                }
                if (this.getToDate() >= 19800101 && this.getToDate() <= 99991231) break;
                errors.add("validEnd is out of range");
                return false;
            }
            case 2: {
                if (this.getCarrier() == null || this.getCarrier().equals("")) {
                    errors.add("carrier not defined");
                    return false;
                }
                if (this.getFromDate() < 19800101 || this.getFromDate() > 99991231) {
                    errors.add("validStart is out of range");
                    return false;
                }
                if (this.getToDate() >= 19800101 && this.getToDate() <= 99991231) break;
                errors.add("validEnd is out of range");
                return false;
            }
            case 3: {
                if (this.getExtfReturnType() < 1 || this.getExtfReturnType() > 3) {
                    errors.add("illegal type defined");
                    return false;
                }
                if (this.getArgs() == null) {
                    this.setArgs(new Vector());
                }
            }
            case 4: {
                if (this.getName() != null && !this.getName().equals("")) break;
                errors.add("name not defined");
                return false;
            }
            default: {
                errors.add("illegal rule");
            }
        }
        if (this.getActions() == null || this.getActions().size() <= 0) {
            errors.add("no actions are defined in this rule");
            return false;
        }
        for (i = 0; i < this.getCommon().size(); ++i) {
            if (((PrubaeModel)this.getCommon().get(i)).check(errors)) continue;
            errors.add("in common statement #" + (i + 1));
            return false;
        }
        for (i = 0; i < this.getActions().size(); ++i) {
            if (((PrubaeModel)this.getActions().get(i)).check(errors)) continue;
            errors.add("in action statement #" + (i + 1));
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(PrubaeModel other) {
        if (super.equals(other)) {
            return true;
        }
        if (!(other instanceof PrubaeModelFunction)) {
            return false;
        }
        PrubaeModelFunction otherFunc = (PrubaeModelFunction)other;
        return this.getFunctionType() == otherFunc.getFunctionType() && (this.getCarrier() == null && otherFunc.getCarrier() == null || this.getCarrier() != null && otherFunc.getCarrier() != null && this.getCarrier().equals(otherFunc.getCarrier())) && (this.getTkCarrier() == null && otherFunc.getTkCarrier() == null || this.getTkCarrier() != null && otherFunc.getTkCarrier() != null && this.getTkCarrier().equals(otherFunc.getTkCarrier())) && (this.getName() == null && otherFunc.getName() == null || this.getName() != null && otherFunc.getName() != null && this.getName().equals(otherFunc.getName())) && this.getFromDate() == otherFunc.getFromDate() && this.getToDate() == otherFunc.getToDate();
    }

    public void setFunctionType(int theFunctionType) {
        this.functionType = theFunctionType;
        switch (this.functionType) {
            case 1: {
                this.setRegist((short)257);
                break;
            }
            case 2: {
                this.setRegist((short)258);
                break;
            }
            case 3: {
                this.setRegist((short)263);
                break;
            }
            case 4: {
                this.setRegist((short)264);
            }
        }
    }

    public int getFunctionType() {
        return this.functionType;
    }

    public void setCarrier(String theCarrier) {
        this.carrier = theCarrier;
    }

    public String getCarrier() {
        return this.carrier;
    }

    public void setTkCarrier(String theTkCarrier) {
        this.tkCarrier = theTkCarrier;
    }

    public String getTkCarrier() {
        return this.tkCarrier;
    }

    public void setName(String theName) {
        this.name = theName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setFromDate(int theFromDate) {
        this.fromDate = theFromDate;
    }

    public int getFromDate() {
        return this.fromDate;
    }

    public void setToDate(int theToDate) {
        this.toDate = theToDate;
    }

    public int getToDate() {
        return this.toDate;
    }

    public void setCommon(List theCommon) {
        this.common = theCommon;
    }

    public List getCommon() {
        return this.common;
    }

    public void setActions(List theActions) {
        this.actions = theActions;
    }

    public List getActions() {
        return this.actions;
    }

    public int getExtfReturnType() {
        return this.extfReturnType;
    }

    public void setExtfReturnType(int extfReturnType) {
        this.extfReturnType = extfReturnType;
    }

    public List getArgs() {
        return this.args;
    }

    public void setArgs(List args) {
        this.args = args;
    }
}

