/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prubae;

import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.math.IntNum;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import jp.sourceforge.glj.lisp.Lisp;
import jp.sourceforge.gnp.prubae.PrubaeComboItem;
import jp.sourceforge.gnp.prubae.PrubaeControllerJudge;
import jp.sourceforge.gnp.prubae.PrubaeModel;
import jp.sourceforge.gnp.prubae.PrubaeModelJudgeStatement;
import jp.sourceforge.gnp.prubae.PrubaeModelValue;
import jp.sourceforge.gnp.prubae.PrubaeModelValueStatement;

public class PrubaeControllerJudgeStatement
extends PrubaeControllerJudge {
    private JTextField statementField;
    private JComboBox functionBox;
    private List<PrubaeComboItem> comboItems;

    @Override
    protected void createButtons() {
        super.createButtons();
        this.setStatementField(new JTextField("", 16));
        this.getStatementField().setEditable(false);
        JPanel judgePanel = new JPanel();
        judgePanel.setLayout(new BoxLayout(judgePanel, 0));
        JLabel judgeLabel = new JLabel("Judge : ");
        judgePanel.add(judgeLabel);
        judgePanel.add(this.getStatementField());
        this.getPanel().add(judgePanel);
        this.setFunctionBox(new JComboBox());
        this.getFunctionBox().setMaximumRowCount(4);
        this.getFunctionBox().setActionCommand("select function");
        this.getPanel().add(this.getFunctionBox());
    }

    @Override
    public void update() {
        ((PrubaeModelJudgeStatement)this.getModel()).updateStatement();
        super.update();
    }

    @Override
    public void createPanel() {
        LList judgeList;
        super.createPanel();
        PrubaeModelJudgeStatement model = (PrubaeModelJudgeStatement)this.getModel();
        LList list = this.getEditor().getJudgeList();
        if (model.getValues() != null) {
            int numArgs = model.getValues().size();
            judgeList = Lisp.assoc(new IntNum(model.getRegist()), list);
            if (judgeList != null) {
                int i;
                Object listArgs = Lisp.cdr(Lisp.cdr(Lisp.cdr(Lisp.cdr(judgeList))));
                Object[] typeArgs = new Object[numArgs];
                for (i = 0; i < numArgs; ++i) {
                    typeArgs[i] = Lisp.car(listArgs);
                    listArgs = Lisp.cdr(listArgs);
                }
                for (i = 0; i < model.getValues().size(); ++i) {
                    PrubaeModelValue child;
                    if (!(model.getValues().get(i) instanceof PrubaeModelValue) || !((child = (PrubaeModelValue)model.getValues().get(i)) instanceof PrubaeModelValueStatement)) continue;
                    if (i > 0 && typeArgs[i] != null && typeArgs[i].equals("first")) {
                        child.setRequiredType(((PrubaeModelValue)model.getValues().get(0)).getType());
                    } else if (((PrubaeModel)model.getValues().get(i)).getRegist() == 321 && ((PrubaeModelValue)model.getValues().get(i)).getRequiredType() != null) {
                        child.setRequiredType(((PrubaeModelValue)model.getValues().get(i)).getRequiredType());
                    } else if (((PrubaeModel)model.getValues().get(i)).getRegist() == 321 && ((PrubaeModelValue)model.getValues().get(i)).getType() != null) {
                        child.setRequiredType(((PrubaeModelValue)model.getValues().get(i)).getType());
                    } else if (((PrubaeModel)model.getValues().get(i)).getRegist() == 322 && ((PrubaeModelValue)model.getValues().get(i)).getRequiredType() != null) {
                        child.setRequiredType(((PrubaeModelValue)model.getValues().get(i)).getRequiredType());
                    } else if (((PrubaeModel)model.getValues().get(i)).getRegist() == 322 && ((PrubaeModelValue)model.getValues().get(i)).getType() != null) {
                        child.setRequiredType(((PrubaeModelValue)model.getValues().get(i)).getType());
                    } else if (typeArgs[i] != null) {
                        child.setRequiredType(typeArgs[i]);
                    }
                    if (child.getController() == null) {
                        child.openUI();
                    }
                    child.getController().createPanel();
                }
            }
        }
        this.setComboItems(new Vector());
        PrubaeComboItem item = new PrubaeComboItem("", "");
        this.getComboItems().add(item);
        this.getFunctionBox().addItem(item);
        while (!Lisp.isNil(list)) {
            judgeList = (LList)Lisp.car(list);
            String dispStr = Lisp.car(Lisp.cdr(judgeList)).toString();
            String itemStr = Lisp.car(Lisp.cdr(Lisp.cdr(judgeList))).toString();
            item = new PrubaeComboItem(dispStr, itemStr);
            this.getComboItems().add(item);
            this.getFunctionBox().addItem(item);
            list = (LList)Lisp.cdr(list);
        }
        this.getFunctionBox().addActionListener(this);
    }

    @Override
    public void destroyPanel() {
        this.setStatementField(null);
        this.setFunctionBox(null);
        super.destroyPanel();
    }

    protected void select(String selected) {
        PrubaeModelJudgeStatement model = (PrubaeModelJudgeStatement)this.getModel();
        LList list = this.getEditor().getJudgeList();
        while (!Lisp.isNil(list)) {
            LList judgeList = (LList)Lisp.car(list);
            String itemStr = Lisp.car(Lisp.cdr(Lisp.cdr(judgeList))).toString();
            if (selected.equals(itemStr)) {
                short regist = (short)((IntNum)Lisp.car(judgeList)).intValue();
                if (model.getRegist() == regist && model.getName().equals(selected)) break;
                if (model.getValues() != null) {
                    for (int i = 0; i < model.getValues().size(); ++i) {
                        if (!(model.getValues().get(i) instanceof PrubaeModel)) continue;
                        ((PrubaeModel)model.getValues().get(i)).closeUI();
                    }
                    model.getValues().clear();
                }
                model.setRegist(regist);
                model.setName(selected);
                this.arguments(judgeList);
                model.updateStatement();
                this.getStatementField().setText(model.getStatement());
                break;
            }
            list = (LList)Lisp.cdr(list);
        }
    }

    private void arguments(LList judgeList) {
        int i;
        PrubaeModelJudgeStatement model = (PrubaeModelJudgeStatement)this.getModel();
        Object isArgs = Lisp.car(Lisp.cdr(Lisp.cdr(Lisp.cdr(judgeList))));
        System.err.println("judge controller Arguments : judgeList = " + judgeList);
        if (isArgs == null) {
            return;
        }
        if (!(isArgs instanceof IntNum)) {
            return;
        }
        System.err.println("numArgs = " + isArgs);
        int numArgs = ((IntNum)isArgs).intValue();
        if (numArgs <= 0) {
            return;
        }
        System.err.println("judge controller Arguments = " + numArgs);
        Object listArgs = Lisp.cdr(Lisp.cdr(Lisp.cdr(Lisp.cdr(judgeList))));
        Object[] typeArgs = new Object[numArgs];
        for (i = 0; i < numArgs; ++i) {
            typeArgs[i] = Lisp.car(listArgs);
            listArgs = Lisp.cdr(listArgs);
        }
        if (model.getValues() == null) {
            model.setValues(new Vector());
        }
        if (numArgs == 1 && typeArgs[0] != null && typeArgs[0].equals("setamount")) {
            model.getValues().add("");
            model.getValues().add(new Double(0.0));
            return;
        }
        for (i = 0; i < numArgs && typeArgs[i] != null; ++i) {
            PrubaeModelValueStatement ret;
            String type = typeArgs[i] instanceof Pair ? (String)Lisp.car(typeArgs[i]) : (String)typeArgs[i];
            if (type.equals("setnumber")) {
                ret = new PrubaeModelValueStatement();
                ret.setRegist((short)513);
                ret.setComment("");
                ret.setStatement("0");
                ret.setValues(new Vector());
                ret.getValues().add(new Double(0.0));
                ret.setType(typeArgs[i]);
                ret.initialize(this.getEditor(), model, model.getValues());
                ((PrubaeModel)ret).openUI();
                model.getValues().add(ret);
                this.getPanel().add(ret.getController().getPanel());
                continue;
            }
            if (type.equals("setdate")) {
                ret = new PrubaeModelValueStatement();
                ret.setRegist((short)514);
                ret.setComment("");
                ret.setStatement("0/0");
                ret.setValues(new Vector());
                ret.getValues().add(new Short(0));
                ret.getValues().add(new Short(0));
                ret.setType(typeArgs[i]);
                ret.initialize(this.getEditor(), model, model.getValues());
                ((PrubaeModel)ret).openUI();
                model.getValues().add(ret);
                this.getPanel().add(ret.getController().getPanel());
                continue;
            }
            if (type.equals("setstring")) {
                ret = new PrubaeModelValueStatement();
                ret.setRegist((short)516);
                ret.setComment("");
                ret.setStatement("\"\"");
                ret.setValues(new Vector());
                ret.getValues().add("");
                ret.setType(typeArgs[i]);
                ret.initialize(this.getEditor(), model, model.getValues());
                ((PrubaeModel)ret).openUI();
                model.getValues().add(ret);
                this.getPanel().add(ret.getController().getPanel());
                continue;
            }
            if (type.equals("setamount")) {
                ret = new PrubaeModelValueStatement();
                ret.setRegist((short)520);
                ret.setComment("");
                ret.setValues(new Vector());
                ret.getValues().add("");
                ret.getValues().add(new Double(0.0));
                ret.setType(typeArgs[i]);
                ret.initialize(this.getEditor(), model, model.getValues());
                ((PrubaeModel)ret).openUI();
                model.getValues().add(ret);
                this.getPanel().add(ret.getController().getPanel());
                continue;
            }
            if (type.equals("setpath")) continue;
            ret = new PrubaeModelValueStatement();
            ret.setComment("");
            ret.setStatement("");
            ret.setType(typeArgs[i]);
            ret.initialize(this.getEditor(), model, model.getValues());
            ((PrubaeModel)ret).openUI();
            model.getValues().add(ret);
            this.getPanel().add(ret.getController().getPanel());
        }
    }

    public void activateSelection() {
        this.getFunctionBox().setActionCommand("select function");
    }

    public void inactivateSelection() {
        this.getFunctionBox().setActionCommand("nop");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("select function")) {
            PrubaeComboItem selected = (PrubaeComboItem)((JComboBox)e.getSource()).getSelectedItem();
            this.select(selected.getItemString());
        } else if (!e.getActionCommand().equals("nop")) {
            super.actionPerformed(e);
        }
    }

    @Override
    void createPopupMenu() {
        JMenuItem mi = null;
        this.setPopupMenu(new JPopupMenu());
        mi = new JMenuItem("insert And/Or upon this");
        mi.setActionCommand("insert");
        mi.addActionListener(this);
        this.getPopupMenu().add(mi);
        mi = new JMenuItem("override And/Or upon this");
        mi.setActionCommand("override");
        mi.addActionListener(this);
        this.getPopupMenu().add(mi);
    }

    @Override
    public Object clone() {
        PrubaeControllerJudgeStatement clone = null;
        clone = (PrubaeControllerJudgeStatement)super.clone();
        if (this.getStatementField() != null) {
            clone.setStatementField(new JTextField());
        }
        if (this.getFunctionBox() != null) {
            clone.setFunctionBox(new JComboBox());
            clone.getFunctionBox().setSelectedItem(this.getFunctionBox().getSelectedItem());
        }
        return clone;
    }

    public void setStatementField(JTextField theStatementField) {
        this.statementField = theStatementField;
    }

    public JTextField getStatementField() {
        return this.statementField;
    }

    public void setFunctionBox(JComboBox theFunctionBox) {
        this.functionBox = theFunctionBox;
    }

    public JComboBox getFunctionBox() {
        return this.functionBox;
    }

    public List getComboItems() {
        return this.comboItems;
    }

    public void setComboItems(List comboItems) {
        this.comboItems = comboItems;
    }

    public PrubaeComboItem getComboItem(String itemStr) {
        for (int i = 0; i < this.getComboItems().size(); ++i) {
            PrubaeComboItem ret = (PrubaeComboItem)this.getComboItems().get(i);
            if (!itemStr.equals(ret.getItemString())) continue;
            return ret;
        }
        return (PrubaeComboItem)this.getComboItems().get(0);
    }
}

