/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prubae;

import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.math.IntNum;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import jp.sourceforge.glj.lisp.Lisp;
import jp.sourceforge.gnp.prubae.PrubaeComboItem;
import jp.sourceforge.gnp.prubae.PrubaeController;
import jp.sourceforge.gnp.prubae.PrubaeControllerDo;
import jp.sourceforge.gnp.prubae.PrubaeModel;
import jp.sourceforge.gnp.prubae.PrubaeModelDoStatement;
import jp.sourceforge.gnp.prubae.PrubaeModelValue;
import jp.sourceforge.gnp.prubae.PrubaeModelValueStatement;

public class PrubaeControllerDoStatement
extends PrubaeControllerDo {
    private JTextField statementField;
    private JComboBox functionBox;
    private JPanel percentPanel;
    private JTextField percentField;
    private JPanel amountPanel;
    private JTextField currencyField;
    private JTextField amountField;
    private List<PrubaeComboItem> comboItems;

    @Override
    protected void createButtons() {
        this.setStatementField(new JTextField("", 16));
        this.getStatementField().setEditable(false);
        JPanel doPanel = new JPanel();
        doPanel.setLayout(new BoxLayout(doPanel, 0));
        JLabel doLabel = new JLabel("Do : ");
        doPanel.add(doLabel);
        doPanel.add(this.getStatementField());
        this.getPanel().add(doPanel);
        this.setFunctionBox(new JComboBox());
        this.getFunctionBox().setMaximumRowCount(4);
        this.getFunctionBox().setActionCommand("select function");
        this.setPercentPanel(new JPanel());
        this.setPercentField(new JTextField("", 4));
        JLabel percentLabel = new JLabel("% of");
        this.getPercentPanel().setLayout(new BoxLayout(this.getPercentPanel(), 0));
        this.getPercentPanel().add(this.getPercentField());
        this.getPercentPanel().add(percentLabel);
        JPanel doFPanel = new JPanel();
        doFPanel.setLayout(new BoxLayout(doFPanel, 0));
        doFPanel.add(this.getPercentPanel());
        doFPanel.add(this.getFunctionBox());
        this.getPercentPanel().setVisible(false);
        this.getPanel().add(doFPanel);
        this.setAmountPanel(new JPanel());
        this.setCurrencyField(new JTextField("", 4));
        this.setAmountField(new JTextField("", 4));
        JLabel amountLabel = new JLabel("AMOUNT");
        this.getAmountPanel().setLayout(new BoxLayout(this.getAmountPanel(), 0));
        this.getAmountPanel().add(amountLabel);
        this.getAmountPanel().add(this.getCurrencyField());
        this.getAmountPanel().add(this.getAmountField());
        this.getAmountPanel().setVisible(false);
        this.getPanel().add(this.getAmountPanel());
    }

    @Override
    public void update() {
        PrubaeModelDoStatement model = (PrubaeModelDoStatement)this.getModel();
        if (this.getPercentPanel().isVisible() && this.getPercentField().isVisible()) {
            double value = 0.0;
            try {
                value = Double.parseDouble(this.getPercentField().getText());
            }
            catch (NumberFormatException e) {
                value = 0.0;
            }
            model.setPercent(value);
        } else {
            model.setPercent(0.0);
        }
        if (this.getAmountPanel().isVisible() && this.getCurrencyField().isVisible() && this.getAmountField().isVisible()) {
            System.err.println("amount visible");
            String currency = this.getCurrencyField().getText();
            double value = 0.0;
            try {
                value = Double.parseDouble(this.getAmountField().getText());
            }
            catch (NumberFormatException e) {
                value = 0.0;
            }
            model.getValues().set(0, currency);
            model.getValues().set(1, new Double(value));
        }
        model.updateStatement();
        super.update();
    }

    @Override
    public void createPanel() {
        LList doList;
        super.createPanel();
        PrubaeModelDoStatement model = (PrubaeModelDoStatement)this.getModel();
        LList list = this.getEditor().getDoList();
        if (model.getValues() != null) {
            int numArgs = model.getValues().size();
            doList = Lisp.assoc(new IntNum(model.getRegist()), list);
            if (doList != null) {
                int i;
                Object listArgs = Lisp.cdr(Lisp.cdr(Lisp.cdr(Lisp.cdr(Lisp.cdr(doList)))));
                Object[] typeArgs = new Object[numArgs];
                for (i = 0; i < numArgs; ++i) {
                    typeArgs[i] = Lisp.car(listArgs);
                    listArgs = Lisp.cdr(listArgs);
                    System.err.println("PrubaeControllerDoStatement.createPanel(): typeArgs[" + i + "] = " + typeArgs[i]);
                }
                for (i = 0; i < model.getValues().size(); ++i) {
                    if (!(model.getValues().get(i) instanceof PrubaeModelValue)) continue;
                    PrubaeModelValue child = (PrubaeModelValue)model.getValues().get(i);
                    if (child instanceof PrubaeModelValueStatement) {
                        if (i > 0 && typeArgs[i] != null && typeArgs[i].equals("first")) {
                            child.setRequiredType(((PrubaeModelValue)model.getValues().get(0)).getType());
                        } else if (((PrubaeModel)model.getValues().get(i)).getRegist() == 321 && ((PrubaeModelValue)model.getValues().get(i)).getRequiredType() != null) {
                            child.setRequiredType(((PrubaeModelValue)model.getValues().get(i)).getRequiredType());
                        } else if (((PrubaeModel)model.getValues().get(i)).getRegist() == 321 && ((PrubaeModelValue)model.getValues().get(i)).getType() != null) {
                            child.setRequiredType(((PrubaeModelValue)model.getValues().get(i)).getType());
                        } else if (((PrubaeModel)model.getValues().get(i)).getRegist() == 322 && ((PrubaeModelValue)model.getValues().get(i)).getRequiredType() != null) {
                            child.setRequiredType(((PrubaeModelValue)model.getValues().get(i)).getRequiredType());
                        } else if (((PrubaeModel)model.getValues().get(i)).getRegist() == 322 && ((PrubaeModelValue)model.getValues().get(i)).getType() != null) {
                            child.setRequiredType(((PrubaeModelValue)model.getValues().get(i)).getType());
                        } else if (typeArgs[i] != null) {
                            child.setRequiredType(typeArgs[i]);
                        }
                    }
                    if (child.getController() == null) {
                        child.openUI();
                    }
                    child.getController().createPanel();
                }
            }
        }
        this.setComboItems(new Vector());
        PrubaeComboItem item = new PrubaeComboItem("", "");
        this.getComboItems().add(item);
        this.getFunctionBox().addItem(item);
        while (!Lisp.isNil(list)) {
            doList = (LList)Lisp.car(list);
            String dispStr = Lisp.car(Lisp.cdr(doList)).toString();
            String itemStr = Lisp.car(Lisp.cdr(Lisp.cdr(doList))).toString();
            item = new PrubaeComboItem(dispStr, itemStr);
            this.getComboItems().add(item);
            this.getFunctionBox().addItem(item);
            list = (LList)Lisp.cdr(list);
        }
        this.getFunctionBox().addActionListener(this);
    }

    @Override
    public void destroyPanel() {
        this.setStatementField(null);
        this.setFunctionBox(null);
        this.setPercentPanel(null);
        this.setPercentField(null);
        this.setAmountPanel(null);
        this.setCurrencyField(null);
        this.setAmountField(null);
        super.destroyPanel();
    }

    protected void select(String selected) {
        PrubaeModelDoStatement model = (PrubaeModelDoStatement)this.getModel();
        LList list = this.getEditor().getDoList();
        while (!Lisp.isNil(list)) {
            LList doList = (LList)Lisp.car(list);
            String itemStr = Lisp.car(Lisp.cdr(Lisp.cdr(doList))).toString();
            if (selected.equals(itemStr)) {
                short regist = (short)((IntNum)Lisp.car(doList)).intValue();
                if (model.getRegist() == regist && model.getName().equals(selected)) break;
                if (model.getValues() != null) {
                    for (int i = 0; i < model.getValues().size(); ++i) {
                        if (!(model.getValues().get(i) instanceof PrubaeModel)) continue;
                        ((PrubaeModel)model.getValues().get(i)).closeUI();
                    }
                    model.getValues().clear();
                }
                model.setRegist(regist);
                model.setName(selected);
                this.percent(doList);
                this.arguments(doList);
                model.updateStatement();
                this.getStatementField().setText(model.getStatement());
                break;
            }
            list = (LList)Lisp.cdr(list);
        }
    }

    private void percent(LList doList) {
        PrubaeModelDoStatement model = (PrubaeModelDoStatement)this.getModel();
        Object isPercent = Lisp.car(Lisp.cdr(Lisp.cdr(Lisp.cdr(doList))));
        if (isPercent == null || Lisp.isNil(isPercent)) {
            model.setPercent(0.0);
            this.getPercentField().setText("");
            this.getPercentPanel().setVisible(false);
        } else {
            System.err.println("isPercent not nil, percent set visible");
            if (model.getPercent() != 0.0) {
                String percentStr = Double.toString(model.getPercent());
                this.getPercentField().setText(percentStr);
            } else {
                this.getPercentField().setText("");
            }
            this.getPercentPanel().setVisible(true);
        }
    }

    private void arguments(LList doList) {
        int i;
        PrubaeModelDoStatement model = (PrubaeModelDoStatement)this.getModel();
        Object isArgs = Lisp.car(Lisp.cdr(Lisp.cdr(Lisp.cdr(Lisp.cdr(doList)))));
        this.getAmountPanel().setVisible(false);
        System.err.println("do controller Arguments : judgeList = " + doList);
        if (isArgs == null) {
            return;
        }
        if (!(isArgs instanceof IntNum)) {
            return;
        }
        System.err.println("numArgs = " + isArgs);
        int numArgs = ((IntNum)isArgs).intValue();
        if (numArgs <= 0) {
            return;
        }
        System.err.println("do controller Arguments = " + numArgs);
        Object listArgs = Lisp.cdr(Lisp.cdr(Lisp.cdr(Lisp.cdr(Lisp.cdr(doList)))));
        Object[] typeArgs = new Object[numArgs];
        for (i = 0; i < numArgs; ++i) {
            typeArgs[i] = Lisp.car(listArgs);
            listArgs = Lisp.cdr(listArgs);
        }
        if (model.getValues() == null) {
            model.setValues(new Vector());
        }
        if (numArgs == 1 && typeArgs[0] != null && typeArgs[0].equals("setamount")) {
            model.getValues().add("");
            model.getValues().add(new Double(0.0));
            this.getAmountPanel().setVisible(true);
            return;
        }
        for (i = 0; i < numArgs && typeArgs[i] != null; ++i) {
            PrubaeModelValueStatement ret;
            String type = typeArgs[i] instanceof Pair ? (String)Lisp.car(typeArgs[i]) : (String)typeArgs[i];
            if (type.equals("setnumber")) {
                ret = new PrubaeModelValueStatement();
                ret.setRegist((short)513);
                ret.setComment("");
                ret.setStatement("0");
                ret.setValues(new Vector());
                ret.getValues().add(new Double(0.0));
                ret.setType(typeArgs[i]);
                ret.initialize(this.getEditor(), model, model.getValues());
                ((PrubaeModel)ret).openUI();
                model.getValues().add(ret);
                this.getPanel().add(ret.getController().getPanel());
                continue;
            }
            if (type.equals("setdate")) {
                ret = new PrubaeModelValueStatement();
                ret.setRegist((short)514);
                ret.setComment("");
                ret.setStatement("0/0");
                ret.setValues(new Vector());
                ret.getValues().add(new Short(0));
                ret.getValues().add(new Short(0));
                ret.setType(typeArgs[i]);
                ret.initialize(this.getEditor(), model, model.getValues());
                ((PrubaeModel)ret).openUI();
                model.getValues().add(ret);
                this.getPanel().add(ret.getController().getPanel());
                continue;
            }
            if (type.equals("setstring")) {
                ret = new PrubaeModelValueStatement();
                ret.setRegist((short)516);
                ret.setComment("");
                ret.setStatement("\"\"");
                ret.setValues(new Vector());
                ret.getValues().add("");
                ret.setType(typeArgs[i]);
                ret.initialize(this.getEditor(), model, model.getValues());
                ((PrubaeModel)ret).openUI();
                model.getValues().add(ret);
                this.getPanel().add(ret.getController().getPanel());
                continue;
            }
            if (type.equals("setamount")) {
                ret = new PrubaeModelValueStatement();
                ret.setRegist((short)520);
                ret.setComment("");
                ret.setValues(new Vector());
                ret.getValues().add("");
                ret.getValues().add(new Double(0.0));
                ret.setType(typeArgs[i]);
                ret.initialize(this.getEditor(), model, model.getValues());
                ((PrubaeModel)ret).openUI();
                model.getValues().add(ret);
                this.getPanel().add(ret.getController().getPanel());
                continue;
            }
            if (type.equals("setpath")) continue;
            ret = new PrubaeModelValueStatement();
            ret.setComment("");
            ret.setStatement("");
            ret.setType(typeArgs[i]);
            ret.initialize(this.getEditor(), model, model.getValues());
            ((PrubaeModel)ret).openUI();
            model.getValues().add(ret);
            this.getPanel().add(ret.getController().getPanel());
        }
    }

    public void activateSelection() {
        this.getFunctionBox().setActionCommand("select function");
    }

    public void inactivateSelection() {
        this.getFunctionBox().setActionCommand("nop");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("delete")) {
            PrubaeController cntl = this.getEditor().getController();
            System.err.println("PrubaeControllerDoStatement.actionPerformed(delete) : this cntl = " + this + ", editor cntl = " + cntl);
            if (this == cntl) {
                this.deleteAndUp();
            } else {
                this.delete();
            }
        } else if (e.getActionCommand().equals("insert")) {
            this.insert();
        } else if (e.getActionCommand().equals("select function")) {
            PrubaeComboItem selected = (PrubaeComboItem)((JComboBox)e.getSource()).getSelectedItem();
            this.select(selected.getItemString());
        } else if (e.getActionCommand().equals("nop")) {
            // empty if block
        }
    }

    @Override
    void createPopupMenu() {
        JMenuItem mi = null;
        this.setPopupMenu(new JPopupMenu());
        mi = new JMenuItem("delete this action");
        mi.setActionCommand("delete");
        mi.addActionListener(this);
        this.getPopupMenu().add(mi);
        mi = new JMenuItem("insert action before this");
        mi.setActionCommand("insert");
        mi.addActionListener(this);
        this.getPopupMenu().add(mi);
    }

    @Override
    public Object clone() {
        PrubaeControllerDoStatement clone = null;
        clone = (PrubaeControllerDoStatement)super.clone();
        if (this.getStatementField() != null) {
            clone.setStatementField(new JTextField());
        }
        if (this.getFunctionBox() != null) {
            clone.setFunctionBox(new JComboBox());
            clone.getFunctionBox().setSelectedItem(this.getFunctionBox().getSelectedItem());
        }
        if (this.getPercentPanel() != null) {
            clone.setPercentPanel(new JPanel());
        }
        if (this.getPercentField() != null) {
            clone.setPercentField(new JTextField());
        }
        if (this.getAmountPanel() != null) {
            clone.setAmountPanel(new JPanel());
        }
        if (this.getCurrencyField() != null) {
            clone.setCurrencyField(new JTextField());
        }
        if (this.getAmountField() != null) {
            clone.setAmountField(new JTextField());
        }
        return clone;
    }

    public void setStatementField(JTextField theStatementField) {
        this.statementField = theStatementField;
    }

    public JTextField getStatementField() {
        return this.statementField;
    }

    public void setFunctionBox(JComboBox theFunctionBox) {
        this.functionBox = theFunctionBox;
    }

    public JComboBox getFunctionBox() {
        return this.functionBox;
    }

    public void setPercentPanel(JPanel thePercentPanel) {
        this.percentPanel = thePercentPanel;
    }

    public JPanel getPercentPanel() {
        return this.percentPanel;
    }

    public void setPercentField(JTextField thePercentField) {
        this.percentField = thePercentField;
    }

    public JTextField getPercentField() {
        return this.percentField;
    }

    public void setAmountPanel(JPanel theAmountPanel) {
        this.amountPanel = theAmountPanel;
    }

    public JPanel getAmountPanel() {
        return this.amountPanel;
    }

    public void setCurrencyField(JTextField theCurrencyField) {
        this.currencyField = theCurrencyField;
    }

    public JTextField getCurrencyField() {
        return this.currencyField;
    }

    public void setAmountField(JTextField theAmountField) {
        this.amountField = theAmountField;
    }

    public JTextField getAmountField() {
        return this.amountField;
    }

    public List getComboItems() {
        return this.comboItems;
    }

    public void setComboItems(List comboItems) {
        this.comboItems = comboItems;
    }

    public PrubaeComboItem getComboItem(String itemStr) {
        for (int i = 0; i < this.getComboItems().size(); ++i) {
            PrubaeComboItem ret = (PrubaeComboItem)this.getComboItems().get(i);
            if (!itemStr.equals(ret.getItemString())) continue;
            return ret;
        }
        return (PrubaeComboItem)this.getComboItems().get(0);
    }
}

