/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prubae;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.tree.DefaultMutableTreeNode;
import jp.sourceforge.gnp.prubae.PrubaeControllerJudge;
import jp.sourceforge.gnp.prubae.PrubaeModel;
import jp.sourceforge.gnp.prubae.PrubaeModelAndOr;

public class PrubaeControllerAndOr
extends PrubaeControllerJudge {
    private JRadioButton andButton;
    private JRadioButton orButton;

    @Override
    protected void createButtons() {
        super.createButtons();
        this.setAndButton(new JRadioButton("AND"));
        this.andButton.setActionCommand("And");
        this.andButton.addActionListener(this);
        this.setOrButton(new JRadioButton("OR"));
        this.orButton.setActionCommand("Or");
        this.orButton.addActionListener(this);
        ButtonGroup group = new ButtonGroup();
        group.add(this.andButton);
        group.add(this.orButton);
        this.andButton.setSelected(((PrubaeModelAndOr)this.getModel()).isAnd());
        this.orButton.setSelected(!((PrubaeModelAndOr)this.getModel()).isAnd());
        JPanel opPanel = new JPanel();
        opPanel.setLayout(new BoxLayout(opPanel, 0));
        opPanel.add(this.andButton);
        opPanel.add(this.orButton);
        this.getPanel().add(opPanel);
    }

    @Override
    public void initialize() {
        super.initialize();
        List vec = ((PrubaeModelAndOr)this.getModel()).getStatements();
        if (vec != null) {
            for (int i = 0; i < vec.size(); ++i) {
                DefaultMutableTreeNode node = ((PrubaeModel)vec.get(i)).getController().getTreeNode();
                this.getTreeNode().add(node);
            }
        }
    }

    public void setTreeNodes() {
        PrubaeModel car = (PrubaeModel)((PrubaeModelAndOr)this.getModel()).getStatements().get(0);
        PrubaeModel cdr = (PrubaeModel)((PrubaeModelAndOr)this.getModel()).getStatements().get(1);
        this.getTreeNode().add(car.getController().getTreeNode());
        this.getTreeNode().add(cdr.getController().getTreeNode());
        this.getEditor().getTreeModel().reload(this.getTreeNode());
    }

    @Override
    public void destroyPanel() {
        this.setAndButton(null);
        this.setOrButton(null);
        super.destroyPanel();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("And")) {
            this.andButton.setSelected(true);
            this.orButton.setSelected(false);
            ((PrubaeModelAndOr)this.getModel()).setAnd(true);
            this.getModel().setRegist((short)289);
            this.getView().display();
        } else if (e.getActionCommand().equals("Or")) {
            this.andButton.setSelected(false);
            this.orButton.setSelected(true);
            ((PrubaeModelAndOr)this.getModel()).setAnd(false);
            this.getModel().setRegist((short)290);
            this.getView().display();
        } else {
            super.actionPerformed(e);
        }
    }

    public void setAndButton(JRadioButton theAndButton) {
        this.andButton = theAndButton;
    }

    public JRadioButton getAndButton() {
        return this.andButton;
    }

    public void setOrButton(JRadioButton theOrButton) {
        this.orButton = theOrButton;
    }

    public JRadioButton getOrButton() {
        return this.orButton;
    }
}

