/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prubae;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import jp.sourceforge.gnp.prubae.Prubae;
import jp.sourceforge.gnp.prubae.PrubaeModel;
import jp.sourceforge.gnp.prubae.PrubaeView;

public abstract class PrubaeController
implements ActionListener,
Cloneable {
    protected DefaultMutableTreeNode treeNode = null;
    protected JPanel panel;
    protected PrubaeModel model = null;
    protected PrubaeView view = null;
    protected Prubae editor = null;
    private JTextField commentField = null;
    private JPopupMenu popupMenu = null;

    public void initialize() {
        if (this.getTreeNode() == null) {
            this.setTreeNode(new DefaultMutableTreeNode(this));
            this.getTreeNode().setUserObject(this);
            this.createPopupMenu();
        }
    }

    abstract void createPopupMenu();

    public void open() {
        PrubaeController old = this.getEditor().getController();
        if (old != null && old != this) {
            old.close();
        }
        this.getEditor().setController(this);
        this.getEditor().setView(this.getView());
        if (this.getPanel() == null) {
            this.createPanel();
        }
        this.getEditor().getPartPanel().add(this.getPanel());
        this.getView().display();
    }

    public void close() {
        if (this.getPanel() != null) {
            this.update();
            this.getModel().closeUI();
            this.getEditor().setController(null);
            this.getEditor().setView(null);
            this.getEditor().getPartPanel().remove(this.getPanel());
        }
        this.destroyPanel();
    }

    public void update() {
        this.getModel().setComment(this.getCommentField().getText());
        this.getView().display();
    }

    public void createPanel() {
        this.setPanel(new JPanel());
        this.getPanel().setLayout(new BoxLayout(this.getPanel(), 1));
        this.setCommentField(new JTextField());
        this.getCommentField().setEditable(true);
        JPanel commentPanel = new JPanel();
        commentPanel.setLayout(new BoxLayout(commentPanel, 0));
        JLabel commentLabel = new JLabel("C : ");
        commentPanel.add(commentLabel);
        JScrollPane commentScrollPane = new JScrollPane();
        commentScrollPane.getViewport().add(this.getCommentField());
        commentScrollPane.setHorizontalScrollBarPolicy(32);
        commentPanel.add(commentScrollPane);
        this.getPanel().add(commentPanel);
    }

    public void destroyPanel() {
        if (this.getPanel() != null) {
            this.getPanel().removeAll();
        }
        this.setPanel(null);
        this.setCommentField(null);
    }

    public void insertTreeNode(DefaultMutableTreeNode parent, TreeNode child) {
        int index = parent.getIndex(child);
        System.err.println("PrubaeController.insertTreeNode() : index = " + index + ", insertNode = " + this.getTreeNode());
        parent.insert(this.getTreeNode(), index);
        if (this.getEditor().getTreeModel() != null) {
            this.getEditor().getTreeModel().reload(parent);
        }
        this.getEditor().setTreeSelection((DefaultMutableTreeNode)child);
    }

    public void addTreeNode(DefaultMutableTreeNode parent) {
        parent.add(this.getTreeNode());
        if (this.getEditor().getTreeModel() != null) {
            this.getEditor().getTreeModel().reload(parent);
        }
    }

    public void swapTreeNode(DefaultMutableTreeNode parent, TreeNode child) {
        int index = parent.getIndex(child);
        System.err.println("PrubaeController.swapTreeNode() : index = " + index + ", insertNode = " + this.getTreeNode());
        parent.remove(index);
        parent.insert(this.getTreeNode(), index);
        if (this.getEditor().getTreeModel() != null) {
            this.getEditor().getTreeModel().reload(parent);
        }
        this.getEditor().setTreeSelection(this.getTreeNode());
    }

    public void deleteTreeNode() {
        DefaultMutableTreeNode child = this.getTreeNode();
        if (child == null) {
            return;
        }
        child.removeFromParent();
        this.setTreeNode(null);
        if (this.getEditor().getTreeModel() != null) {
            this.getEditor().getTreeModel().reload(child);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public String toString() {
        return this.model.toString();
    }

    protected void deleteAndUp() {
        System.err.println("PrubaeController.deleteAndUp() : cntl = " + this);
        PrubaeController parent = this.getModel().getParent().getController();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getTreeNode().getParent();
        this.getModel().delete();
        parent.open();
        if (node != null) {
            parent.getEditor().setTreeSelection(node);
        }
    }

    protected void delete() {
        System.err.println("PrubaeController.delete() : cntl = " + this);
        Prubae editor = this.getEditor();
        PrubaeController currentCntl = editor.getController();
        this.getModel().delete();
        editor.setController(currentCntl);
        editor.setView(currentCntl.getView());
        DefaultMutableTreeNode node = currentCntl.getTreeNode();
        if (node != null) {
            editor.setTreeSelection(node);
        }
    }

    public Object clone() {
        PrubaeController clone = null;
        try {
            clone = (PrubaeController)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        if (this.getTreeNode() != null) {
            clone.setTreeNode(new DefaultMutableTreeNode(clone));
            clone.getTreeNode().setUserObject(clone);
            clone.createPopupMenu();
        }
        if (this.getPanel() != null) {
            clone.setPanel(new JPanel());
        }
        if (this.getCommentField() != null) {
            clone.setCommentField(new JTextField());
        }
        return clone;
    }

    public void setTreeNode(DefaultMutableTreeNode theTreeNode) {
        this.treeNode = theTreeNode;
    }

    public DefaultMutableTreeNode getTreeNode() {
        return this.treeNode;
    }

    public void setPanel(JPanel thePanel) {
        this.panel = thePanel;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void setModel(PrubaeModel theModel) {
        this.model = theModel;
    }

    public PrubaeModel getModel() {
        return this.model;
    }

    public void setView(PrubaeView theView) {
        this.view = theView;
    }

    public PrubaeView getView() {
        return this.view;
    }

    public void setEditor(Prubae theEditor) {
        this.editor = theEditor;
    }

    public Prubae getEditor() {
        return this.editor;
    }

    public void setCommentField(JTextField theCommentField) {
        this.commentField = theCommentField;
    }

    public JTextField getCommentField() {
        return this.commentField;
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        this.popupMenu = popupMenu;
    }
}

