/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.audit.struts.action;

import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.sourceforge.gnp.audit.struts.IConstants;
import jp.sourceforge.gnp.audit.struts.form.AuditForm;
import jp.sourceforge.gnp.audit.struts.service.IAuditService;
import jp.sourceforge.gnp.audit.struts.view.AuditView;
import jp.sourceforge.gnp.audit.struts.view.ProrateView;
import jp.sourceforge.gnp.prorate.export.ProrateAudit;
import jp.sourceforge.gnp.prorate.export.ProrateSector;
import jp.sourceforge.gnp.prorate.export.ProrateTaxData;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;

public abstract class AuditAction
extends DispatchAction {
    String errorString = "";

    public ActionForward persist(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = null;
        AuditForm iform = (AuditForm)form;
        String errorId = null;
        String errorItem = null;
        String ticketNumber = iform.getTicketNumber();
        if (ticketNumber == null || ticketNumber.length() < 4) {
            errorId = "ticketNumber";
            errorItem = iform.getTicketNumber();
            String errorString = errorId + " [" + errorItem + "] : illegal TicketNumber ";
            AuditView errorView = new AuditView();
            this.copy(iform, errorView);
            errorView.setErrorString(errorString);
            request.getSession(false).setAttribute(IConstants.AUDIT_VIEW_KEY, (Object)errorView);
            forward = mapping.findForward(IConstants.AUDIT_KEY);
            return forward;
        }
        ProrateAudit audit = new ProrateAudit();
        audit.setAirwayNumber(ticketNumber.substring(0, 3));
        audit.setOwnAudit(false);
        audit.setTicketing(false);
        audit.setInward(false);
        String prorateType = iform.getProrateType();
        if (prorateType.equals("issued by own carrier")) {
            audit.setOwnAudit(true);
            audit.setTicketing(true);
        } else if (prorateType.equals("inward")) {
            audit.setOwnAudit(true);
            audit.setInward(true);
        }
        audit.setTraceLevel(iform.getTraceLevel().equals("detail") ? 10000 : 0);
        audit.setOwnAirwayId(iform.getOwnAirwayId());
        if (audit.getOwnAirwayId() == null || audit.getOwnAirwayId().length() == 0) {
            errorId = "ownAirwayId";
            errorItem = iform.getOwnAirwayId();
            String errorString = errorId + " [" + errorItem + "] : Own Airway Id not defined ";
            AuditView errorView = new AuditView();
            this.copy(iform, errorView);
            errorView.setErrorString(errorString);
            request.getSession(false).setAttribute(IConstants.AUDIT_VIEW_KEY, (Object)errorView);
            forward = mapping.findForward(IConstants.AUDIT_KEY);
            return forward;
        }
        int ticketCoupon = -1;
        try {
            errorId = "couponNumber";
            errorItem = iform.getCouponNumber();
            if (iform.getCouponNumber() != null && iform.getCouponNumber().length() > 0) {
                ticketCoupon = Integer.parseInt(iform.getCouponNumber());
            }
        }
        catch (NumberFormatException e) {
            String errorString = errorId + " [" + errorItem + "] : " + "Number Format Exception " + e.getMessage();
            AuditView errorView = new AuditView();
            this.copy(iform, errorView);
            errorView.setErrorString(errorString);
            request.getSession(false).setAttribute(IConstants.AUDIT_VIEW_KEY, (Object)errorView);
            forward = mapping.findForward(IConstants.AUDIT_KEY);
            return forward;
        }
        if (ticketCoupon >= 0) {
            ticketNumber = ticketNumber + ticketCoupon;
        }
        audit.setAirwayNumber(iform.getAirwayNumber());
        if (audit.getAirwayNumber() == null || audit.getAirwayNumber().length() < 3) {
            audit.setAirwayNumber(ticketNumber.substring(0, 3));
        }
        audit.setInwardNumber(iform.getInwardNumber());
        audit.setEndorsement(iform.getEndorsement());
        audit.setIssueDate(iform.getIssueDate());
        audit.setInvoiceMonth(iform.getInvoiceMonth());
        audit.setIssuePlace(iform.getIssuePlace());
        audit.setOrigin(iform.getOrigin());
        audit.setDestination(iform.getDestination());
        audit.setCurrency(iform.getCurrency());
        audit.setSalesCurrency(iform.getSalesCurrency());
        audit.setFareCalculation(iform.getFareCalculation());
        audit.setTourCode(iform.getTourCode());
        audit.setAgentCode(iform.getAgentCode());
        try {
            errorId = "ticketFare";
            errorItem = iform.getTicketFare();
            audit.setTicketFare(iform.getTicketFare().length() > 0 ? Double.parseDouble(iform.getTicketFare()) : 0.0);
            errorId = "salesFare";
            errorItem = iform.getSalesFare();
            audit.setSalesFare(iform.getSalesFare().length() > 0 ? Double.parseDouble(iform.getSalesFare()) : 0.0);
            errorId = "totalNuc";
            errorItem = iform.getTotalNuc();
            audit.setTotalNuc(iform.getTotalNuc().length() > 0 ? Double.parseDouble(iform.getTotalNuc()) : 0.0);
            errorId = "lessAmt";
            errorItem = iform.getLessAmt();
            audit.setLessAmt(iform.getLessAmt().length() > 0 ? Double.parseDouble(iform.getLessAmt()) : 0.0);
            errorId = "stopOverCharge";
            errorItem = iform.getStopOverCharge();
            audit.setStopOverCharge(iform.getStopOverCharge().length() > 0 ? Double.parseDouble(iform.getStopOverCharge()) : 0.0);
            errorId = "commissionRate";
            errorItem = iform.getCommissionRate();
            audit.setCommissionRate(iform.getCommissionRate().length() > 0 ? Double.parseDouble(iform.getCommissionRate()) : 0.0);
        }
        catch (NumberFormatException e) {
            String errorString = errorId + " [" + errorItem + "] : " + "Number Format Exception " + e.getMessage();
            AuditView errorView = new AuditView();
            this.copy(iform, errorView);
            errorView.setErrorString(errorString);
            request.getSession(false).setAttribute(IConstants.AUDIT_VIEW_KEY, (Object)errorView);
            forward = mapping.findForward(IConstants.AUDIT_KEY);
            return forward;
        }
        if (audit.isOwnAudit() && audit.isTicketing()) {
            if (audit.getSalesCurrency().equals("")) {
                audit.setSalesCurrency(audit.getCurrency());
            }
            if (audit.getSalesFare() == 0.0) {
                audit.setSalesFare(audit.getTicketFare());
            }
        }
        audit.setNotDivideTax(iform.isNotDivideTax());
        Vector<ProrateTaxData> taxes = new Vector<ProrateTaxData>();
        for (int i = 0; i < iform.getNumTaxes(); ++i) {
            if (iform.getTaxType(i) == null || iform.getTaxType(i).length() <= 0) continue;
            ProrateTaxData tax = new ProrateTaxData();
            tax.setType(iform.getTaxType(i));
            try {
                errorId = "taxAmount" + i;
                errorItem = iform.getTaxAmount(i);
                tax.setAmount(iform.getTaxAmount(i).length() > 0 ? Double.parseDouble(iform.getTaxAmount(i)) : 0.0);
            }
            catch (NumberFormatException e) {
                String errorString = errorId + " [" + errorItem + "] : " + "Number Format Exception " + e.getMessage();
                AuditView errorView = new AuditView();
                this.copy(iform, errorView);
                errorView.setErrorString(errorString);
                request.getSession(false).setAttribute(IConstants.AUDIT_VIEW_KEY, (Object)errorView);
                forward = mapping.findForward(IConstants.AUDIT_KEY);
                return forward;
            }
            taxes.add(tax);
        }
        ProrateTaxData[] taxesArray = new ProrateTaxData[taxes.size()];
        for (int i = 0; i < taxes.size(); ++i) {
            taxesArray[i] = (ProrateTaxData)taxes.get(i);
        }
        audit.setTax(taxesArray);
        Vector<ProrateTaxData> taxMiscs = new Vector<ProrateTaxData>();
        for (int i = 0; i < iform.getNumTaxMiscs(); ++i) {
            if (iform.getTaxMiscType(i) == null || iform.getTaxMiscType(i).length() <= 0) continue;
            ProrateTaxData tax = new ProrateTaxData();
            tax.setType(iform.getTaxMiscType(i));
            try {
                errorId = "taxMiscAmount" + i;
                errorItem = iform.getTaxMiscAmount(i);
                tax.setAmount(iform.getTaxMiscAmount(i).length() > 0 ? Double.parseDouble(iform.getTaxMiscAmount(i)) : 0.0);
            }
            catch (NumberFormatException e) {
                String errorString = errorId + " [" + errorItem + "] : " + "Number Format Exception " + e.getMessage();
                AuditView errorView = new AuditView();
                this.copy(iform, errorView);
                errorView.setErrorString(errorString);
                request.getSession(false).setAttribute(IConstants.AUDIT_VIEW_KEY, (Object)errorView);
                forward = mapping.findForward(IConstants.AUDIT_KEY);
                return forward;
            }
            taxMiscs.add(tax);
        }
        ProrateTaxData[] taxMiscsArray = new ProrateTaxData[taxMiscs.size()];
        for (int i = 0; i < taxMiscs.size(); ++i) {
            taxMiscsArray[i] = (ProrateTaxData)taxMiscs.get(i);
        }
        audit.setTaxMisc(taxMiscsArray);
        Vector<ProrateSector> sectors = new Vector<ProrateSector>();
        for (int i = 0; i < iform.getNumSectors(); ++i) {
            if (iform.getDepCode(i).length() <= 0 || iform.getDestCode(i).length() <= 0 || iform.getCarrier(i).length() <= 0) continue;
            ProrateSector sector = new ProrateSector();
            sector.setSequenceNo(i);
            if (ticketCoupon >= 0 && i == ticketCoupon) {
                sector.setInvoiceFlg(true);
            }
            sector.setStopOver(iform.getStopOver(i).length() > 0 ? (byte)iform.getStopOver(i).charAt(0) : (byte)0);
            sector.setDepCode(iform.getDepCode(i));
            sector.setDestCode(iform.getDestCode(i));
            sector.setFareBasis(iform.getFareBasis(i));
            sector.setCarrier(iform.getCarrier(i));
            sector.setClassOfService(iform.getClassOfService(i));
            sector.setFlightNo(iform.getFlightNo(i));
            sector.setFlightDate(iform.getFlightDate(i));
            try {
                errorId = "fareComponent";
                errorItem = iform.getFareComponent(i);
                sector.setFareComponent(iform.getFareComponent(i).length() > 0 ? Double.parseDouble(iform.getFareComponent(i)) : -1.0);
                errorId = "fareClassDiffPlus";
                errorItem = iform.getClassDiffPlus(i);
                sector.setClassDiffPlus(iform.getClassDiffPlus(i).length() > 0 ? Double.parseDouble(iform.getClassDiffPlus(i)) : 0.0);
                errorId = "secureCharge";
                errorItem = iform.getSecureCharge(i);
                sector.setSecureCharge(iform.getSecureCharge(i).length() > 0 ? Double.parseDouble(iform.getSecureCharge(i)) : 0.0);
                errorId = "sideTripPlus";
                errorItem = iform.getSideTripPlus(i);
                sector.setSideTripPlus(iform.getSideTripPlus(i).length() > 0 ? Double.parseDouble(iform.getSideTripPlus(i)) : 0.0);
                errorId = "stopOverPlus";
                errorItem = iform.getStopOverPlus(i);
                sector.setStopOverPlus(iform.getStopOverPlus(i).length() > 0 ? Double.parseDouble(iform.getStopOverPlus(i)) : 0.0);
                errorId = "tax";
                errorItem = iform.getTax(i);
                sector.setTax(0.0);
            }
            catch (NumberFormatException e) {
                String errorString = errorId + " [" + errorItem + "] in sector " + i + " : " + "Number Format Exception " + e.getMessage();
                AuditView errorView = new AuditView();
                this.copy(iform, errorView);
                errorView.setErrorString(errorString);
                request.getSession(false).setAttribute(IConstants.AUDIT_VIEW_KEY, (Object)errorView);
                forward = mapping.findForward(IConstants.AUDIT_KEY);
                return forward;
            }
            sectors.add(sector);
        }
        ProrateSector[] sectorsArray = new ProrateSector[sectors.size()];
        for (int j = 0; j < sectors.size(); ++j) {
            sectorsArray[j] = (ProrateSector)sectors.get(j);
        }
        audit.setSectors(sectorsArray);
        System.err.println("audit.getSectors().length=" + audit.getSectors().length);
        if (audit.getSectors().length == 0) {
            String errorString = "no sectors in audit";
            AuditView errorView = new AuditView();
            this.copy(iform, errorView);
            errorView.setErrorString(errorString);
            request.getSession(false).setAttribute(IConstants.AUDIT_VIEW_KEY, (Object)errorView);
            forward = mapping.findForward(IConstants.AUDIT_KEY);
            return forward;
        }
        IAuditService service = this.createAuditService();
        if (service == null) {
            AuditView errorView = new AuditView();
            this.copy(iform, errorView);
            errorView.setErrorString("Audit Service creation is failed");
            request.getSession(false).setAttribute(IConstants.AUDIT_VIEW_KEY, (Object)errorView);
            forward = mapping.findForward(IConstants.AUDIT_KEY);
            return forward;
        }
        AuditView auditView = service.persist(ticketNumber, audit);
        if (auditView == null) {
            AuditView errorView = new AuditView();
            this.copy(iform, errorView);
            errorView.setErrorString("Audit persist Service returned null view");
            request.getSession(false).setAttribute(IConstants.AUDIT_VIEW_KEY, (Object)errorView);
            forward = mapping.findForward(IConstants.AUDIT_KEY);
            return forward;
        }
        request.getSession(false).setAttribute(IConstants.AUDIT_VIEW_KEY, (Object)auditView);
        forward = mapping.findForward(IConstants.AUDIT_KEY);
        return forward;
    }

    public ActionForward remove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = null;
        AuditForm iform = (AuditForm)form;
        String errorId = null;
        String errorItem = null;
        String ticketNumber = iform.getTicketNumber();
        if (ticketNumber == null || ticketNumber.length() < 4) {
            errorId = "ticketNumber";
            errorItem = iform.getTicketNumber();
            String errorString = errorId + " [" + errorItem + "] : illegal TicketNumber ";
            AuditView errorView = new AuditView();
            this.copy(iform, errorView);
            errorView.setErrorString(errorString);
            request.getSession(false).setAttribute(IConstants.AUDIT_VIEW_KEY, (Object)errorView);
            forward = mapping.findForward(IConstants.AUDIT_KEY);
            return forward;
        }
        ProrateAudit audit = new ProrateAudit();
        audit.setAirwayNumber(ticketNumber.substring(0, 3));
        audit.setOwnAudit(false);
        audit.setTicketing(false);
        audit.setInward(false);
        String prorateType = iform.getProrateType();
        if (prorateType.equals("issued by own carrier")) {
            audit.setOwnAudit(true);
            audit.setTicketing(true);
        } else if (prorateType.equals("inward")) {
            audit.setOwnAudit(true);
            audit.setInward(true);
        }
        audit.setTraceLevel(iform.getTraceLevel().equals("detail") ? 10000 : 0);
        audit.setOwnAirwayId(iform.getOwnAirwayId());
        if (audit.getOwnAirwayId() == null || audit.getOwnAirwayId().length() == 0) {
            errorId = "ownAirwayId";
            errorItem = iform.getOwnAirwayId();
            String errorString = errorId + " [" + errorItem + "] : Own Airway Id not defined ";
            AuditView errorView = new AuditView();
            this.copy(iform, errorView);
            errorView.setErrorString(errorString);
            request.getSession(false).setAttribute(IConstants.AUDIT_VIEW_KEY, (Object)errorView);
            forward = mapping.findForward(IConstants.AUDIT_KEY);
            return forward;
        }
        if (!audit.isOwnAudit() || audit.isInward()) {
            int ticketCoupon = -1;
            try {
                errorId = "couponNumber";
                errorItem = iform.getCouponNumber();
                if (iform.getCouponNumber() != null && iform.getCouponNumber().length() > 0) {
                    ticketCoupon = Integer.parseInt(iform.getCouponNumber());
                }
            }
            catch (NumberFormatException e) {
                String errorString = errorId + " [" + errorItem + "] : " + "Number Format Exception " + e.getMessage();
                AuditView errorView = new AuditView();
                this.copy(iform, errorView);
                errorView.setErrorString(errorString);
                request.getSession(false).setAttribute(IConstants.AUDIT_VIEW_KEY, (Object)errorView);
                forward = mapping.findForward(IConstants.AUDIT_KEY);
                return forward;
            }
            if (ticketCoupon >= 0) {
                ticketNumber = ticketNumber + ticketCoupon;
            }
        } else {
            iform.setCouponNumber("");
        }
        IAuditService service = this.createAuditService();
        if (service == null) {
            AuditView errorView = new AuditView();
            this.copy(iform, errorView);
            errorView.setErrorString("Audit Service creation is failed");
            request.getSession(false).setAttribute(IConstants.AUDIT_VIEW_KEY, (Object)errorView);
            forward = mapping.findForward(IConstants.AUDIT_KEY);
            return forward;
        }
        AuditView auditView = service.remove(ticketNumber, audit);
        if (auditView == null) {
            AuditView errorView = new AuditView();
            this.copy(iform, errorView);
            errorView.setErrorString("Audit remove Service returned null view");
            request.getSession(false).setAttribute(IConstants.AUDIT_VIEW_KEY, (Object)errorView);
            forward = mapping.findForward(IConstants.AUDIT_KEY);
            return forward;
        }
        this.copy(iform, auditView);
        request.getSession(false).setAttribute(IConstants.AUDIT_VIEW_KEY, (Object)auditView);
        forward = mapping.findForward(IConstants.AUDIT_KEY);
        return forward;
    }

    public ActionForward find(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = null;
        AuditForm iform = (AuditForm)form;
        String errorId = null;
        String errorItem = null;
        String ticketNumber = iform.getTicketNumber();
        if (ticketNumber == null || ticketNumber.length() < 4) {
            errorId = "ticketNumber";
            errorItem = iform.getTicketNumber();
            String errorString = errorId + " [" + errorItem + "] : illegal TicketNumber ";
            AuditView errorView = new AuditView();
            this.copy(iform, errorView);
            errorView.setErrorString(errorString);
            request.getSession(false).setAttribute(IConstants.AUDIT_VIEW_KEY, (Object)errorView);
            forward = mapping.findForward(IConstants.AUDIT_KEY);
            return forward;
        }
        ProrateAudit audit = new ProrateAudit();
        audit.setAirwayNumber(ticketNumber.substring(0, 3));
        audit.setOwnAudit(false);
        audit.setTicketing(false);
        audit.setInward(false);
        String prorateType = iform.getProrateType();
        if (prorateType.equals("issued by own carrier")) {
            audit.setOwnAudit(true);
            audit.setTicketing(true);
        } else if (prorateType.equals("inward")) {
            audit.setOwnAudit(true);
            audit.setInward(true);
        }
        audit.setTraceLevel(iform.getTraceLevel().equals("detail") ? 10000 : 0);
        audit.setOwnAirwayId(iform.getOwnAirwayId());
        if (audit.getOwnAirwayId() == null || audit.getOwnAirwayId().length() == 0) {
            errorId = "ownAirwayId";
            errorItem = iform.getOwnAirwayId();
            String errorString = errorId + " [" + errorItem + "] : Own Airway Id not defined ";
            AuditView errorView = new AuditView();
            this.copy(iform, errorView);
            errorView.setErrorString(errorString);
            request.getSession(false).setAttribute(IConstants.AUDIT_VIEW_KEY, (Object)errorView);
            forward = mapping.findForward(IConstants.AUDIT_KEY);
            return forward;
        }
        if (!audit.isOwnAudit() || audit.isInward()) {
            int ticketCoupon = -1;
            try {
                errorId = "couponNumber";
                errorItem = iform.getCouponNumber();
                if (iform.getCouponNumber() != null && iform.getCouponNumber().length() > 0) {
                    ticketCoupon = Integer.parseInt(iform.getCouponNumber());
                }
            }
            catch (NumberFormatException e) {
                String errorString = errorId + " [" + errorItem + "] : " + "Number Format Exception " + e.getMessage();
                AuditView errorView = new AuditView();
                this.copy(iform, errorView);
                errorView.setErrorString(errorString);
                request.getSession(false).setAttribute(IConstants.AUDIT_VIEW_KEY, (Object)errorView);
                forward = mapping.findForward(IConstants.AUDIT_KEY);
                return forward;
            }
            if (ticketCoupon >= 0) {
                ticketNumber = ticketNumber + ticketCoupon;
            }
        } else {
            iform.setCouponNumber("");
        }
        IAuditService service = this.createAuditService();
        if (service == null) {
            AuditView errorView = new AuditView();
            this.copy(iform, errorView);
            errorView.setErrorString("Audit Service creation is failed");
            request.getSession(false).setAttribute(IConstants.AUDIT_VIEW_KEY, (Object)errorView);
            forward = mapping.findForward(IConstants.AUDIT_KEY);
            return forward;
        }
        AuditView ret = service.find(ticketNumber, audit);
        if (ret == null) {
            AuditView errorView = new AuditView();
            this.copy(iform, errorView);
            errorView.setErrorString("Audit find Service returned null view");
            request.getSession(false).setAttribute(IConstants.AUDIT_VIEW_KEY, (Object)errorView);
            forward = mapping.findForward(IConstants.AUDIT_KEY);
            return forward;
        }
        if (!(ret instanceof ProrateView)) {
            AuditView errorView = ret;
            this.copy(iform, errorView);
            request.getSession(false).setAttribute(IConstants.AUDIT_VIEW_KEY, (Object)errorView);
            forward = mapping.findForward(IConstants.AUDIT_KEY);
            return forward;
        }
        ProrateView prorateView = (ProrateView)ret;
        request.getSession(false).setAttribute(IConstants.PRORATE_VIEW_KEY, (Object)prorateView);
        forward = mapping.findForward(IConstants.PRORATE_KEY);
        return forward;
    }

    public ActionForward prorate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = null;
        AuditForm iform = (AuditForm)form;
        String errorId = null;
        String errorItem = null;
        String ticketNumber = iform.getTicketNumber();
        if (ticketNumber == null || ticketNumber.length() < 4) {
            errorId = "ticketNumber";
            errorItem = iform.getTicketNumber();
            String errorString = errorId + " [" + errorItem + "] : illegal TicketNumber ";
            AuditView errorView = new AuditView();
            this.copy(iform, errorView);
            errorView.setErrorString(errorString);
            request.getSession(false).setAttribute(IConstants.AUDIT_VIEW_KEY, (Object)errorView);
            forward = mapping.findForward(IConstants.AUDIT_KEY);
            return forward;
        }
        ProrateAudit audit = new ProrateAudit();
        audit.setAirwayNumber(ticketNumber.substring(0, 3));
        audit.setOwnAudit(false);
        audit.setTicketing(false);
        audit.setInward(false);
        String prorateType = iform.getProrateType();
        if (prorateType.equals("issued by own carrier")) {
            audit.setOwnAudit(true);
            audit.setTicketing(true);
        } else if (prorateType.equals("inward")) {
            audit.setOwnAudit(true);
            audit.setInward(true);
        }
        audit.setTraceLevel(iform.getTraceLevel().equals("detail") ? 10000 : 0);
        audit.setOwnAirwayId(iform.getOwnAirwayId());
        if (audit.getOwnAirwayId() == null || audit.getOwnAirwayId().length() == 0) {
            errorId = "ownAirwayId";
            errorItem = iform.getOwnAirwayId();
            String errorString = errorId + " [" + errorItem + "] : Own Airway Id not defined ";
            AuditView errorView = new AuditView();
            this.copy(iform, errorView);
            errorView.setErrorString(errorString);
            request.getSession(false).setAttribute(IConstants.AUDIT_VIEW_KEY, (Object)errorView);
            forward = mapping.findForward(IConstants.AUDIT_KEY);
            return forward;
        }
        if (!audit.isOwnAudit() || audit.isInward()) {
            int ticketCoupon = -1;
            try {
                errorId = "couponNumber";
                errorItem = iform.getCouponNumber();
                if (iform.getCouponNumber() != null && iform.getCouponNumber().length() > 0) {
                    ticketCoupon = Integer.parseInt(iform.getCouponNumber());
                }
            }
            catch (NumberFormatException e) {
                String errorString = errorId + " [" + errorItem + "] : " + "Number Format Exception " + e.getMessage();
                AuditView errorView = new AuditView();
                this.copy(iform, errorView);
                errorView.setErrorString(errorString);
                request.getSession(false).setAttribute(IConstants.AUDIT_VIEW_KEY, (Object)errorView);
                forward = mapping.findForward(IConstants.AUDIT_KEY);
                return forward;
            }
            if (ticketCoupon >= 0) {
                ticketNumber = ticketNumber + ticketCoupon;
            }
        } else {
            iform.setCouponNumber("");
        }
        IAuditService service = this.createAuditService();
        if (service == null) {
            AuditView errorView = new AuditView();
            this.copy(iform, errorView);
            errorView.setErrorString("Audit Service creation is failed");
            request.getSession(false).setAttribute(IConstants.AUDIT_VIEW_KEY, (Object)errorView);
            forward = mapping.findForward(IConstants.AUDIT_KEY);
            return forward;
        }
        AuditView ret = service.prorate(ticketNumber, audit);
        if (ret == null) {
            AuditView errorView = new AuditView();
            this.copy(iform, errorView);
            errorView.setErrorString("Audit prorate Service returned null view");
            request.getSession(false).setAttribute(IConstants.AUDIT_VIEW_KEY, (Object)errorView);
            forward = mapping.findForward(IConstants.AUDIT_KEY);
            return forward;
        }
        if (!(ret instanceof ProrateView)) {
            AuditView errorView = ret;
            this.copy(iform, errorView);
            request.getSession(false).setAttribute(IConstants.AUDIT_VIEW_KEY, (Object)errorView);
            forward = mapping.findForward(IConstants.AUDIT_KEY);
            return forward;
        }
        ProrateView prorateView = (ProrateView)ret;
        if (prorateView.isFatalError()) {
            AuditView errorView = new AuditView();
            this.copy(iform, errorView);
            errorView.setErrorString(prorateView.getErrorString());
            request.getSession(false).setAttribute(IConstants.AUDIT_VIEW_KEY, (Object)errorView);
            forward = mapping.findForward(IConstants.AUDIT_KEY);
            return forward;
        }
        request.getSession(false).setAttribute(IConstants.PRORATE_VIEW_KEY, (Object)prorateView);
        forward = mapping.findForward(IConstants.PRORATE_KEY);
        return forward;
    }

    public ActionForward modify(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = null;
        AuditForm iform = (AuditForm)form;
        String errorId = null;
        String errorItem = null;
        String ticketNumber = iform.getTicketNumber();
        if (ticketNumber == null || ticketNumber.length() < 4) {
            errorId = "ticketNumber";
            errorItem = iform.getTicketNumber();
            String errorString = errorId + " [" + errorItem + "] : illegal TicketNumber ";
            AuditView errorView = new AuditView();
            this.copy(iform, errorView);
            errorView.setErrorString(errorString);
            request.getSession(false).setAttribute(IConstants.AUDIT_VIEW_KEY, (Object)errorView);
            forward = mapping.findForward(IConstants.AUDIT_KEY);
            return forward;
        }
        AuditView auditView = new AuditView();
        this.copy(iform, auditView);
        auditView.setTicketNumber(ticketNumber);
        request.getSession(false).setAttribute(IConstants.AUDIT_VIEW_KEY, (Object)auditView);
        forward = mapping.findForward(IConstants.AUDIT_KEY);
        return forward;
    }

    void copy(AuditForm form, AuditView view) {
        view.setTicketNumber(form.getTicketNumber());
        view.setFareCalculation(form.getFareCalculation());
        view.setOwnAirwayId(form.getOwnAirwayId());
        view.setAirwayNumber(form.getAirwayNumber());
        view.setCouponNumber(form.getCouponNumber());
        view.setInwardNumber(form.getInwardNumber());
        view.setEndorsement(form.getEndorsement());
        view.setIssueDate(form.getIssueDate());
        view.setIssuePlace(form.getIssuePlace());
        view.setInvoiceMonth(form.getInvoiceMonth());
        view.setOrigin(form.getOrigin());
        view.setDestination(form.getDestination());
        view.setCurrency(form.getCurrency());
        view.setTicketFare(form.getTicketFare());
        view.setSalesCurrency(form.getSalesCurrency());
        view.setSalesFare(form.getSalesFare());
        view.setPlusAdjustment(form.getPlusAdjustment());
        view.setLessAdjustment(form.getLessAdjustment());
        view.setCommissionCurrency(form.getCommissionCurrency());
        view.setCommissionRate(form.getCommissionRate());
        view.setCommissionAmt(form.getCommissionAmt());
        view.setTotalNuc(form.getTotalNuc());
        view.setLessAmt(form.getLessAmt());
        view.setStopOverCharge(form.getStopOverCharge());
        view.setTourCode(form.getTourCode());
        view.setAgentCode(form.getAgentCode());
        view.setTraceLevel(form.getTraceLevel());
        view.setTraceLevelList(form.getTraceLevelList());
        view.setProrateType(form.getProrateType());
        view.setProrateTypeList(form.getProrateTypeList());
        view.setTaxType(form.getTaxType());
        view.setTaxAmount(form.getTaxAmount());
        view.setTaxMiscType(form.getTaxMiscType());
        view.setTaxMiscAmount(form.getTaxMiscAmount());
        view.setStopOver(form.getStopOver());
        view.setDepCode(form.getDepCode());
        view.setDestCode(form.getDestCode());
        view.setFareBasis(form.getFareBasis());
        view.setCarrier(form.getCarrier());
        view.setClassOfService(form.getClassOfService());
        view.setFareComponent(form.getFareComponent());
        view.setFlightNo(form.getFlightNo());
        view.setFlightDate(form.getFlightDate());
        view.setClassDiffPlus(form.getClassDiffPlus());
        view.setSecureCharge(form.getSecureCharge());
        view.setSideTripPlus(form.getSideTripPlus());
        view.setStopOverPlus(form.getStopOverPlus());
        view.setTax(form.getTax());
        for (int i = 0; i < form.getNumSectors(); ++i) {
            view.setStopOver(i, form.getStopOver(i));
            view.setDepCode(i, form.getDepCode(i));
            view.setDestCode(i, form.getDestCode(i));
            view.setFareBasis(i, form.getFareBasis(i));
            view.setCarrier(i, form.getCarrier(i));
            view.setClassOfService(i, form.getClassOfService(i));
            view.setFareComponent(i, form.getFareComponent(i));
            view.setFlightNo(i, form.getFlightNo(i));
            view.setFlightDate(i, form.getFlightDate(i));
            view.setClassDiffPlus(i, form.getClassDiffPlus(i));
            view.setSecureCharge(i, form.getSecureCharge(i));
            view.setSideTripPlus(i, form.getSideTripPlus(i));
            view.setStopOverPlus(i, form.getStopOverPlus(i));
        }
    }

    abstract IAuditService createAuditService();

    public String getErrorString() {
        return this.errorString;
    }

    public void setErrorString(String errorString) {
        this.errorString = errorString;
    }
}

