/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.glj.graph;

import java.util.LinkedList;
import jp.sourceforge.glj.graph.GraphNode;

public abstract class GraphSearch {
    LinkedList open = new LinkedList();
    LinkedList closed = new LinkedList();
    LinkedList solutions = new LinkedList();

    public LinkedList search1() {
        return this.graphSearch(1);
    }

    public LinkedList searchAll() {
        return this.graphSearch(-1);
    }

    public LinkedList searchN(int numSolutions) {
        return this.graphSearch(numSolutions);
    }

    public LinkedList graphSearch(int numSolutions) {
        GraphNode node = null;
        LinkedList expand = null;
        while (!this.open.isEmpty() && !this.isGoal(numSolutions)) {
            LinkedList expandList;
            node = (GraphNode)this.open.getFirst();
            this.open.removeFirst();
            expand = node.graphExpand();
            if (expand.size() == 2 && expand.getLast() != null) {
                this.closed.addFirst(expand.getLast());
            }
            if ((expandList = (LinkedList)expand.getFirst()) == null) continue;
            for (int i = 0; i < expandList.size(); ++i) {
                this.addSuccessors((GraphNode)expandList.get(i));
            }
        }
        return this.getSolutions();
    }

    boolean isGoal(int numSolutions) {
        GraphNode node = (GraphNode)this.open.getFirst();
        if (node.isGoal()) {
            this.getSolutions().add(node);
        }
        if (numSolutions < 0) {
            return false;
        }
        return this.getSolutions().size() >= numSolutions;
    }

    void addSuccessors(GraphNode node) {
        GraphNode old = node.isOnGraph(this.open);
        if (old != null) {
            if (node.isBetterNode(old)) {
                this.open.remove(old);
                this.open = this.insertNode(node, this.open);
            }
        } else {
            old = node.isOnGraph(this.closed);
            if (old != null) {
                if (node.isBetterNode(old)) {
                    this.open = this.insertNode(node, this.open);
                    this.closed.remove(old);
                }
            } else {
                this.open = this.insertNode(node, this.open);
            }
        }
    }

    abstract LinkedList insertNode(GraphNode var1, LinkedList var2);

    public LinkedList getOpen() {
        return this.open;
    }

    public void setOpen(LinkedList open) {
        this.open = open;
    }

    public LinkedList getClosed() {
        return this.closed;
    }

    public void setClosed(LinkedList closed) {
        this.closed = closed;
    }

    public LinkedList getSolutions() {
        return this.solutions;
    }

    public void setSolutions(LinkedList solutions) {
        this.solutions = solutions;
    }
}

