/*
 * Decompiled with CFR 0.152.
 */
package gnu.xquery.util;

import gnu.bytecode.ClassType;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.CanInline;
import gnu.expr.Compilation;
import gnu.expr.ConsumerTarget;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IfExp;
import gnu.expr.IgnoreTarget;
import gnu.expr.Inlineable;
import gnu.expr.LambdaExp;
import gnu.expr.LetExp;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.Target;
import gnu.kawa.functions.AddOp;
import gnu.kawa.functions.NumberCompare;
import gnu.kawa.functions.ValuesMap;
import gnu.kawa.xml.CoerceNodes;
import gnu.kawa.xml.SortNodes;
import gnu.kawa.xml.SortedNodes;
import gnu.kawa.xml.XDataType;
import gnu.lists.Consumer;
import gnu.mapping.CallContext;
import gnu.mapping.MethodProc;
import gnu.mapping.Procedure;
import gnu.mapping.Values;
import gnu.math.DFloNum;
import gnu.math.IntNum;
import gnu.xquery.util.BooleanValue;

public class ValuesFilter
extends MethodProc
implements CanInline,
Inlineable {
    char kind;
    int last_or_position_needed = 2;
    public static final ValuesFilter forwardFilter = new ValuesFilter('F');
    public static final ValuesFilter reverseFilter = new ValuesFilter('R');
    public static final ValuesFilter exprFilter = new ValuesFilter('P');
    public static final ClassType typeValuesFilter = ClassType.make("gnu.xquery.util.ValuesFilter");
    public static final Method matchesMethod = typeValuesFilter.getDeclaredMethod("matches", 2);

    public ValuesFilter(char kind) {
        this.kind = kind;
    }

    public static ValuesFilter get(char kind) {
        if (kind == 'F') {
            return forwardFilter;
        }
        if (kind == 'R') {
            return reverseFilter;
        }
        return exprFilter;
    }

    @Override
    public int numArgs() {
        return 8194;
    }

    public static boolean matches(Object result, long count) {
        if (result instanceof Values) {
            result = ((Values)result).canonicalize();
        }
        if (result instanceof Number) {
            if (result instanceof IntNum) {
                return IntNum.compare((IntNum)result, count) == 0;
            }
            if (result instanceof Double || result instanceof Float || result instanceof DFloNum) {
                return ((Number)result).doubleValue() == (double)count;
            }
            if (result instanceof Long || result instanceof Integer || result instanceof Short || result instanceof Byte) {
                return count == ((Number)result).longValue();
            }
            return NumberCompare.applyWithPromotion(8, IntNum.make(count), result);
        }
        return BooleanValue.booleanValue(result);
    }

    @Override
    public void apply(CallContext ctx) throws Throwable {
        Values values;
        Object arg = ctx.getNextArg();
        Procedure proc = (Procedure)ctx.getNextArg();
        Consumer out = ctx.consumer;
        if (this.kind != 'P') {
            SortedNodes nodes = new SortedNodes();
            Values.writeValues(arg, nodes);
            values = nodes;
        } else if (arg instanceof Values) {
            values = (Values)arg;
        } else {
            IntNum one = IntNum.one();
            if (ValuesFilter.matches(proc.apply3(arg, one, one), 1L)) {
                out.writeObject(arg);
            }
            return;
        }
        int count = values.size();
        int it = 0;
        IntNum countObj = IntNum.make(count);
        int pmax = proc.maxArgs();
        for (int i = 0; i < count; ++i) {
            Object pred_res;
            it = values.nextPos(it);
            Object dot = values.getPosPrevious(it);
            int pos = this.kind == 'R' ? count - i : i + 1;
            IntNum posObj = IntNum.make(pos);
            Object object2 = pred_res = pmax == 2 ? proc.apply2(dot, posObj) : proc.apply3(dot, posObj, countObj);
            if (!ValuesFilter.matches(pred_res, pos)) continue;
            out.writeObject(dot);
        }
    }

    @Override
    public Expression inline(ApplyExp exp, ExpWalker walker) {
        Type predType;
        Method sizeMethod;
        Type seqType;
        LambdaExp lexp2;
        Expression[] args;
        block9: {
            block8: {
                args = exp.getArgs();
                Expression exp2 = args[1];
                if (!(exp2 instanceof LambdaExp)) break block8;
                lexp2 = (LambdaExp)exp2;
                if (lexp2.min_args == 3 && lexp2.max_args == 3) break block9;
            }
            return exp;
        }
        exp.setType(args[0].getType());
        Compilation parser = walker.getCompilation();
        Declaration dotArg = lexp2.firstDecl();
        Declaration posArg = dotArg.nextDecl();
        Declaration lastArg = posArg.nextDecl();
        lexp2.setInlineOnly(true);
        lexp2.returnContinuation = exp;
        lexp2.remove(posArg, lastArg);
        lexp2.min_args = 2;
        lexp2.max_args = 2;
        if (!lastArg.getCanRead() && this.kind != 'R') {
            return exp;
        }
        parser.letStart();
        Expression seq = args[0];
        if (this.kind == 'P') {
            seqType = seq.getType();
            sizeMethod = Compilation.typeValues.getDeclaredMethod("countValues", 1);
        } else {
            seqType = SortNodes.typeSortedNodes;
            seq = new ApplyExp(SortNodes.sortNodes, new Expression[]{seq});
            sizeMethod = CoerceNodes.typeNodes.getDeclaredMethod("size", 0);
        }
        Declaration sequence = parser.letVariable("sequence", seqType, seq);
        parser.letEnter();
        Expression pred = lexp2.body;
        if (this.kind == 'R') {
            Declaration posIncoming = new Declaration(null, Type.int_type);
            ApplyExp init = new ApplyExp(AddOp.$Mn, new Expression[]{new ReferenceExp(lastArg), new ReferenceExp(posIncoming)});
            init = new ApplyExp(AddOp.$Pl, new Expression[]{init, new QuoteExp(IntNum.one())});
            LetExp let2 = new LetExp(new Expression[]{init});
            lexp2.replaceFollowing(dotArg, posIncoming);
            let2.add(posArg);
            let2.body = pred;
            pred = let2;
        }
        if ((predType = lexp2.body.getType()) != XDataType.booleanType) {
            pred = new ApplyExp(matchesMethod, new Expression[]{pred, new ReferenceExp(posArg)});
        }
        lexp2.body = pred = new IfExp(pred, new ReferenceExp(dotArg), QuoteExp.voidExp);
        ApplyExp doMap = new ApplyExp(ValuesMap.valuesMapWithPos, new Expression[]{lexp2, new ReferenceExp(sequence)});
        doMap.setType(dotArg.getType());
        lexp2.returnContinuation = doMap;
        ApplyExp lastInit = new ApplyExp(sizeMethod, new Expression[]{new ReferenceExp(sequence)});
        LetExp let2 = new LetExp(new Expression[]{lastInit});
        let2.add(lastArg);
        let2.body = ValuesMap.valuesMapWithPos.inline(doMap, walker);
        return parser.letDone(let2);
    }

    @Override
    public void compile(ApplyExp exp, Compilation comp, Target target) {
        Expression[] args = exp.getArgs();
        Expression exp1 = args[0];
        Expression exp2 = args[1];
        if (target instanceof IgnoreTarget) {
            exp1.compile(comp, target);
            exp2.compile(comp, target);
            return;
        }
        if (!(exp2 instanceof LambdaExp)) {
            ApplyExp.compile(exp, comp, target);
            return;
        }
        if (!(target instanceof ConsumerTarget)) {
            ConsumerTarget.compileUsingConsumer(exp, comp, target);
            return;
        }
        LambdaExp lexp2 = (LambdaExp)exp2;
        ValuesMap.compileInlined(lexp2, exp1, 1, matchesMethod, comp, target);
    }

    @Override
    public Type getReturnType(Expression[] args) {
        return Type.pointer_type;
    }
}

