/*
 * Decompiled with CFR 0.152.
 */
package gnu.xquery.util;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.Scope;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.ApplyExp;
import gnu.expr.CanInline;
import gnu.expr.Compilation;
import gnu.expr.ConsumerTarget;
import gnu.expr.Declaration;
import gnu.expr.ErrorExp;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.Inlineable;
import gnu.expr.LambdaExp;
import gnu.expr.Language;
import gnu.expr.LetExp;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.SeriesTarget;
import gnu.expr.Target;
import gnu.kawa.functions.ValuesMap;
import gnu.kawa.reflect.OccurrenceType;
import gnu.kawa.xml.AttributeAxis;
import gnu.kawa.xml.ChildAxis;
import gnu.kawa.xml.CoerceNodes;
import gnu.kawa.xml.DescendantAxis;
import gnu.kawa.xml.DescendantOrSelfAxis;
import gnu.kawa.xml.NodeSetType;
import gnu.kawa.xml.NodeType;
import gnu.kawa.xml.Nodes;
import gnu.kawa.xml.SelfAxis;
import gnu.kawa.xml.TreeScanner;
import gnu.lists.Consumer;
import gnu.mapping.CallContext;
import gnu.mapping.MethodProc;
import gnu.mapping.Procedure;
import gnu.mapping.Values;
import gnu.math.IntNum;
import gnu.xquery.util.RelativeStepFilter;
import gnu.xquery.util.ValuesFilter;

public class RelativeStep
extends MethodProc
implements CanInline,
Inlineable {
    public static final RelativeStep relativeStep = new RelativeStep();

    @Override
    public int numArgs() {
        return 8194;
    }

    @Override
    public void apply(CallContext ctx) throws Throwable {
        Nodes values;
        Object arg = ctx.getNextArg();
        Object next = ctx.getNextArg();
        Procedure proc = (Procedure)next;
        Consumer out = ctx.consumer;
        if (arg instanceof Nodes) {
            values = (Nodes)arg;
        } else {
            values = new Nodes();
            Values.writeValues(arg, values);
        }
        int count = values.size();
        int it = 0;
        IntNum countObj = IntNum.make(count);
        RelativeStepFilter filter = new RelativeStepFilter(out);
        for (int pos = 1; pos <= count; ++pos) {
            it = values.nextPos(it);
            Object dot = values.getPosPrevious(it);
            proc.check3(dot, IntNum.make(pos), countObj, ctx);
            Values.writeValues(ctx.runUntilValue(), filter);
        }
        filter.finish();
    }

    @Override
    public Expression inline(ApplyExp exp, ExpWalker walker) {
        Declaration pos2;
        LambdaExp lvexp2;
        Declaration dot2;
        Expression vexp2;
        ApplyExp aexp2;
        Object proc2;
        LambdaExp lexp2;
        Compilation comp;
        Expression exp2;
        Expression exp1;
        block11: {
            block10: {
                Expression[] args = exp.getArgs();
                exp1 = args[0];
                exp2 = args[1];
                comp = walker.getCompilation();
                if (!(exp2 instanceof LambdaExp) || !comp.mustCompile) break block10;
                lexp2 = (LambdaExp)exp2;
                if (lexp2.min_args == 3 && lexp2.max_args == 3) break block11;
            }
            return exp;
        }
        lexp2.setInlineOnly(true);
        lexp2.returnContinuation = exp;
        exp2 = lexp2.body;
        Declaration dotArg = lexp2.firstDecl();
        Declaration posArg = dotArg.nextDecl();
        Declaration lastArg = posArg.nextDecl();
        posArg.setNext(lastArg.nextDecl());
        lastArg.setNext(null);
        lexp2.min_args = 2;
        lexp2.max_args = 2;
        Type type1 = exp1.getType();
        if (type1 != null && NodeType.anyNodeTest.compare(type1) == -3) {
            Language language = walker.getCompilation().getLanguage();
            String message = "step input is " + language.formatType(type1) + " - not a node sequence";
            walker.getMessages().error('e', message);
            return new ErrorExp(message);
        }
        Type rtype = exp.getTypeRaw();
        if (rtype == null || rtype == Type.pointer_type) {
            Type type2 = exp2.getType();
            Type rtypePrime = OccurrenceType.itemPrimeType(type2);
            int nodeCompare = NodeType.anyNodeTest.compare(rtypePrime);
            rtype = nodeCompare >= 0 ? NodeSetType.getInstance(rtypePrime) : OccurrenceType.getInstance(rtypePrime, 0, -1);
            exp.setType(rtype);
        }
        if (lastArg.getCanRead()) {
            ClassType typeNodes = CoerceNodes.typeNodes;
            comp.letStart();
            Declaration sequence = comp.letVariable(null, typeNodes, new ApplyExp(CoerceNodes.coerceNodes, new Expression[]{exp1}));
            comp.letEnter();
            Method sizeMethod = typeNodes.getDeclaredMethod("size", 0);
            ApplyExp lastInit = new ApplyExp(sizeMethod, new Expression[]{new ReferenceExp(sequence)});
            LetExp lastLet = new LetExp(new Expression[]{lastInit});
            lastLet.addDeclaration(lastArg);
            lastLet.body = new ApplyExp(exp.getFunction(), new Expression[]{new ReferenceExp(sequence), lexp2});
            return comp.letDone(lastLet);
        }
        ApplyExp result = exp;
        if (exp2 instanceof ApplyExp && (proc2 = (aexp2 = (ApplyExp)exp2).getFunction().valueIfConstant()) instanceof ValuesFilter && (vexp2 = aexp2.getArgs()[1]) instanceof LambdaExp && (dot2 = (lvexp2 = (LambdaExp)vexp2).firstDecl()) != null && (pos2 = dot2.nextDecl()) != null && pos2.nextDecl() == null && !pos2.getCanRead() && ClassType.make("java.lang.Number").compare(lvexp2.body.getType()) == -3) {
            lexp2.body = exp2 = aexp2.getArg(0);
            aexp2.setArg(0, exp);
            result = aexp2;
        }
        if (exp1 instanceof ApplyExp && exp2 instanceof ApplyExp) {
            Expression exp12;
            ApplyExp aexp1 = (ApplyExp)exp1;
            ApplyExp aexp22 = (ApplyExp)exp2;
            Object p1 = aexp1.getFunction().valueIfConstant();
            Object p2 = aexp22.getFunction().valueIfConstant();
            if (p1 == relativeStep && p2 instanceof ChildAxis && aexp1.getArgCount() == 2 && (exp12 = aexp1.getArg(1)) instanceof LambdaExp) {
                ApplyExp aexp12;
                LambdaExp lexp12 = (LambdaExp)exp12;
                if (lexp12.body instanceof ApplyExp && (aexp12 = (ApplyExp)lexp12.body).getFunction().valueIfConstant() == DescendantOrSelfAxis.anyNode) {
                    exp.setArg(0, aexp1.getArg(0));
                    aexp22.setFunction(new QuoteExp(DescendantAxis.make(((ChildAxis)p2).getNodePredicate())));
                }
            }
        }
        return result;
    }

    @Override
    public void compile(ApplyExp exp, Compilation comp, Target target) {
        Variable tconsumer;
        Variable mconsumer;
        ClassType mclass;
        Target mtarget;
        Type rtypePrime;
        int nodeCompare;
        Expression[] args = exp.getArgs();
        Expression exp1 = args[0];
        Expression exp2 = args[1];
        if (target instanceof IgnoreTarget) {
            exp1.compile(comp, target);
            exp2.compile(comp, target);
            return;
        }
        Type rtype = exp.getTypeRaw();
        if (rtype == null) {
            rtype = Type.pointer_type;
        }
        int expectedKind = (nodeCompare = NodeType.anyNodeTest.compare(rtypePrime = OccurrenceType.itemPrimeType(rtype))) >= 0 ? 78 : (nodeCompare == -3 ? 65 : 32);
        TreeScanner step = RelativeStep.extractStep(exp2);
        if (step != null) {
            Type type1 = exp1.getType();
            if ((step instanceof ChildAxis || step instanceof AttributeAxis || step instanceof SelfAxis) && (type1 instanceof NodeSetType || expectedKind == 78 && OccurrenceType.itemCountIsZeroOrOne(exp1.getType()))) {
                expectedKind = 83;
            }
        }
        if (!(target instanceof ConsumerTarget) && (!(target instanceof SeriesTarget) || expectedKind != 65 && expectedKind != 83)) {
            ConsumerTarget.compileUsingConsumer(exp, comp, target);
            return;
        }
        CodeAttr code = comp.getCode();
        Scope scope = code.pushScope();
        if (expectedKind == 65 || expectedKind == 83) {
            mtarget = target;
            mclass = null;
            mconsumer = null;
            tconsumer = null;
        } else {
            Method initMethod;
            if (expectedKind == 78) {
                mclass = ClassType.make("gnu.kawa.xml.SortedNodes");
                initMethod = mclass.getDeclaredMethod("<init>", 0);
            } else {
                mclass = ClassType.make("gnu.xquery.util.RelativeStepFilter");
                initMethod = mclass.getDeclaredMethod("<init>", 1);
            }
            mconsumer = scope.addVariable(code, mclass, null);
            mtarget = new ConsumerTarget(mconsumer);
            code.emitNew(mclass);
            code.emitDup(mclass);
            tconsumer = ((ConsumerTarget)target).getConsumerVariable();
            if (expectedKind != 78) {
                code.emitLoad(tconsumer);
            }
            code.emitInvoke(initMethod);
            code.emitStore(mconsumer);
        }
        ValuesMap.compileInlined((LambdaExp)exp2, exp1, 1, null, comp, mtarget);
        if (expectedKind == 78) {
            code.emitLoad(mconsumer);
            code.emitLoad(tconsumer);
            code.emitInvokeStatic(Compilation.typeValues.getDeclaredMethod("writeValues", 2));
        } else if (expectedKind == 32) {
            code.emitLoad(mconsumer);
            code.emitInvoke(mclass.getDeclaredMethod("finish", 0));
        }
        code.popScope();
    }

    @Override
    public Type getReturnType(Expression[] args) {
        return Type.pointer_type;
    }

    public static TreeScanner extractStep(Expression exp) {
        while (true) {
            if (!(exp instanceof ApplyExp)) {
                return null;
            }
            ApplyExp aexp = (ApplyExp)exp;
            Expression func = aexp.getFunction();
            if (!(func instanceof QuoteExp)) break;
            Object value = ((QuoteExp)func).getValue();
            if (value instanceof TreeScanner) {
                return (TreeScanner)value;
            }
            if (!(value instanceof ValuesFilter)) break;
            exp = aexp.getArgs()[0];
        }
        return null;
    }
}

