/*
 * Decompiled with CFR 0.152.
 */
package gnu.xquery.util;

import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.CanInline;
import gnu.expr.ErrorExp;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.QuoteExp;
import gnu.kawa.xml.UntypedAtomic;
import gnu.kawa.xml.XDataType;
import gnu.lists.SeqPosition;
import gnu.lists.Sequence;
import gnu.mapping.Procedure1;
import gnu.mapping.Values;
import gnu.mapping.WrongType;
import gnu.math.Numeric;
import gnu.math.RealNum;
import gnu.text.Path;
import gnu.xquery.lang.XQuery;

public class BooleanValue
extends Procedure1
implements CanInline {
    public static final BooleanValue booleanValue = new BooleanValue("boolean-value");

    public BooleanValue(String name) {
        super(name);
    }

    public static boolean booleanValue(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number && (value instanceof RealNum || !(value instanceof Numeric))) {
            double d = ((Number)value).doubleValue();
            return d != 0.0 && !Double.isNaN(d);
        }
        if (value instanceof SeqPosition) {
            return true;
        }
        if (value instanceof String || value instanceof Path || value instanceof UntypedAtomic) {
            return value.toString().length() > 0;
        }
        if (value instanceof Values) {
            Values values = (Values)value;
            Object value1 = values.getPosNext(0);
            if (value1 == Sequence.eofValue) {
                return false;
            }
            int next = values.nextDataIndex(0);
            if (next < 0) {
                return BooleanValue.booleanValue(value1);
            }
            if (value1 instanceof SeqPosition) {
                return true;
            }
        }
        throw new WrongType("fn:boolean", 1, value, "boolean-convertible-value");
    }

    public static boolean not(Object value) {
        return !BooleanValue.booleanValue(value);
    }

    @Override
    public Object apply1(Object arg) {
        return BooleanValue.booleanValue(arg) ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Expression inline(ApplyExp exp, ExpWalker walker) {
        Expression[] args = exp.getArgs();
        if (args.length == 1) {
            Expression arg = args[0];
            Type type = arg.getType();
            if (type == XDataType.booleanType) {
                return arg;
            }
            if (type == null) {
                exp.setType(XDataType.booleanType);
            }
            if (arg instanceof QuoteExp) {
                Object value = ((QuoteExp)arg).getValue();
                try {
                    return BooleanValue.booleanValue(value) ? XQuery.trueExp : XQuery.falseExp;
                }
                catch (Throwable ex) {
                    String message = "cannot convert to a boolean";
                    walker.getMessages().error('e', message);
                    return new ErrorExp(message);
                }
            }
        }
        return exp;
    }
}

