/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.AbstractSequence;
import gnu.lists.Sequence;
import java.util.Enumeration;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class SeqPosition
implements ListIterator,
Enumeration {
    public AbstractSequence sequence;
    public int ipos;

    public SeqPosition() {
    }

    public SeqPosition(AbstractSequence seq) {
        this.sequence = seq;
    }

    public SeqPosition(AbstractSequence seq, int offset, boolean isAfter) {
        this.sequence = seq;
        this.ipos = seq.createPos(offset, isAfter);
    }

    public SeqPosition(AbstractSequence seq, int ipos) {
        this.sequence = seq;
        this.ipos = ipos;
    }

    public static SeqPosition make(AbstractSequence seq, int ipos) {
        return new SeqPosition(seq, seq.copyPos(ipos));
    }

    public SeqPosition copy() {
        return new SeqPosition(this.sequence, this.sequence.copyPos(this.getPos()));
    }

    public final void gotoStart(AbstractSequence seq) {
        this.setPos(seq, seq.startPos());
    }

    public final void gotoEnd(AbstractSequence seq) {
        this.setPos(seq, seq.endPos());
    }

    public boolean gotoChildrenStart() {
        int child = this.sequence.firstChildPos(this.getPos());
        if (child == 0) {
            return false;
        }
        this.ipos = child;
        return true;
    }

    @Override
    public final boolean hasMoreElements() {
        return this.hasNext();
    }

    @Override
    public boolean hasNext() {
        return this.sequence.hasNext(this.getPos());
    }

    public int getNextKind() {
        return this.sequence.getNextKind(this.getPos());
    }

    public String getNextTypeName() {
        return this.sequence.getNextTypeName(this.getPos());
    }

    public Object getNextTypeObject() {
        return this.sequence.getNextTypeObject(this.getPos());
    }

    @Override
    public boolean hasPrevious() {
        return this.sequence.hasPrevious(this.getPos());
    }

    @Override
    public Object next() {
        Object result = this.getNext();
        if (result == Sequence.eofValue || !this.gotoNext()) {
            throw new NoSuchElementException();
        }
        return result;
    }

    public boolean gotoNext() {
        int next = this.sequence.nextPos(this.ipos);
        if (next != 0) {
            this.ipos = next;
            return true;
        }
        this.ipos = -1;
        return false;
    }

    public boolean gotoPrevious() {
        int prev = this.sequence.previousPos(this.ipos);
        if (prev != -1) {
            this.ipos = prev;
            return true;
        }
        this.ipos = 0;
        return false;
    }

    public Object previous() {
        Object result = this.getPrevious();
        if (result == Sequence.eofValue || !this.gotoPrevious()) {
            throw new NoSuchElementException();
        }
        return result;
    }

    public final Object nextElement() {
        return this.next();
    }

    public Object getNext() {
        return this.sequence.getPosNext(this.getPos());
    }

    public Object getPrevious() {
        return this.sequence.getPosPrevious(this.getPos());
    }

    @Override
    public int nextIndex() {
        return this.sequence.nextIndex(this.getPos());
    }

    public final int fromEndIndex() {
        return this.sequence.fromEndIndex(this.getPos());
    }

    public int getContainingSequenceSize() {
        return this.sequence.getContainingSequenceSize(this.getPos());
    }

    @Override
    public final int previousIndex() {
        return this.sequence.nextIndex(this.getPos()) - 1;
    }

    public boolean isAfter() {
        return this.sequence.isAfterPos(this.getPos());
    }

    public final void set(Object value) {
        if (this.isAfter()) {
            this.setPrevious(value);
        } else {
            this.setNext(value);
        }
    }

    public void setNext(Object value) {
        this.sequence.setPosNext(this.getPos(), value);
    }

    public void setPrevious(Object value) {
        this.sequence.setPosPrevious(this.getPos(), value);
    }

    @Override
    public void remove() {
        this.sequence.removePos(this.getPos(), this.isAfter() ? -1 : 1);
    }

    public void add(Object o) {
        this.setPos(this.sequence.addPos(this.getPos(), o));
    }

    public int getPos() {
        return this.ipos;
    }

    public void setPos(AbstractSequence seq, int ipos) {
        if (this.sequence != null) {
            this.sequence.releasePos(this.getPos());
        }
        this.ipos = ipos;
        this.sequence = seq;
    }

    public void setPos(int ipos) {
        if (this.sequence != null) {
            this.sequence.releasePos(this.getPos());
        }
        this.ipos = ipos;
    }

    public void set(AbstractSequence seq, int index, boolean isAfter) {
        if (this.sequence != null) {
            this.sequence.releasePos(this.ipos);
        }
        this.sequence = seq;
        this.ipos = seq.createPos(index, isAfter);
    }

    public void set(SeqPosition pos) {
        if (this.sequence != null) {
            this.sequence.releasePos(this.ipos);
        }
        this.sequence = pos.sequence;
        pos.ipos = this.sequence.copyPos(pos.ipos);
    }

    public void release() {
        if (this.sequence != null) {
            this.sequence.releasePos(this.getPos());
            this.sequence = null;
        }
    }

    public void finalize() {
        this.release();
    }

    public String toString() {
        if (this.sequence == null) {
            return this.toInfo();
        }
        Object item = this.sequence.getPosNext(this.ipos);
        if (item == null) {
            return this.toInfo();
        }
        return item.toString();
    }

    public String toInfo() {
        StringBuffer sbuf = new StringBuffer(60);
        sbuf.append('{');
        if (this.sequence == null) {
            sbuf.append("null sequence");
        } else {
            sbuf.append(this.sequence.getClass().getName());
            sbuf.append('@');
            sbuf.append(System.identityHashCode(this.sequence));
        }
        sbuf.append(" ipos: ");
        sbuf.append(this.ipos);
        sbuf.append('}');
        return sbuf.toString();
    }
}

