/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.reflect;

import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.Member;
import gnu.bytecode.ObjectType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.CanInline;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.InlineCalls;
import gnu.expr.Keyword;
import gnu.expr.Language;
import gnu.expr.LetExp;
import gnu.expr.PairClassType;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.TypeValue;
import gnu.kawa.lispexpr.ClassNamespace;
import gnu.kawa.reflect.ArrayNew;
import gnu.kawa.reflect.ArraySet;
import gnu.kawa.reflect.ClassMethods;
import gnu.kawa.reflect.SlotSet;
import gnu.lists.FString;
import gnu.mapping.CallContext;
import gnu.mapping.MethodProc;
import gnu.mapping.Procedure;
import gnu.mapping.ProcedureN;
import gnu.mapping.Symbol;
import gnu.mapping.WrongType;
import java.lang.reflect.Array;

public class Invoke
extends ProcedureN
implements CanInline {
    char kind;
    Language language;
    public static final Invoke invoke = new Invoke("invoke", '*');
    public static final Invoke invokeStatic = new Invoke("invoke-static", 'S');
    public static final Invoke invokeSpecial = new Invoke("invoke-special", 'P');
    public static final Invoke make = new Invoke("make", 'N');

    public Invoke(String name, char kind) {
        super(name);
        this.kind = kind;
        this.language = Language.getDefaultLanguage();
    }

    public Invoke(String name, char kind, Language language) {
        super(name);
        this.kind = kind;
        this.language = language;
    }

    public static Object invoke$V(Object[] args) throws Throwable {
        return invoke.applyN(args);
    }

    public static Object invokeStatic$V(Object[] args) throws Throwable {
        return invokeStatic.applyN(args);
    }

    public static Object make$V(Object[] args) throws Throwable {
        return make.applyN(args);
    }

    private static ObjectType typeFrom(Object arg, Invoke thisProc) {
        if (arg instanceof Class) {
            arg = Type.make((Class)arg);
        }
        if (arg instanceof ObjectType) {
            return (ObjectType)arg;
        }
        if (arg instanceof String || arg instanceof FString) {
            return ClassType.make(arg.toString());
        }
        if (arg instanceof Symbol) {
            return ClassType.make(((Symbol)arg).getName());
        }
        if (arg instanceof ClassNamespace) {
            return ((ClassNamespace)arg).getClassType();
        }
        throw new WrongType((Procedure)thisProc, 0, arg, "class-specifier");
    }

    @Override
    public void apply(CallContext ctx) throws Throwable {
        Object[] args = ctx.getArgs();
        if (this.kind == 'S' || this.kind == 'V' || this.kind == 's' || this.kind == '*') {
            int nargs = args.length;
            Procedure.checkArgCount(this, nargs);
            Object arg0 = args[0];
            ObjectType dtype = this.kind == 'S' || this.kind == 's' ? Invoke.typeFrom(arg0, this) : Type.make(arg0.getClass());
            MethodProc proc = this.lookupMethods(dtype, args[1]);
            Object[] margs = new Object[nargs - (this.kind == 'S' ? 2 : 1)];
            int i = 0;
            if (this.kind == 'V' || this.kind == '*') {
                margs[i++] = args[0];
            }
            System.arraycopy(args, 2, margs, i, nargs - 2);
            proc.checkN(margs, ctx);
        } else {
            ctx.writeValue(this.applyN(args));
        }
    }

    @Override
    public Object applyN(Object[] args) throws Throwable {
        MethodProc vproc;
        Object mname;
        ObjectType dtype;
        if (this.kind == 'P') {
            throw new RuntimeException(this.getName() + ": invoke-special not allowed at run time");
        }
        int nargs = args.length;
        Procedure.checkArgCount(this, nargs);
        Object arg0 = args[0];
        ObjectType objectType = dtype = this.kind != 'V' && this.kind != '*' ? Invoke.typeFrom(arg0, this) : (ObjectType)Type.make(arg0.getClass());
        if (this.kind == 'N') {
            Procedure constructor;
            mname = null;
            if (dtype instanceof TypeValue && (constructor = ((TypeValue)((Object)dtype)).getConstructor()) != null) {
                Object[] xargs = new Object[--nargs];
                System.arraycopy(args, 1, xargs, 0, nargs);
                return constructor.applyN(xargs);
            }
            if (dtype instanceof PairClassType) {
                PairClassType ptype = (PairClassType)dtype;
                dtype = ptype.instanceType;
            }
            if (dtype instanceof ArrayType) {
                boolean lengthSpecified;
                int i;
                int length;
                String name;
                Type elementType = ((ArrayType)dtype).getComponentType();
                int len = args.length - 1;
                if (len >= 2 && args[1] instanceof Keyword && ("length".equals(name = ((Keyword)args[1]).getName()) || "size".equals(name))) {
                    length = ((Number)args[2]).intValue();
                    i = 3;
                    lengthSpecified = true;
                } else {
                    length = len;
                    i = 1;
                    lengthSpecified = false;
                }
                Object arr = Array.newInstance(elementType.getReflectClass(), length);
                int index = 0;
                while (i <= len) {
                    Object arg = args[i];
                    if (lengthSpecified && arg instanceof Keyword && i < len) {
                        String kname = ((Keyword)arg).getName();
                        try {
                            index = Integer.parseInt(kname);
                        }
                        catch (Throwable ex) {
                            throw new RuntimeException("non-integer keyword '" + kname + "' in array constructor");
                        }
                        arg = args[++i];
                    }
                    Array.set(arr, index, elementType.coerceFromObject(arg));
                    ++index;
                    ++i;
                }
                return arr;
            }
        } else {
            mname = args[1];
        }
        MethodProc proc = this.lookupMethods(dtype, mname);
        if (this.kind != 'N') {
            Object[] margs = new Object[nargs - (this.kind == 'S' || this.kind == 's' ? 2 : 1)];
            int i = 0;
            if (this.kind == 'V' || this.kind == '*') {
                margs[i++] = args[0];
            }
            System.arraycopy(args, 2, margs, i, nargs - 2);
            return proc.applyN(margs);
        }
        CallContext vars = CallContext.getInstance();
        int err = proc.matchN(args, vars);
        if (err == 0) {
            return vars.runUntilValue();
        }
        if ((nargs & 1) == 1) {
            int i = 1;
            while (true) {
                if (i == nargs) {
                    Object result = proc.apply1(args[0]);
                    for (i = 1; i < nargs; i += 2) {
                        Keyword key = (Keyword)args[i];
                        Object arg = args[i + 1];
                        SlotSet.apply(false, result, key.getName(), arg);
                    }
                    return result;
                }
                if (!(args[i] instanceof Keyword)) break;
                i += 2;
            }
        }
        if ((vproc = ClassMethods.apply((ClassType)dtype, "valueOf", '\u0000', this.language)) != null) {
            Object[] margs = new Object[nargs - 1];
            System.arraycopy(args, 1, margs, 0, nargs - 1);
            err = vproc.matchN(margs, vars);
            if (err == 0) {
                return vars.runUntilValue();
            }
        }
        throw MethodProc.matchFailAsException(err, proc, args);
    }

    @Override
    public int numArgs() {
        return 0xFFFFF000 | (this.kind == 'N' ? 1 : 2);
    }

    protected MethodProc lookupMethods(ObjectType dtype, Object name) {
        String mname;
        if (this.kind == 'N') {
            mname = "<init>";
        } else {
            if (name instanceof String || name instanceof FString) {
                mname = name.toString();
            } else if (name instanceof Symbol) {
                mname = ((Symbol)name).getName();
            } else {
                throw new WrongType((Procedure)this, 1, null);
            }
            mname = Compilation.mangleName(mname);
        }
        MethodProc proc = ClassMethods.apply(dtype, mname, (char)(this.kind == 'P' ? 80 : (this.kind == '*' || this.kind == 'V' ? 86 : 0)), this.language);
        if (proc == null) {
            throw new RuntimeException(this.getName() + ": no method named `" + mname + "' in class " + dtype.getName());
        }
        return proc;
    }

    protected PrimProcedure[] getMethods(ObjectType ctype, String mname, ClassType caller) {
        return ClassMethods.getMethods(ctype, mname, this.kind == 'P' ? (char)'P' : (this.kind == '*' || this.kind == 'V' ? (char)'V' : '\u0000'), caller, this.language);
    }

    private static long selectApplicable(PrimProcedure[] methods, ObjectType ctype, Expression[] args, int margsLength, int argsStartIndex, int objIndex) {
        Type[] atypes = new Type[margsLength];
        int dst = 0;
        if (objIndex >= 0) {
            atypes[dst++] = ctype;
        }
        for (int src = argsStartIndex; src < args.length && dst < atypes.length; ++src, ++dst) {
            atypes[dst] = args[src].getType();
        }
        return ClassMethods.selectApplicable(methods, atypes);
    }

    static Object[] checkKeywords(Type type, Expression[] args, int start, ClassType caller) {
        int len = args.length;
        if ((len - start & 1) != 0) {
            return null;
        }
        Object[] fields = new Object[len - start >> 1];
        int i = fields.length;
        while (--i >= 0) {
            Expression arg = args[start + 2 * i];
            if (!(arg instanceof QuoteExp)) {
                return null;
            }
            Object value = ((QuoteExp)arg).getValue();
            if (!(value instanceof Keyword)) {
                return null;
            }
            String name = ((Keyword)value).getName();
            Member slot = SlotSet.lookupMember((ClassType)type, name, caller);
            fields[i] = slot != null ? slot : name;
        }
        return fields;
    }

    public static int checkKnownClass(Type type, Compilation comp) {
        if (type instanceof ClassType && ((ClassType)type).isExisting()) {
            try {
                type.getReflectClass();
                return 1;
            }
            catch (Exception ex) {
                comp.error('e', "unknown class: " + type.getName());
                return -1;
            }
        }
        return 0;
    }

    public static ApplyExp inlineClassName(ApplyExp exp, int carg, InlineCalls walker) {
        Compilation comp = walker.getCompilation();
        Language language = comp.getLanguage();
        Expression[] args = exp.getArgs();
        if (args.length > carg) {
            Type type = language.getTypeFor(args[carg]);
            if (!(type instanceof Type)) {
                return exp;
            }
            Invoke.checkKnownClass(type, comp);
            Expression[] nargs = new Expression[args.length];
            System.arraycopy(args, 0, nargs, 0, args.length);
            nargs[carg] = new QuoteExp(type);
            ApplyExp nexp = new ApplyExp(exp.getFunction(), nargs);
            nexp.setLine(exp);
            return nexp;
        }
        return exp;
    }

    @Override
    public Expression inline(ApplyExp exp, ExpWalker walker) {
        int objIndex;
        int argsStartIndex;
        int margsLength;
        Type type0;
        Compilation comp = walker.getCompilation();
        Expression[] args = exp.getArgs();
        int nargs = args.length;
        if (!comp.mustCompile || nargs == 0 || (this.kind == 'V' || this.kind == '*') && nargs == 1) {
            return exp;
        }
        Expression arg0 = args[0];
        Type type = type0 = this.kind == 'V' || this.kind == '*' ? arg0.getType() : this.language.getTypeFor(arg0);
        ObjectType type2 = type0 instanceof PairClassType ? ((PairClassType)type0).instanceType : (type0 instanceof ObjectType ? (ObjectType)type0 : null);
        String name = this.getMethodName(args);
        if (this.kind == 'V' || this.kind == '*') {
            margsLength = nargs - 1;
            argsStartIndex = 2;
            objIndex = 0;
        } else if (this.kind == 'N') {
            margsLength = nargs;
            argsStartIndex = 0;
            objIndex = -1;
        } else if (this.kind == 'S' || this.kind == 's') {
            margsLength = nargs - 2;
            argsStartIndex = 2;
            objIndex = -1;
        } else if (this.kind == 'P') {
            margsLength = nargs - 2;
            argsStartIndex = 3;
            objIndex = 1;
        } else {
            return exp;
        }
        if (this.kind == 'N' && type2 instanceof ArrayType) {
            int i;
            Object arg1;
            ArrayType atype = (ArrayType)type2;
            Type elementType = atype.getComponentType();
            Expression sizeArg = null;
            boolean lengthSpecified = false;
            if (args.length >= 3 && args[1] instanceof QuoteExp && (arg1 = ((QuoteExp)args[1]).getValue()) instanceof Keyword && ("length".equals(name = ((Keyword)arg1).getName()) || "size".equals(name))) {
                sizeArg = args[2];
                lengthSpecified = true;
            }
            if (sizeArg == null) {
                sizeArg = QuoteExp.getInstance(new Integer(args.length - 1));
            }
            ApplyExp alloc = new ApplyExp(new ArrayNew(elementType), new Expression[]{sizeArg});
            if (lengthSpecified && args.length == 3) {
                return alloc;
            }
            LetExp let2 = new LetExp(new Expression[]{alloc});
            Declaration adecl = let2.addDeclaration(null, atype);
            adecl.noteValue(alloc);
            BeginExp begin2 = new BeginExp();
            int index = 0;
            int n = i = lengthSpecified ? 3 : 1;
            while (i < args.length) {
                Object key;
                Expression arg = args[i];
                if (lengthSpecified && i + 1 < args.length && arg instanceof QuoteExp && (key = ((QuoteExp)arg).getValue()) instanceof Keyword) {
                    String kname = ((Keyword)key).getName();
                    try {
                        index = Integer.parseInt(kname);
                        arg = args[++i];
                    }
                    catch (Throwable ex) {
                        comp.error('e', "non-integer keyword '" + kname + "' in array constructor");
                        return exp;
                    }
                }
                begin2.add(new ApplyExp(new ArraySet(elementType), new Expression[]{new ReferenceExp(adecl), QuoteExp.getInstance(new Integer(index)), arg}));
                ++index;
                ++i;
            }
            begin2.add(new ReferenceExp(adecl));
            let2.body = begin2;
            return let2;
        }
        if (type2 != null && name != null) {
            Object[] slots;
            int maybeCount;
            int okCount;
            MethodProc[] methods;
            Procedure constructor;
            if (type2 instanceof TypeValue && this.kind == 'N' && (constructor = ((TypeValue)((Object)type2)).getConstructor()) != null) {
                Expression[] xargs = new Expression[nargs - 1];
                System.arraycopy(args, 1, xargs, 0, nargs - 1);
                return ((InlineCalls)walker).walkApplyOnly(new ApplyExp(constructor, xargs));
            }
            ClassType caller = comp == null ? null : (comp.curClass != null ? comp.curClass : comp.mainClass);
            ObjectType ctype = type2;
            try {
                methods = this.getMethods(ctype, name, caller);
                long num = Invoke.selectApplicable((PrimProcedure[])methods, ctype, args, margsLength, argsStartIndex, objIndex);
                okCount = (int)(num >> 32);
                maybeCount = (int)num;
            }
            catch (Exception ex) {
                comp.error('w', "unknown class: " + type2.getName());
                return exp;
            }
            int index = -1;
            if (okCount + maybeCount == 0 && this.kind == 'N' && ClassMethods.selectApplicable((PrimProcedure[])methods, new Type[]{Compilation.typeClassType}) >> 32 == 1L && (slots = Invoke.checkKeywords(type2, args, 1, caller)) != null) {
                StringBuffer errbuf = null;
                for (int i = 0; i < slots.length; ++i) {
                    if (!(slots[i] instanceof String)) continue;
                    if (errbuf == null) {
                        errbuf = new StringBuffer();
                        errbuf.append("no field or setter ");
                    } else {
                        errbuf.append(", ");
                    }
                    errbuf.append('`');
                    errbuf.append(slots[i]);
                    errbuf.append('\'');
                }
                if (errbuf != null) {
                    errbuf.append(" in class ");
                    errbuf.append(type2.getName());
                    comp.error('w', errbuf.toString());
                    return exp;
                }
                ApplyExp e = new ApplyExp(methods[0], new Expression[]{arg0});
                for (int i = 0; i < slots.length; ++i) {
                    Expression[] sargs = new Expression[]{e, new QuoteExp(slots[i]), args[2 * i + 2]};
                    e = new ApplyExp(SlotSet.setFieldReturnObject, sargs);
                }
                return e.setLine(exp);
            }
            int nmethods = methods.length;
            if (okCount + maybeCount == 0 && this.kind == 'N') {
                methods = invokeStatic.getMethods(ctype, "valueOf", caller);
                argsStartIndex = 1;
                margsLength = nargs - 1;
                long num = Invoke.selectApplicable((PrimProcedure[])methods, ctype, args, margsLength, argsStartIndex, -1);
                okCount = (int)(num >> 32);
                maybeCount = (int)num;
            }
            if (okCount + maybeCount == 0) {
                if (comp.getBooleanOption("warn-invoke-unknown-method", true)) {
                    if (this.kind == 'N') {
                        name = name + "/valueOf";
                    }
                    if (nmethods + methods.length == 0) {
                        comp.error('w', "no accessible method '" + name + "' in " + type2.getName());
                    } else {
                        comp.error('w', "no possibly applicable method '" + name + "' in " + type2.getName());
                    }
                }
            } else if (okCount == 1 || okCount == 0 && maybeCount == 1) {
                index = 0;
            } else if (okCount > 0) {
                index = MethodProc.mostSpecific(methods, okCount);
                if (index < 0 && this.kind == 'S') {
                    for (int i = 0; i < okCount; ++i) {
                        if (!((PrimProcedure)methods[i]).getStaticFlag()) continue;
                        if (index >= 0) {
                            index = -1;
                            break;
                        }
                        index = i;
                    }
                }
                if (index < 0 && comp.getBooleanOption("warn-invoke-unknown-method", true)) {
                    StringBuffer sbuf = new StringBuffer();
                    sbuf.append("more than one definitely applicable method `");
                    sbuf.append(name);
                    sbuf.append("' in ");
                    sbuf.append(type2.getName());
                    this.append((PrimProcedure[])methods, okCount, sbuf);
                    comp.error('w', sbuf.toString());
                }
            } else if (comp.getBooleanOption("warn-invoke-unknown-method", true)) {
                StringBuffer sbuf = new StringBuffer();
                sbuf.append("more than one possibly applicable method '");
                sbuf.append(name);
                sbuf.append("' in ");
                sbuf.append(type2.getName());
                this.append((PrimProcedure[])methods, maybeCount, sbuf);
                comp.error('w', sbuf.toString());
            }
            if (index >= 0) {
                Expression[] margs = new Expression[margsLength];
                int dst = 0;
                if (objIndex >= 0) {
                    margs[dst++] = args[objIndex];
                }
                for (int src = argsStartIndex; src < args.length && dst < margs.length; ++src, ++dst) {
                    margs[dst] = args[src];
                }
                return new ApplyExp(methods[index], margs).setLine(exp);
            }
        }
        return exp;
    }

    private void append(PrimProcedure[] methods, int mcount, StringBuffer sbuf) {
        for (int i = 0; i < mcount; ++i) {
            sbuf.append("\n  candidate: ");
            sbuf.append(methods[i]);
        }
    }

    private String getMethodName(Expression[] args) {
        int nameIndex;
        if (this.kind == 'N') {
            return "<init>";
        }
        int n = nameIndex = this.kind == 'P' ? 2 : 1;
        if (args.length >= nameIndex + 1) {
            return ClassMethods.checkName(args[nameIndex], false);
        }
        return null;
    }

    public static synchronized ApplyExp makeInvokeStatic(ClassType type, String name, Expression[] args) {
        PrimProcedure method = Invoke.getStaticMethod(type, name, args);
        if (method == null) {
            throw new RuntimeException("missing or ambiguous method `" + name + "' in " + type.getName());
        }
        return new ApplyExp(method, args);
    }

    public static synchronized PrimProcedure getStaticMethod(ClassType type, String name, Expression[] args) {
        MethodProc[] methods = invokeStatic.getMethods(type, name, null);
        long num = Invoke.selectApplicable((PrimProcedure[])methods, type, args, args.length, 0, -1);
        int okCount = (int)(num >> 32);
        int maybeCount = (int)num;
        int index = methods == null ? -1 : (okCount > 0 ? MethodProc.mostSpecific(methods, okCount) : (maybeCount == 1 ? 0 : -1));
        return index < 0 ? null : methods[index];
    }
}

