/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.lispexpr;

import gnu.bytecode.Field;
import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.Keyword;
import gnu.expr.Language;
import gnu.expr.ModuleExp;
import gnu.kawa.lispexpr.LispReader;
import gnu.kawa.lispexpr.ReadTable;
import gnu.kawa.reflect.StaticFieldLocation;
import gnu.lists.Sequence;
import gnu.mapping.EnvironmentKey;
import gnu.mapping.InPort;
import gnu.mapping.Symbol;
import gnu.mapping.Values;
import gnu.text.Lexer;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.IOException;
import kawa.lang.Syntax;
import kawa.lang.Translator;

public abstract class LispLanguage
extends Language {
    public static final String quote_sym = "quote";
    public static final String unquote_sym = "unquote";
    public static final String unquotesplicing_sym = "unquote-splicing";
    public static final String quasiquote_sym = "quasiquote";
    public static final String lookup_sym = "$lookup$";
    public ReadTable defaultReadTable = this.createReadTable();

    public abstract ReadTable createReadTable();

    @Override
    public Lexer getLexer(InPort inp, SourceMessages messages) {
        return new LispReader(inp, messages);
    }

    @Override
    public Compilation getCompilation(Lexer lexer, SourceMessages messages) {
        return new Translator(this, messages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean parse(Compilation comp, int options) throws IOException, SyntaxException {
        Translator tr = (Translator)comp;
        Lexer lexer = tr.lexer;
        ModuleExp mexp = tr.mainLambda;
        Values forms = new Values();
        LispReader reader = (LispReader)lexer;
        Compilation save_comp = Compilation.getCurrent();
        try {
            Compilation.setCurrent(tr);
            if (tr.pendingForm != null) {
                tr.scanForm(tr.pendingForm, mexp);
                tr.pendingForm = null;
            }
            while (true) {
                Object sexp;
                if ((sexp = reader.readCommand()) == Sequence.eofValue) {
                    if ((options & 2) == 0) break;
                    boolean bl = false;
                    return bl;
                }
                tr.scanForm(sexp, mexp);
                if ((options & 2) != 0) break;
                if ((options & 4) == 0 || tr.getState() < 2) continue;
                boolean bl = true;
                return bl;
            }
            if (lexer.peek() == 41) {
                lexer.fatal("An unexpected close paren was read.");
            }
            tr.finishModule(mexp);
            if ((options & 4) == 0) {
                tr.firstForm = 0;
            }
            tr.setState(4);
        }
        finally {
            Compilation.setCurrent(save_comp);
        }
        return true;
    }

    @Override
    public void resolve(Compilation comp) {
        Translator tr = (Translator)comp;
        tr.resolveModule(tr.getModule());
    }

    @Override
    public Declaration declFromField(ModuleExp mod, Object fvalue, Field fld) {
        boolean isFinal;
        Declaration fdecl = super.declFromField(mod, fvalue, fld);
        boolean bl = isFinal = (fld.getModifiers() & 0x10) != 0;
        if (isFinal && fvalue instanceof Syntax) {
            fdecl.setSyntax();
        }
        return fdecl;
    }

    protected void defSntxStFld(String name, String cname, String fname) {
        Object property = this.hasSeparateFunctionNamespace() ? EnvironmentKey.FUNCTION : null;
        StaticFieldLocation loc = StaticFieldLocation.define(this.environ, this.environ.getSymbol(name), property, cname, fname);
        loc.setSyntax();
    }

    protected void defSntxStFld(String name, String cname) {
        this.defSntxStFld(name, cname, Compilation.mangleNameIfNeeded(name));
    }

    public Expression makeBody(Expression[] exps) {
        return new BeginExp(exps);
    }

    public Expression makeApply(Expression func, Expression[] args) {
        return new ApplyExp(func, args);
    }

    public boolean selfEvaluatingSymbol(Object obj) {
        return obj instanceof Keyword;
    }

    public static Symbol langSymbolToSymbol(Object sym) {
        return ((LispLanguage)Language.getDefaultLanguage()).fromLangSymbol(sym);
    }

    protected Symbol fromLangSymbol(Object sym) {
        if (sym instanceof String) {
            return this.getSymbol((String)sym);
        }
        return (Symbol)sym;
    }
}

