/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.lispexpr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Filter;
import gnu.bytecode.ObjectType;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.PrimProcedure;
import gnu.expr.Target;
import gnu.expr.TypeValue;
import gnu.kawa.reflect.InstanceOf;
import gnu.mapping.Procedure;
import gnu.text.FilePath;
import gnu.text.Path;
import gnu.text.URIPath;
import java.util.Vector;

public class LangObjType
extends ObjectType
implements TypeValue {
    final int typeCode;
    private static final int PATH_TYPE_CODE = 1;
    private static final int FILEPATH_TYPE_CODE = 2;
    private static final int URI_TYPE_CODE = 3;
    public static final LangObjType pathType = new LangObjType("path", "gnu.text.Path", 1);
    public static final LangObjType filepathType = new LangObjType("filepath", "gnu.text.FilePath", 2);
    public static final LangObjType URIType = new LangObjType("URI", "gnu.text.URIPath", 3);
    ClassType implementationType;
    static PrimProcedure makePathProc = new PrimProcedure("gnu.text.Path", "valueOf", 1);
    static PrimProcedure makeFilepathProc = new PrimProcedure("gnu.text.FilePath", "makeFilePath", 1);
    static PrimProcedure makeURIProc = new PrimProcedure("gnu.text.URIPath", "makeURI", 1);

    LangObjType(String name, String implClass, int typeCode) {
        super(name);
        this.implementationType = ClassType.make(implClass);
        this.typeCode = typeCode;
    }

    @Override
    public int compare(Type other) {
        return this.getImplementationType().compare(other);
    }

    @Override
    public int getMethods(Filter filter, int searchSupers, Vector result, String context) {
        return this.implementationType.getMethods(filter, searchSupers, result, context);
    }

    @Override
    public Class getReflectClass() {
        return this.implementationType.getReflectClass();
    }

    @Override
    public Type getImplementationType() {
        return this.implementationType;
    }

    @Override
    public void emitIsInstance(Variable incoming, Compilation comp, Target target) {
        InstanceOf.emitIsInstance(this, incoming, comp, target);
    }

    @Override
    public void emitTestIf(Variable incoming, Declaration decl, Compilation comp) {
        String mname;
        CodeAttr code = comp.getCode();
        if (incoming != null) {
            code.emitLoad(incoming);
        }
        switch (this.typeCode) {
            case 1: {
                mname = "coerceToPathOrNull";
                break;
            }
            case 2: {
                mname = "coerceToFilePathOrNull";
                break;
            }
            case 3: {
                mname = "coerceToURIPathOrNull";
                break;
            }
            default: {
                mname = null;
            }
        }
        code.emitInvokeStatic(this.implementationType.getDeclaredMethod(mname, 1));
        if (decl != null) {
            code.emitDup();
            decl.compileStore(comp);
        }
        code.emitIfNotNull();
    }

    @Override
    public Object coerceFromObject(Object obj) {
        switch (this.typeCode) {
            case 1: {
                return Path.valueOf(obj);
            }
            case 2: {
                return FilePath.makeFilePath(obj);
            }
            case 3: {
                return URIPath.makeURI(obj);
            }
        }
        return null;
    }

    @Override
    public void emitCoerceFromObject(CodeAttr code) {
        code.emitInvoke(((PrimProcedure)this.getConstructor()).getMethod());
    }

    @Override
    public Procedure getConstructor() {
        switch (this.typeCode) {
            case 1: {
                return makePathProc;
            }
            case 2: {
                return makeFilepathProc;
            }
            case 3: {
                return makeURIProc;
            }
        }
        return null;
    }
}

