/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.bytecode.ClassType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.CanInline;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.InlineCalls;
import gnu.expr.QuoteExp;
import gnu.kawa.functions.Convert;
import gnu.kawa.functions.NamedPartSetter;
import gnu.kawa.reflect.Invoke;
import gnu.kawa.reflect.SlotGet;
import gnu.kawa.reflect.SlotSet;
import gnu.mapping.CallContext;
import gnu.mapping.HasSetter;
import gnu.mapping.MethodProc;
import gnu.mapping.Procedure;
import gnu.mapping.ProcedureN;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import kawa.standard.Scheme;

class NamedPart
extends ProcedureN
implements HasSetter,
Externalizable,
CanInline {
    Object container;
    Object member;
    char kind;
    MethodProc methods;

    public NamedPart(Object container, Object member, char kind) {
        this.container = container;
        this.member = member;
        this.kind = kind;
    }

    public NamedPart(Object container, String mname, char kind, MethodProc methods) {
        this.container = container;
        this.methods = methods;
        this.member = mname;
        this.kind = kind;
    }

    @Override
    public int numArgs() {
        if (this.kind == 'I' || this.kind == 'C') {
            return 4097;
        }
        if (this.kind == 'D') {
            return 4096;
        }
        return -4096;
    }

    @Override
    public Expression inline(ApplyExp exp, ExpWalker walker) {
        Expression[] args = exp.getArgs();
        switch (this.kind) {
            case 'D': {
                SlotGet proc;
                String fname = this.member.toString().substring(1);
                Expression[] xargs = new Expression[2];
                xargs[1] = QuoteExp.getInstance(fname);
                if (args.length > 0) {
                    xargs[0] = Convert.makeCoercion(args[0], new QuoteExp(this.container));
                    proc = SlotGet.field;
                } else {
                    xargs[0] = QuoteExp.getInstance(this.container);
                    proc = SlotGet.staticField;
                }
                ApplyExp aexp = new ApplyExp(proc, xargs);
                aexp.setLine(exp);
                return ((InlineCalls)walker).walkApplyOnly(aexp);
            }
        }
        return exp;
    }

    @Override
    public void apply(CallContext ctx) throws Throwable {
        this.apply(ctx.getArgs(), ctx);
    }

    public void apply(Object[] args, CallContext ctx) throws Throwable {
        if (this.kind == 'S') {
            this.methods.checkN(args, ctx);
        } else if (this.kind == 'M') {
            int nargs = args.length;
            Object[] xargs = new Object[nargs + 1];
            xargs[0] = this.container;
            System.arraycopy(args, 0, xargs, 1, nargs);
            this.methods.checkN(xargs, ctx);
        } else {
            ctx.writeValue(this.applyN(args));
        }
    }

    @Override
    public Object applyN(Object[] args) throws Throwable {
        switch (this.kind) {
            case 'I': {
                return Scheme.instanceOf.apply2(args[0], this.container);
            }
            case 'C': {
                return Convert.as.apply2(this.container, args[0]);
            }
            case 'N': {
                Object[] xargs = new Object[args.length + 1];
                xargs[0] = this.container;
                System.arraycopy(args, 0, xargs, 1, args.length);
                return Invoke.make.applyN(xargs);
            }
            case 'S': {
                return this.methods.applyN(args);
            }
            case 'M': {
                Object[] xargs = new Object[args.length + 1];
                xargs[0] = this.container;
                System.arraycopy(args, 0, xargs, 1, args.length);
                return this.methods.applyN(xargs);
            }
            case 'D': {
                String fname = this.member.toString().substring(1);
                if (args.length == 0) {
                    return SlotGet.staticField((ClassType)this.container, fname);
                }
                return SlotGet.field(((Type)this.container).coerceFromObject(args[0]), fname);
            }
        }
        throw new Error("unknown part " + this.member + " in " + this.container);
    }

    @Override
    public Procedure getSetter() {
        if (this.kind == 'D') {
            return new NamedPartSetter(this);
        }
        throw new RuntimeException("procedure '" + this.getName() + "' has no setter");
    }

    @Override
    public void set0(Object value) throws Throwable {
        switch (this.kind) {
            case 'D': {
                String fname = this.member.toString().substring(1);
                SlotSet.setStaticField((ClassType)this.container, fname, value);
                return;
            }
        }
        throw new Error("invalid setter for " + this);
    }

    @Override
    public void set1(Object object2, Object value) throws Throwable {
        switch (this.kind) {
            case 'D': {
                String fname = this.member.toString().substring(1);
                object2 = ((Type)this.container).coerceFromObject(object2);
                SlotSet.setField(object2, fname, value);
                return;
            }
        }
        throw new Error("invalid setter for " + this);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.container);
        out.writeObject(this.member);
        out.writeChar(this.kind);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.kind = in.readChar();
        this.container = (Procedure)in.readObject();
        this.member = (Procedure)in.readObject();
    }
}

