/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.CanInline;
import gnu.expr.Compilation;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.InlineCalls;
import gnu.expr.Language;
import gnu.kawa.reflect.ArrayGet;
import gnu.kawa.reflect.Invoke;
import gnu.mapping.CallContext;
import gnu.mapping.MethodProc;
import gnu.mapping.Procedure;
import gnu.mapping.ProcedureN;
import gnu.mapping.WrongArguments;
import gnu.mapping.WrongType;
import java.lang.reflect.Array;
import java.util.List;

public class ApplyToArgs
extends ProcedureN
implements CanInline {
    Language language;
    static final ClassType typeList = ClassType.make("java.util.List");

    @Override
    public int match1(Object arg1, CallContext ctx) {
        if (arg1 instanceof Procedure) {
            return ((Procedure)arg1).match0(ctx);
        }
        return super.match1(arg1, ctx);
    }

    @Override
    public int match2(Object arg1, Object arg2, CallContext ctx) {
        if (arg1 instanceof Procedure) {
            return ((Procedure)arg1).match1(arg2, ctx);
        }
        return super.match2(arg1, arg2, ctx);
    }

    @Override
    public int match3(Object arg1, Object arg2, Object arg3, CallContext ctx) {
        if (arg1 instanceof Procedure) {
            return ((Procedure)arg1).match2(arg2, arg3, ctx);
        }
        return super.match3(arg1, arg2, arg3, ctx);
    }

    @Override
    public int match4(Object arg1, Object arg2, Object arg3, Object arg4, CallContext ctx) {
        if (arg1 instanceof Procedure) {
            return ((Procedure)arg1).match3(arg2, arg3, arg4, ctx);
        }
        return super.match4(arg1, arg2, arg3, arg4, ctx);
    }

    @Override
    public int matchN(Object[] args, CallContext ctx) {
        int n = args.length;
        if (n > 0 && args[0] instanceof Procedure) {
            Procedure proc = (Procedure)args[0];
            switch (n) {
                case 1: {
                    return proc.match0(ctx);
                }
                case 2: {
                    return proc.match1(args[1], ctx);
                }
                case 3: {
                    return proc.match2(args[1], args[2], ctx);
                }
                case 4: {
                    return proc.match3(args[1], args[2], args[3], ctx);
                }
                case 5: {
                    return proc.match4(args[1], args[2], args[3], args[4], ctx);
                }
            }
            Object[] xargs = new Object[n - 1];
            System.arraycopy(args, 1, xargs, 0, n - 1);
            return proc.matchN(xargs, ctx);
        }
        return super.matchN(args, ctx);
    }

    @Override
    public void check1(Object arg1, CallContext ctx) {
        if (arg1 instanceof Procedure) {
            ((Procedure)arg1).check0(ctx);
        } else {
            super.check1(arg1, ctx);
        }
    }

    @Override
    public void check2(Object arg1, Object arg2, CallContext ctx) {
        if (arg1 instanceof Procedure) {
            ((Procedure)arg1).check1(arg2, ctx);
        } else {
            super.check2(arg1, arg2, ctx);
        }
    }

    @Override
    public void check3(Object arg1, Object arg2, Object arg3, CallContext ctx) {
        if (arg1 instanceof Procedure) {
            ((Procedure)arg1).check2(arg2, arg3, ctx);
        } else {
            super.check3(arg1, arg2, arg3, ctx);
        }
    }

    @Override
    public void check4(Object arg1, Object arg2, Object arg3, Object arg4, CallContext ctx) {
        if (arg1 instanceof Procedure) {
            ((Procedure)arg1).check3(arg2, arg3, arg4, ctx);
        } else {
            super.check4(arg1, arg2, arg3, arg4, ctx);
        }
    }

    @Override
    public void checkN(Object[] args, CallContext ctx) {
        int code = this.matchN(args, ctx);
        if (code != 0) {
            Procedure proc = this;
            if (args.length > 0 && args[0] instanceof Procedure) {
                proc = (Procedure)args[0];
                Object[] xargs = new Object[args.length - 1];
                System.arraycopy(args, 1, xargs, 0, xargs.length);
                args = xargs;
            }
            throw MethodProc.matchFailAsException(code, proc, args);
        }
    }

    public ApplyToArgs(String name, Language language) {
        super(name);
        this.language = language;
    }

    @Override
    public Expression inline(ApplyExp exp, ExpWalker walker) {
        Expression[] args = exp.getArgs();
        int nargs = args.length - 1;
        if (nargs >= 0) {
            ClassType ctype;
            ApplyExp result;
            Expression proc;
            args[0] = proc = args[0];
            Type ptype = proc.getType();
            Compilation comp = walker.getCompilation();
            Language language = comp.getLanguage();
            if (Invoke.checkKnownClass(ptype, comp) < 0) {
                return exp;
            }
            if (ptype.isSubtype(Compilation.typeProcedure)) {
                Expression[] rargs = new Expression[nargs];
                System.arraycopy(args, 1, rargs, 0, nargs);
                result = new ApplyExp(proc, rargs);
            } else if (ptype.isSubtype(Compilation.typeType) || language.getTypeFor(proc, false) != null) {
                result = new ApplyExp(Invoke.make, args);
            } else if (ptype instanceof ArrayType) {
                Type elementType = ((ArrayType)ptype).getComponentType();
                result = new ApplyExp(new ArrayGet(elementType), args);
            } else if (ptype instanceof ClassType && (ctype = (ClassType)ptype).isSubclass(typeList) && nargs == 1) {
                Method get = ctype.getMethod("get", new Type[]{Type.int_type});
                result = new ApplyExp(get, args);
            } else {
                return exp;
            }
            result.setLine(exp);
            return ((InlineCalls)walker).walkApplyOnly(result);
        }
        return exp;
    }

    @Override
    public Object applyN(Object[] args) throws Throwable {
        Object proc = args[0];
        Object[] rargs = new Object[args.length - 1];
        System.arraycopy(args, 1, rargs, 0, rargs.length);
        if (proc instanceof Procedure) {
            return ((Procedure)proc).applyN(rargs);
        }
        if (proc instanceof Type) {
            return Invoke.make.applyN(args);
        }
        if (proc instanceof List) {
            if (args.length != 2) {
                throw new WrongArguments(this, args.length);
            }
            int index = ((Number)rargs[0]).intValue();
            return ((List)proc).get(index);
        }
        Class<?> pclass = proc.getClass();
        if (pclass.isArray()) {
            if (args.length != 2) {
                throw new WrongArguments(this, args.length);
            }
            return Array.get(proc, ((Number)rargs[0]).intValue());
        }
        throw new WrongType((Procedure)this, 0, proc, "procedure");
    }
}

