/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Label;
import gnu.bytecode.Scope;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.kawa.reflect.OccurrenceType;
import gnu.kawa.reflect.SingletonType;

public class SeriesTarget
extends Target {
    public Declaration param;
    public Label function;
    public Label done;
    public Scope scope;

    public void compileFromStackSimple(Compilation comp, Type stackType) {
        CodeAttr code = comp.getCode();
        StackTarget.convert(comp, stackType, this.param.getType());
        this.param.compileStore(comp);
        code.emitJsr(this.function);
        if (this.done != null && code.reachableHere()) {
            code.emitGoto(this.done);
        }
        code.locals.preserveVariablesUpto(this.scope);
    }

    @Override
    public void compileFromStack(Compilation comp, Type stackType) {
        boolean doneGiven;
        CodeAttr code = comp.getCode();
        if (OccurrenceType.itemCountIsOne(stackType)) {
            this.compileFromStackSimple(comp, stackType);
            return;
        }
        Variable indexVar = code.addLocal(Type.int_type);
        Variable valuesVar = code.addLocal(Type.pointer_type);
        Variable nextVar = code.addLocal(Type.int_type);
        Label doneLabel = this.done;
        if (doneLabel == null) {
            doneGiven = false;
            doneLabel = new Label(code);
        } else {
            doneGiven = true;
            this.done = null;
        }
        StackTarget.convert(comp, stackType, Type.pointer_type);
        code.emitStore(valuesVar);
        code.emitPushInt(0);
        code.emitStore(indexVar);
        Label top = new Label(code);
        top.define(code);
        code.emitLoad(valuesVar);
        code.emitLoad(indexVar);
        code.emitInvokeStatic(Compilation.typeValues.getDeclaredMethod("nextIndex", 2));
        code.emitDup(Type.int_type);
        code.emitStore(nextVar);
        code.emitGotoIfIntLtZero(doneLabel);
        code.emitLoad(valuesVar);
        code.emitLoad(indexVar);
        code.emitInvokeStatic(Compilation.typeValues.getDeclaredMethod("nextValue", 2));
        this.compileFromStackSimple(comp, SingletonType.getInstance());
        code.emitLoad(nextVar);
        code.emitStore(indexVar);
        code.emitGoto(top);
        if (doneGiven) {
            this.done = doneLabel;
        } else {
            doneLabel.define(code);
        }
    }

    public String toString() {
        return "SeriesTarget[param: " + this.param + "; func:" + this.function + " done:" + this.done + "]";
    }

    @Override
    public Type getType() {
        return Type.pointer_type;
    }
}

