/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ArrayClassLoader;
import gnu.bytecode.ClassType;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.LambdaExp;
import gnu.expr.ModuleBody;
import gnu.expr.ModuleInfo;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.kawa.reflect.StaticFieldLocation;
import gnu.mapping.CallContext;
import gnu.mapping.Environment;
import gnu.mapping.Location;
import gnu.mapping.OutPort;
import gnu.mapping.Symbol;
import gnu.mapping.WrappedException;
import gnu.text.Path;
import gnu.text.SourceMessages;
import java.io.Externalizable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URL;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ModuleExp
extends LambdaExp
implements Externalizable {
    public static final int EXPORT_SPECIFIED = 4096;
    public static final int STATIC_SPECIFIED = 8192;
    public static final int NONSTATIC_SPECIFIED = 16384;
    public static final int SUPERTYPE_SPECIFIED = 32768;
    public static final int STATIC_RUN_SPECIFIED = 65536;
    public static final int LAZY_DECLARATIONS = 131072;
    public static final int IMMEDIATE = 262144;
    public static String dumpZipPrefix;
    static int lastZipCounter;
    public static int interactiveCounter;
    public static boolean alwaysCompile;
    ClassType superType;
    ClassType[] interfaces;
    ModuleInfo info;

    public String getJavaName() {
        String name = this.getName();
        return name == null ? "lambda" : Compilation.mangleName(name, 0);
    }

    public static Class evalToClass(Compilation comp, URL url) {
        ModuleExp mexp = comp.getModule();
        SourceMessages messages = comp.getMessages();
        try {
            ClassLoader parentLoader;
            try {
                parentLoader = Thread.currentThread().getContextClassLoader();
            }
            catch (SecurityException ex) {
                parentLoader = comp.getClass().getClassLoader();
            }
            ArrayClassLoader loader = new ArrayClassLoader(parentLoader);
            if (url == null) {
                url = Path.currentPath().toURL();
            }
            loader.setResourceContext(url);
            comp.loader = loader;
            comp.minfo.loadByStages(12);
            if (messages.seenErrors()) {
                return null;
            }
            ZipOutputStream zout = null;
            if (dumpZipPrefix != null) {
                StringBuffer zipname = new StringBuffer(dumpZipPrefix);
                if (interactiveCounter > ++lastZipCounter) {
                    lastZipCounter = interactiveCounter;
                }
                zipname.append(lastZipCounter);
                zipname.append(".zip");
                FileOutputStream zfout = new FileOutputStream(zipname.toString());
                zout = new ZipOutputStream(zfout);
            }
            for (int iClass = 0; iClass < comp.numClasses; ++iClass) {
                ClassType clas = comp.classes[iClass];
                String className = clas.getName();
                byte[] classBytes = clas.writeToArray();
                loader.addClass(className, classBytes);
                clas.cleanupAfterCompilation();
                if (zout == null) continue;
                String clname = className.replace('.', '/') + ".class";
                ZipEntry zent = new ZipEntry(clname);
                zent.setSize(classBytes.length);
                CRC32 crc = new CRC32();
                crc.update(classBytes);
                zent.setCrc(crc.getValue());
                zent.setMethod(0);
                zout.putNextEntry(zent);
                zout.write(classBytes);
            }
            if (zout != null) {
                zout.close();
            }
            Class<?> clas = null;
            for (int iClass = 0; iClass < comp.numClasses; ++iClass) {
                ClassType ctype = comp.classes[iClass];
                Class<?> cclass = loader.loadClass(ctype.getName());
                ctype.setReflectClass(cclass);
                ctype.setExisting(true);
                if (iClass != 0) continue;
                clas = cclass;
            }
            ModuleInfo minfo = comp.minfo;
            minfo.moduleClass = clas;
            int ndeps = minfo.numDependencies;
            for (int idep = 0; idep < ndeps; ++idep) {
                ModuleInfo dep = minfo.dependencies[idep];
                if (dep.moduleClass == null) {
                    dep.moduleClass = ModuleExp.evalToClass(dep.comp, null);
                }
                comp.loader.addClass(dep.moduleClass);
            }
            return clas;
        }
        catch (IOException ex) {
            throw new WrappedException("I/O error in lambda eval", ex);
        }
        catch (ClassNotFoundException ex) {
            throw new WrappedException("class not found in lambda eval", ex);
        }
        catch (Throwable ex) {
            comp.error('f', "internal compile error - caught " + ex);
            throw WrappedException.wrapIfNeeded(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static final boolean evalModule(Environment env, CallContext ctx, Compilation comp, URL url, OutPort msg) throws Throwable {
        block39: {
            block37: {
                block38: {
                    block35: {
                        block36: {
                            block40: {
                                block33: {
                                    block34: {
                                        comp.getLanguage().resolve(comp);
                                        mexp = comp.getModule();
                                        orig_env = Environment.getCurrent();
                                        orig_comp = Compilation.getCurrent();
                                        messages = comp.getMessages();
                                        savedLoader = null;
                                        thread = null;
                                        if (env != orig_env) {
                                            Environment.setCurrent(env);
                                        }
                                        if (comp != orig_comp) {
                                            Compilation.setCurrent(comp);
                                        }
                                        if (ModuleExp.alwaysCompile || comp.mustCompile) {
                                            comp.addMainClass(mexp);
                                        }
                                        comp.walkModule(mexp);
                                        comp.setState(8);
                                        if (!(msg != null ? messages.checkErrors(msg, 20) != false : messages.seenErrors() != false)) break block33;
                                        var11_11 = false;
                                        if (env == orig_env) break block34;
                                        Environment.setCurrent(orig_env);
                                    }
                                    if (comp != orig_comp) {
                                        Compilation.setCurrent(orig_comp);
                                    }
                                    if (thread != null) {
                                        thread.setContextClassLoader(savedLoader);
                                    }
                                    return var11_11;
                                }
                                if (ModuleExp.alwaysCompile || comp.mustCompile) break block40;
                                if (Compilation.debugPrintFinalExpr) {
                                    msg.println("[Evaluating final module \"" + mexp.getName() + "\":");
                                    mexp.print(msg);
                                    msg.println(']');
                                    msg.flush();
                                }
                                mexp.body.apply(ctx);
                                ** GOTO lbl107
                            }
                            if (comp.mainClass == null) {
                                comp.addMainClass(mexp);
                            }
                            clas = ModuleExp.evalToClass(comp, url);
                            if (clas != null) break block35;
                            var12_14 = false;
                            if (env == orig_env) break block36;
                            Environment.setCurrent(orig_env);
                        }
                        if (comp != orig_comp) {
                            Compilation.setCurrent(orig_comp);
                        }
                        if (thread != null) {
                            thread.setContextClassLoader(savedLoader);
                        }
                        return var12_14;
                    }
                    try {
                        thread = Thread.currentThread();
                        savedLoader = thread.getContextClassLoader();
                        thread.setContextClassLoader(clas.getClassLoader());
                    }
                    catch (Throwable ex) {
                        thread = null;
                    }
                    try {
                        inst /* !! */  = clas.getDeclaredField("$instance").get(null);
                    }
                    catch (NoSuchFieldException ex) {
                        inst /* !! */  = clas.newInstance();
                    }
                    catch (ExceptionInInitializerError ex) {
                        throw ex.getCause();
                    }
                    for (decl = mexp.firstDecl(); decl != null; decl = decl.nextDecl()) {
                        dname = decl.getSymbol();
                        if (decl.isPrivate() || dname == null) continue;
                        fld = decl.field;
                        sym = dname instanceof Symbol != false ? (Symbol)dname : Symbol.make("", dname.toString().intern());
                        property = comp.getLanguage().getEnvPropertyFor(decl);
                        dvalue = decl.getValue();
                        if (!(!decl.getFlag(16513) || dvalue instanceof ReferenceExp && ((ReferenceExp)dvalue).getBinding().needsContext())) {
                            value = dvalue instanceof QuoteExp != false && dvalue != QuoteExp.undefined_exp ? ((QuoteExp)dvalue).getValue() : decl.field.getReflectField().get(null);
                            if (decl.isIndirectBinding()) {
                                env.addLocation(sym, property, (Location)value);
                                continue;
                            }
                            env.define(sym, property, value);
                            continue;
                        }
                        loc = new StaticFieldLocation(fld.getDeclaringClass(), fld.getName());
                        loc.setDeclaration(decl);
                        env.addLocation(sym, property, loc);
                    }
                    if (!(msg != null ? messages.checkErrors(msg, 20) != false : messages.seenErrors() != false)) break block37;
                    var13_20 = false;
                    if (env == orig_env) break block38;
                    Environment.setCurrent(orig_env);
                }
                if (comp != orig_comp) {
                    Compilation.setCurrent(orig_comp);
                }
                if (thread != null) {
                    thread.setContextClassLoader(savedLoader);
                }
                return var13_20;
            }
            try {
                if (inst /* !! */  instanceof ModuleBody) {
                    ((ModuleBody)inst /* !! */ ).run(ctx);
                }
                {
                    catch (IllegalAccessException ex) {
                        throw new RuntimeException("class illegal access: in lambda eval");
                    }
                }
lbl107:
                // 2 sources

                ctx.runUntilDone();
                if (env == orig_env) break block39;
            }
            catch (Throwable var20_27) {
                if (env != orig_env) {
                    Environment.setCurrent(orig_env);
                }
                if (comp != orig_comp) {
                    Compilation.setCurrent(orig_comp);
                }
                if (thread != null) {
                    thread.setContextClassLoader(savedLoader);
                }
                throw var20_27;
            }
            Environment.setCurrent(orig_env);
        }
        if (comp != orig_comp) {
            Compilation.setCurrent(orig_comp);
        }
        if (thread != null) {
            thread.setContextClassLoader(savedLoader);
        }
        return true;
    }

    public final ClassType getSuperType() {
        return this.superType;
    }

    public final void setSuperType(ClassType s) {
        this.superType = s;
    }

    public final ClassType[] getInterfaces() {
        return this.interfaces;
    }

    public final void setInterfaces(ClassType[] s) {
        this.interfaces = s;
    }

    public final boolean isStatic() {
        return this.getFlag(8192) || (Compilation.moduleStatic > 0 || this.getFlag(262144)) && !this.getFlag(32768) && !this.getFlag(16384);
    }

    public boolean staticInitRun() {
        return this.isStatic() && (this.getFlag(65536) || Compilation.moduleStatic == 2);
    }

    @Override
    public void allocChildClasses(Compilation comp) {
        this.declareClosureEnv();
        if (!comp.usingCPStyle()) {
            return;
        }
        this.allocFrame(comp);
    }

    void allocFields(Compilation comp) {
        Declaration decl;
        for (decl = this.firstDecl(); decl != null; decl = decl.nextDecl()) {
            if (decl.isSimple() && !decl.isPublic() || decl.field != null || !decl.getFlag(65536) || !decl.getFlag(6)) continue;
            decl.makeField(comp, null);
        }
        for (decl = this.firstDecl(); decl != null; decl = decl.nextDecl()) {
            if (decl.field != null) continue;
            Expression value = decl.getValue();
            if (decl.isSimple() && !decl.isPublic() && !decl.isNamespaceDecl() && (!decl.getFlag(16384) || !decl.getFlag(6)) && !(value instanceof ClassExp) || decl.getFlag(65536) || value instanceof ModuleExp) continue;
            if (value instanceof LambdaExp && !(value instanceof ClassExp)) {
                ((LambdaExp)value).allocFieldFor(comp);
                continue;
            }
            if (!decl.getFlag(16384) && !decl.isAlias() || value == QuoteExp.undefined_exp) {
                value = null;
            }
            decl.makeField(comp, value);
        }
    }

    @Override
    protected Expression walk(ExpWalker walker) {
        return walker.walkModuleExp(this);
    }

    @Override
    public void print(OutPort out) {
        Declaration decl;
        out.startLogicalBlock("(Module/", ")", 2);
        Object sym = this.getSymbol();
        if (sym != null) {
            out.print(sym);
            out.print('/');
        }
        out.print(this.id);
        out.print('/');
        out.writeSpaceFill();
        out.startLogicalBlock("(", false, ")");
        if (decl != null) {
            out.print("Declarations:");
            for (decl = this.firstDecl(); decl != null; decl = decl.nextDecl()) {
                out.writeSpaceFill();
                decl.printInfo(out);
            }
        }
        out.endLogicalBlock(")");
        out.writeSpaceLinear();
        if (this.body == null) {
            out.print("<null body>");
        } else {
            this.body.print(out);
        }
        out.endLogicalBlock(")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Declaration firstDecl() {
        ModuleExp moduleExp = this;
        synchronized (moduleExp) {
            if (this.getFlag(131072)) {
                this.info.setupModuleExp();
            }
        }
        return this.decls;
    }

    public ClassType classFor(Compilation comp) {
        String parent;
        Path parentPath;
        if (this.type != null && this.type != Compilation.typeProcedure) {
            return this.type;
        }
        String fileName = this.getFileName();
        String mname = this.getName();
        String className = null;
        Path path = null;
        if (mname != null) {
            fileName = mname;
        } else if (fileName == null) {
            fileName = this.getName();
            if (fileName == null) {
                fileName = "$unnamed_input_file$";
            }
        } else if (this.filename.equals("-") || this.filename.equals("/dev/stdin")) {
            fileName = this.getName();
            if (fileName == null) {
                fileName = "$stdin$";
            }
        } else {
            path = Path.valueOf(fileName);
            int dotIndex = (fileName = path.getLast()).lastIndexOf(46);
            if (dotIndex > 0) {
                fileName = fileName.substring(0, dotIndex);
            }
        }
        if (this.getName() == null) {
            this.setName(fileName);
        }
        fileName = Compilation.mangleNameIfNeeded(fileName);
        if (comp.classPrefix.length() == 0 && path != null && !path.isAbsolute() && (parentPath = path.getParent()) != null && (parent = parentPath.toString()).length() > 0 && parent.indexOf("..") < 0) {
            if ((parent = parent.replaceAll(System.getProperty("file.separator"), "/")).startsWith("./")) {
                parent = parent.substring(2);
            }
            className = parent.equals(".") ? fileName : Compilation.mangleURI(parent) + "." + fileName;
        } else {
            className = comp.classPrefix + fileName;
        }
        ClassType clas = new ClassType(className);
        this.setType(clas);
        if (comp.mainLambda == this) {
            if (comp.mainClass == null) {
                comp.mainClass = clas;
            } else if (!className.equals(comp.mainClass.getName())) {
                comp.error('e', "inconsistent main class name: " + className + " - old name: " + comp.mainClass.getName());
            }
        }
        return clas;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        String name = null;
        if (this.type != null && this.type != Compilation.typeProcedure && !this.type.isExisting()) {
            out.writeObject(this.type);
        } else {
            if (name == null) {
                name = this.getName();
            }
            if (name == null) {
                name = this.getFileName();
            }
            out.writeObject(name);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Object name = in.readObject();
        if (name instanceof ClassType) {
            this.type = (ClassType)name;
            this.setName(this.type.getName());
        } else {
            this.setName((String)name);
        }
        this.flags |= 0x20000;
    }

    static {
        alwaysCompile = false;
    }
}

