/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IfExp;
import gnu.expr.LambdaExp;
import gnu.expr.LetExp;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;

public class InlineCalls
extends ExpWalker {
    public static void inlineCalls(Expression exp, Compilation comp) {
        InlineCalls walker = new InlineCalls(comp);
        walker.walk(exp);
    }

    public InlineCalls(Compilation comp) {
        this.setContext(comp);
    }

    @Override
    protected Expression walkApplyExp(ApplyExp exp) {
        super.walkApplyExp(exp);
        return this.walkApplyOnly(exp);
    }

    public Expression walkApplyOnly(ApplyExp exp) {
        return exp.func.inline(exp, this, null);
    }

    @Override
    protected Expression walkReferenceExp(ReferenceExp exp) {
        Expression dval;
        Declaration decl = exp.getBinding();
        if (decl != null && decl.getFlag(16384) && decl.field == null && (dval = decl.getValue()) instanceof QuoteExp && dval != QuoteExp.undefined_exp) {
            return this.walkQuoteExp((QuoteExp)dval);
        }
        return super.walkReferenceExp(exp);
    }

    @Override
    protected Expression walkIfExp(IfExp exp) {
        Expression value;
        Declaration decl;
        Expression test2 = exp.test.walk(this);
        if (test2 instanceof ReferenceExp && (decl = ((ReferenceExp)test2).getBinding()) != null && (value = decl.getValue()) instanceof QuoteExp && value != QuoteExp.undefined_exp) {
            test2 = value;
        }
        if (test2 instanceof QuoteExp) {
            return this.walk(this.comp.getLanguage().isTrue(((QuoteExp)test2).getValue()) ? exp.then_clause : (exp.else_clause == null ? QuoteExp.voidExp : exp.else_clause));
        }
        exp.test = test2;
        if (this.exitValue == null) {
            exp.then_clause = this.walk(exp.then_clause);
        }
        if (this.exitValue == null && exp.else_clause != null) {
            exp.else_clause = this.walk(exp.else_clause);
        }
        return exp;
    }

    @Override
    protected Expression walkLetExp(LetExp exp) {
        ReferenceExp ref;
        Declaration d;
        Declaration decl = exp.firstDecl();
        int n = exp.inits.length;
        int i = 0;
        while (i < n) {
            Expression init;
            Expression init0 = exp.inits[i];
            exp.inits[i] = init = this.walk(init0);
            Expression dvalue = decl.value;
            if (dvalue == init0) {
                decl.value = dvalue = init;
                if (!decl.getFlag(8192)) {
                    decl.setType(dvalue.getType());
                }
            }
            ++i;
            decl = decl.nextDecl();
        }
        if (this.exitValue == null) {
            exp.body = this.walk(exp.body);
        }
        if (exp.body instanceof ReferenceExp && (d = (ref = (ReferenceExp)exp.body).getBinding()) != null && d.context == exp && !ref.getDontDereference() && n == 1) {
            return exp.inits[0];
        }
        return exp;
    }

    @Override
    protected Expression walkLambdaExp(LambdaExp exp) {
        Declaration firstDecl = exp.firstDecl();
        if (firstDecl != null && firstDecl.isThisParameter() && !exp.isClassMethod() && firstDecl.getType() == null) {
            firstDecl.setType(this.comp.mainClass);
        }
        return this.walkScopeExp(exp);
    }
}

