/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.LambdaExp;
import gnu.expr.ScopeExp;

public class ChainLambdas
extends ExpWalker {
    ScopeExp currentScope;

    public static void chainLambdas(Expression exp, Compilation comp) {
        ChainLambdas walker = new ChainLambdas();
        walker.setContext(comp);
        walker.walk(exp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Expression walkScopeExp(ScopeExp exp) {
        ScopeExp saveScope = this.currentScope;
        try {
            exp.outer = this.currentScope;
            this.currentScope = exp;
            exp.walkChildren(this);
            exp.setIndexes();
            if (exp.mustCompile()) {
                this.comp.mustCompileHere();
            }
            ScopeExp scopeExp = exp;
            return scopeExp;
        }
        finally {
            this.currentScope = saveScope;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Expression walkLambdaExp(LambdaExp exp) {
        LambdaExp parent = this.currentLambda;
        if (parent != null && !(parent instanceof ClassExp)) {
            exp.nextSibling = parent.firstChild;
            parent.firstChild = exp;
        }
        ScopeExp saveScope = this.currentScope;
        try {
            exp.outer = this.currentScope;
            exp.firstChild = null;
            this.currentScope = exp;
            exp.walkChildrenOnly(this);
        }
        finally {
            this.currentScope = saveScope;
        }
        exp.walkProperties(this);
        LambdaExp prev = null;
        LambdaExp child = exp.firstChild;
        while (child != null) {
            LambdaExp next = child.nextSibling;
            child.nextSibling = prev;
            prev = child;
            child = next;
        }
        exp.firstChild = prev;
        if (exp.getName() == null && exp.nameDecl != null) {
            exp.setName(exp.nameDecl.getName());
        }
        exp.setIndexes();
        if (exp.mustCompile()) {
            this.comp.mustCompileHere();
        }
        return exp;
    }

    @Override
    protected Expression walkClassExp(ClassExp exp) {
        LambdaExp parent = this.currentLambda;
        if (parent != null && !(parent instanceof ClassExp)) {
            exp.nextSibling = parent.firstChild;
            parent.firstChild = exp;
        }
        this.walkScopeExp(exp);
        return exp;
    }
}

