/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Variable;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.LambdaExp;
import gnu.expr.ScopeExp;
import gnu.expr.Target;
import gnu.mapping.OutPort;

public class CatchClause
extends ScopeExp {
    Expression body;
    CatchClause next;

    public CatchClause(Object name, ClassType type) {
        this.addDeclaration(name, type);
    }

    public CatchClause(LambdaExp lexp) {
        Declaration decl = lexp.firstDecl();
        lexp.remove(null, decl);
        this.add(decl);
        this.body = lexp.body;
    }

    public final CatchClause getNext() {
        return this.next;
    }

    public final void setNext(CatchClause next) {
        this.next = next;
    }

    public final Expression getBody() {
        return this.body;
    }

    public final void setBody(Expression body) {
        this.body = body;
    }

    @Override
    protected boolean mustCompile() {
        return true;
    }

    @Override
    public void compile(Compilation comp, Target target) {
        CodeAttr code = comp.getCode();
        Declaration catchDecl = this.firstDecl();
        Variable catchVar = catchDecl.allocateVariable(code);
        code.enterScope(this.getVarScope());
        code.emitCatchStart(catchVar);
        this.body.compileWithPosition(comp, target);
        code.emitCatchEnd();
        code.popScope();
    }

    @Override
    protected void walkChildren(ExpWalker walker) {
        this.body = walker.walk(this.body);
    }

    @Override
    public void print(OutPort out) {
        out.writeSpaceLinear();
        out.startLogicalBlock("(Catch", ")", 2);
        out.writeSpaceFill();
        this.decls.printInfo(out);
        out.writeSpaceLinear();
        this.body.print(out);
        out.endLogicalBlock(")");
    }
}

