/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Label;
import gnu.bytecode.Method;
import gnu.bytecode.SwitchState;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.Compilation;
import gnu.expr.ConsumerTarget;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.Inlineable;
import gnu.expr.LambdaExp;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.mapping.CallContext;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.text.SourceMessages;
import java.util.Stack;

public class ApplyExp
extends Expression {
    Expression func;
    Expression[] args;
    public static final int TAILCALL = 1;
    public static final int INLINE_IF_CONSTANT = 2;
    LambdaExp context;
    public ApplyExp nextCall;
    protected Type type;

    public final Expression getFunction() {
        return this.func;
    }

    public final Expression[] getArgs() {
        return this.args;
    }

    public final int getArgCount() {
        return this.args.length;
    }

    public void setFunction(Expression func) {
        this.func = func;
    }

    public void setArgs(Expression[] args) {
        this.args = args;
    }

    public Expression getArg(int i) {
        return this.args[i];
    }

    public void setArg(int i, Expression arg) {
        this.args[i] = arg;
    }

    public final boolean isTailCall() {
        return this.getFlag(1);
    }

    public final void setTailCall(boolean tailCall) {
        this.setFlag(tailCall, 1);
    }

    public final Object getFunctionValue() {
        return this.func instanceof QuoteExp ? ((QuoteExp)this.func).getValue() : null;
    }

    public ApplyExp(Expression f, Expression[] a) {
        this.func = f;
        this.args = a;
    }

    public ApplyExp(Procedure p, Expression[] a) {
        this.func = new QuoteExp(p);
        this.args = a;
    }

    public ApplyExp(Method m, Expression[] a) {
        this.func = new QuoteExp(new PrimProcedure(m));
        this.args = a;
    }

    @Override
    protected boolean mustCompile() {
        return false;
    }

    @Override
    public void apply(CallContext ctx) throws Throwable {
        Object proc = this.func.eval(ctx);
        int n = this.args.length;
        Object[] vals = new Object[n];
        for (int i = 0; i < n; ++i) {
            vals[i] = this.args[i].eval(ctx);
        }
        ((Procedure)proc).checkN(vals, ctx);
    }

    public static void compileToArray(Expression[] args, Compilation comp) {
        CodeAttr code = comp.getCode();
        if (args.length == 0) {
            code.emitGetStatic(Compilation.noArgsField);
            return;
        }
        code.emitPushInt(args.length);
        code.emitNewArray(Type.pointer_type);
        for (int i = 0; i < args.length; ++i) {
            Expression arg = args[i];
            if (comp.usingCPStyle() && !(arg instanceof QuoteExp) && !(arg instanceof ReferenceExp)) {
                arg.compile(comp, Target.pushObject);
                code.emitSwap();
                code.emitDup(1, 1);
                code.emitSwap();
                code.emitPushInt(i);
                code.emitSwap();
            } else {
                code.emitDup(Compilation.objArrayType);
                code.emitPushInt(i);
                arg.compile(comp, Target.pushObject);
            }
            code.emitArrayStore(Type.pointer_type);
        }
    }

    @Override
    public void compile(Compilation comp, Target target) {
        ApplyExp.compile(this, comp, target, true);
    }

    public static void compile(ApplyExp exp, Compilation comp, Target target) {
        ApplyExp.compile(exp, comp, target, false);
    }

    static void compile(ApplyExp exp, Compilation comp, Target target, boolean checkInlineable) {
        boolean toArray;
        boolean tail_recurse;
        Method method;
        Object proc;
        int args_length = exp.args.length;
        Expression exp_func = exp.func;
        LambdaExp func_lambda = null;
        String func_name = null;
        Declaration owner = null;
        if (exp_func instanceof LambdaExp) {
            func_lambda = (LambdaExp)exp_func;
            func_name = func_lambda.getName();
            if (func_name == null) {
                func_name = "<lambda>";
            }
        } else if (exp_func instanceof ReferenceExp) {
            ReferenceExp func_ref = (ReferenceExp)exp_func;
            owner = func_ref.contextDecl();
            Declaration func_decl = func_ref.binding;
            while (func_decl != null && func_decl.isAlias() && func_decl.value instanceof ReferenceExp) {
                func_ref = (ReferenceExp)func_decl.value;
                if (owner != null || func_decl.needsContext() || func_ref.binding == null) break;
                func_decl = func_ref.binding;
                owner = func_ref.contextDecl();
            }
            if (!func_decl.getFlag(65536)) {
                Expression value = func_decl.getValue();
                func_name = func_decl.getName();
                if (value != null && value instanceof LambdaExp) {
                    func_lambda = (LambdaExp)value;
                }
                if (value != null && value instanceof QuoteExp) {
                    Object quotedValue = ((QuoteExp)value).getValue();
                    if (checkInlineable && quotedValue instanceof Inlineable) {
                        ((Inlineable)quotedValue).compile(exp, comp, target);
                        return;
                    }
                }
            }
        } else if (exp_func instanceof QuoteExp && (proc = ((QuoteExp)exp_func).getValue()) instanceof Inlineable && checkInlineable) {
            ((Inlineable)proc).compile(exp, comp, target);
            return;
        }
        CodeAttr code = comp.getCode();
        if (func_lambda != null) {
            if (func_lambda.max_args >= 0 && args_length > func_lambda.max_args || args_length < func_lambda.min_args) {
                throw new Error("internal error - wrong number of parameters for " + func_lambda);
            }
            int conv = func_lambda.getCallConvention();
            if (comp.inlineOk(func_lambda) && (conv <= 2 || conv == 3 && !exp.isTailCall()) && (method = func_lambda.getMethod(args_length)) != null) {
                PrimProcedure pproc = new PrimProcedure(method, func_lambda);
                boolean is_static = method.getStaticFlag();
                boolean extraArg = false;
                if (!is_static || func_lambda.declareClosureEnv() != null) {
                    if (is_static) {
                        extraArg = true;
                    }
                    if (comp.curLambda == func_lambda) {
                        code.emitLoad(func_lambda.closureEnv != null ? func_lambda.closureEnv : func_lambda.thisVariable);
                    } else if (owner != null) {
                        owner.load(null, 0, comp, Target.pushObject);
                    } else {
                        func_lambda.getOwningLambda().loadHeapFrame(comp);
                    }
                }
                pproc.compile(extraArg ? Type.void_type : null, exp, comp, target);
                return;
            }
        }
        if (comp.usingCPStyle()) {
            Field fld;
            int i;
            Label l = new Label(code);
            SwitchState fswitch = comp.fswitch;
            int pc = fswitch.getMaxValue() + 1;
            fswitch.addCase(pc, l, code);
            exp_func.compile(comp, new StackTarget(Compilation.typeProcedure));
            comp.loadCallContext();
            comp.loadCallContext();
            code.emitPushInt(pc);
            code.emitPutField(Compilation.pcCallContextField);
            code.emitInvokeVirtual(Compilation.applyCpsMethod);
            Type[] stackTypes = code.saveStackTypeState(false);
            Stack<Field> stackFields = new Stack<Field>();
            if (stackTypes != null) {
                i = stackTypes.length;
                while (--i >= 0) {
                    fld = comp.allocLocalField(stackTypes[i], null);
                    code.emitPushThis();
                    code.emitSwap();
                    code.emitPutField(fld);
                    stackFields.push(fld);
                }
            }
            code.emitReturn();
            l.define(code);
            if (stackTypes != null) {
                i = stackTypes.length;
                while (--i >= 0) {
                    fld = (Field)stackFields.pop();
                    code.emitPushThis();
                    code.emitGetField(fld);
                    comp.freeLocalField(fld);
                }
            }
            return;
        }
        boolean bl = tail_recurse = exp.isTailCall() && func_lambda != null && func_lambda == comp.curLambda;
        if (func_lambda != null && func_lambda.getInlineOnly() && !tail_recurse && func_lambda.min_args == args_length) {
            ApplyExp.pushArgs(func_lambda, exp.args, comp);
            LambdaExp saveLambda = comp.curLambda;
            comp.curLambda = func_lambda;
            func_lambda.allocChildClasses(comp);
            func_lambda.allocParameters(comp);
            ApplyExp.popParams(code, func_lambda, false);
            func_lambda.enterFunction(comp);
            func_lambda.body.compileWithPosition(comp, target);
            func_lambda.compileEnd(comp);
            func_lambda.compileChildMethods(comp);
            func_lambda.popScope(code);
            comp.curLambda = saveLambda;
            return;
        }
        if (comp.curLambda.isHandlingTailCalls() && (exp.isTailCall() || target instanceof ConsumerTarget) && !comp.curLambda.getInlineOnly()) {
            ClassType typeContext = Compilation.typeCallContext;
            exp_func.compile(comp, new StackTarget(Compilation.typeProcedure));
            if (args_length <= 4) {
                for (int i = 0; i < args_length; ++i) {
                    exp.args[i].compile(comp, Target.pushObject);
                }
                comp.loadCallContext();
                code.emitInvoke(Compilation.typeProcedure.getDeclaredMethod("check" + args_length, args_length + 1));
            } else {
                ApplyExp.compileToArray(exp.args, comp);
                comp.loadCallContext();
                code.emitInvoke(Compilation.typeProcedure.getDeclaredMethod("checkN", 2));
            }
            if (exp.isTailCall()) {
                code.emitReturn();
            } else if (((ConsumerTarget)target).isContextTarget()) {
                comp.loadCallContext();
                code.emitInvoke(typeContext.getDeclaredMethod("runUntilDone", 0));
            } else {
                comp.loadCallContext();
                code.emitLoad(((ConsumerTarget)target).getConsumerVariable());
                code.emitInvoke(typeContext.getDeclaredMethod("runUntilValue", 1));
            }
            return;
        }
        if (!tail_recurse) {
            exp_func.compile(comp, new StackTarget(Compilation.typeProcedure));
        }
        boolean bl2 = tail_recurse ? func_lambda.min_args != func_lambda.max_args : (toArray = args_length > 4);
        if (toArray) {
            ApplyExp.compileToArray(exp.args, comp);
            method = Compilation.applyNmethod;
        } else if (tail_recurse) {
            ApplyExp.pushArgs(func_lambda, exp.args, comp);
            method = null;
        } else {
            for (int i = 0; i < args_length; ++i) {
                exp.args[i].compile(comp, Target.pushObject);
                if (!code.reachableHere()) break;
            }
            method = Compilation.applymethods[args_length];
        }
        if (!code.reachableHere()) {
            comp.error('e', "unreachable code");
            return;
        }
        if (tail_recurse) {
            ApplyExp.popParams(code, func_lambda, toArray);
            code.emitTailCall(false, func_lambda.getVarScope());
            return;
        }
        code.emitInvokeVirtual(method);
        target.compileFromStack(comp, Type.pointer_type);
    }

    @Override
    protected Expression walk(ExpWalker walker) {
        return walker.walkApplyExp(this);
    }

    @Override
    protected void walkChildren(ExpWalker walker) {
        this.func = walker.walk(this.func);
        if (walker.exitValue == null) {
            this.args = walker.walkExps(this.args, this.args.length);
        }
    }

    @Override
    public void print(OutPort out) {
        out.startLogicalBlock("(Apply", ")", 2);
        if (this.isTailCall()) {
            out.print(" [tailcall]");
        }
        if (this.type != null && this.type != Type.pointer_type) {
            out.print(" => ");
            out.print(this.type);
        }
        out.writeSpaceFill();
        this.printLineColumn(out);
        this.func.print(out);
        for (int i = 0; i < this.args.length; ++i) {
            out.writeSpaceLinear();
            this.args[i].print(out);
        }
        out.endLogicalBlock(")");
    }

    private static void pushArgs(LambdaExp lexp, Expression[] args, Compilation comp) {
        Declaration param = lexp.firstDecl();
        for (Expression arg : args) {
            if (param.ignorable()) {
                arg.compile(comp, Target.Ignore);
            } else {
                arg.compile(comp, param.getType());
            }
            param = param.nextDecl();
        }
    }

    private static void popParams(CodeAttr code, LambdaExp lexp, boolean toArray) {
        Variable vars = lexp.getVarScope().firstVar();
        Declaration decls = lexp.firstDecl();
        if (vars != null && vars.getName() == "this") {
            vars = vars.nextVar();
        }
        if (vars != null && vars.getName() == "$ctx") {
            vars = vars.nextVar();
        }
        if (vars != null && vars.getName() == "argsArray") {
            if (toArray) {
                ApplyExp.popParams(code, 1, decls, vars);
                return;
            }
            vars = vars.nextVar();
        }
        ApplyExp.popParams(code, lexp.min_args, decls, vars);
    }

    private static void popParams(CodeAttr code, int count, Declaration decl, Variable vars) {
        if (count > 0) {
            ApplyExp.popParams(code, count - 1, decl.nextDecl(), decl.getVariable() == null ? vars : vars.nextVar());
            if (!decl.ignorable()) {
                code.emitStore(vars);
            }
        }
    }

    public final Type getTypeRaw() {
        return this.type;
    }

    public final void setType(Type type) {
        this.type = type;
    }

    @Override
    public final Type getType() {
        if (this.type != null) {
            return this.type;
        }
        Expression afunc = this.func;
        this.type = Type.pointer_type;
        if (afunc instanceof ReferenceExp) {
            Declaration func_decl = ((ReferenceExp)afunc).binding;
            if ((func_decl = Declaration.followAliases(func_decl)) != null && !func_decl.getFlag(65536)) {
                afunc = func_decl.getValue();
            }
        }
        if (afunc instanceof QuoteExp) {
            Object proc = ((QuoteExp)afunc).getValue();
            if (proc instanceof Inlineable) {
                this.type = ((Inlineable)proc).getReturnType(this.args);
            }
        } else if (afunc instanceof LambdaExp) {
            this.type = ((LambdaExp)afunc).getReturnType();
        }
        return this.type;
    }

    public final Expression inlineIfConstant(Procedure proc, ExpWalker walker) {
        return this.inlineIfConstant(proc, walker.getMessages());
    }

    public final Expression inlineIfConstant(Procedure proc, SourceMessages messages) {
        int len = this.args.length;
        Object[] vals = new Object[len];
        int i = len;
        while (--i >= 0) {
            Declaration decl;
            Expression arg = this.args[i];
            if (arg instanceof ReferenceExp && (decl = ((ReferenceExp)arg).getBinding()) != null && (arg = decl.getValue()) == QuoteExp.undefined_exp) {
                return this;
            }
            if (!(arg instanceof QuoteExp)) {
                return this;
            }
            vals[i] = ((QuoteExp)arg).getValue();
        }
        try {
            return new QuoteExp(proc.applyN(vals));
        }
        catch (Throwable ex) {
            if (messages != null) {
                messages.error('w', "call to " + proc + " throws " + ex);
            }
            return this;
        }
    }

    @Override
    public String toString() {
        return "ApplyExp/" + this.args.length + '[' + this.func + ']';
    }
}

