/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Filter;
import gnu.bytecode.Type;
import java.util.Vector;

public class ObjectType
extends Type {
    static final int ADD_FIELDS_DONE = 1;
    static final int ADD_METHODS_DONE = 2;
    static final int EXISTING_CLASS = 4;
    static final int HAS_OUTER_LINK = 8;
    public int flags;
    static ClassLoader thisClassLoader;

    protected ObjectType() {
        this.size = 4;
    }

    public ObjectType(String name) {
        this.this_name = name;
        this.size = 4;
    }

    public final boolean isExisting() {
        return (this.flags & 4) != 0;
    }

    public final void setExisting(boolean existing) {
        this.flags = existing ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    public String getInternalName() {
        return this.getName().replace('.', '/');
    }

    public static Class getContextClass(String cname) throws ClassNotFoundException {
        ClassLoader loader;
        try {
            loader = Thread.currentThread().getContextClassLoader();
        }
        catch (SecurityException ex) {
            loader = thisClassLoader;
        }
        return Class.forName(cname, false, loader);
    }

    @Override
    public Class getReflectClass() {
        block3: {
            try {
                if (this.reflectClass == null) {
                    this.reflectClass = ObjectType.getContextClass(this.getInternalName().replace('/', '.'));
                }
                this.flags |= 4;
            }
            catch (ClassNotFoundException ex) {
                if ((this.flags & 4) == 0) break block3;
                RuntimeException rex = new RuntimeException("no such class: " + this.getName());
                rex.initCause(ex);
                throw rex;
            }
        }
        return this.reflectClass;
    }

    @Override
    public Type getImplementationType() {
        return this == nullType ? pointer_type : (this == tostring_type ? string_type : this);
    }

    @Override
    public Type promote() {
        return this == nullType ? pointer_type : this;
    }

    @Override
    public boolean isInstance(Object obj) {
        if (this == nullType) {
            return obj == null;
        }
        return super.isInstance(obj);
    }

    public int getMethods(Filter filter, int searchSupers, Vector result, String context) {
        return 0;
    }

    @Override
    public int compare(Type other) {
        return other == nullType ? 0 : -1;
    }

    @Override
    public Object coerceFromObject(Object obj) {
        if (obj != null) {
            Class<?> objClass;
            if (this == Type.tostring_type) {
                return obj.toString();
            }
            Class clas = this.getReflectClass();
            if (!clas.isAssignableFrom(objClass = obj.getClass())) {
                throw new ClassCastException("don't know how to coerce " + objClass.getName() + " to " + this.getName());
            }
        }
        return obj;
    }

    @Override
    public void emitCoerceFromObject(CodeAttr code) {
        if (this == Type.tostring_type) {
            code.emitDup();
            code.emitIfNull();
            code.emitPop(1);
            code.emitPushNull();
            code.emitElse();
            code.emitInvokeVirtual(Type.toString_method);
            code.emitFi();
        } else if (this != Type.pointer_type) {
            code.emitCheckcast(this);
        }
    }

    static {
        try {
            thisClassLoader = Class.forName("gnu.mapping.ObjectType").getClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

