/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.Filter;
import gnu.bytecode.ObjectType;
import gnu.bytecode.Type;
import java.util.Vector;

public class ArrayType
extends ObjectType {
    public Type elements;

    public ArrayType(Type elements) {
        this(elements, elements.getName() + "[]");
    }

    ArrayType(Type elements, String name) {
        this.this_name = name;
        this.setSignature("[" + elements.getSignature());
        this.elements = elements;
    }

    @Override
    public Type getImplementationType() {
        Type eltype = this.elements.getImplementationType();
        return this.elements == eltype ? this : ArrayType.make(eltype);
    }

    static ArrayType make(String name) {
        Type elements = Type.getType(name.substring(0, name.length() - 2));
        ArrayType array_type = elements.array_type;
        if (array_type == null) {
            elements.array_type = array_type = new ArrayType(elements, name);
        }
        return array_type;
    }

    public static ArrayType make(Type elements) {
        ArrayType array_type = elements.array_type;
        if (array_type == null) {
            elements.array_type = array_type = new ArrayType(elements, elements.getName() + "[]");
        }
        return array_type;
    }

    public Type getComponentType() {
        return this.elements;
    }

    @Override
    public String getInternalName() {
        return this.getSignature();
    }

    @Override
    public int getMethods(Filter filter, int searchSupers, Vector result, String context) {
        if (searchSupers > 0) {
            int count = Type.pointer_type.getMethods(filter, 0, result, null);
            if (searchSupers > 1 && filter.select(Type.clone_method)) {
                if (result != null) {
                    result.addElement(Type.clone_method);
                }
                ++count;
            }
            return count;
        }
        return 0;
    }

    @Override
    public int compare(Type other) {
        if (other == nullType) {
            return 1;
        }
        if (other instanceof ArrayType) {
            return this.elements.compare(((ArrayType)other).elements);
        }
        if (other.getName().equals("java.lang.Object") || other == tostring_type) {
            return -1;
        }
        return -3;
    }
}

