/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class CategoryWriter
extends PrintWriter {
    private Category category;
    private Priority priority;
    private boolean inWrite;
    private boolean issuedWarning;

    public CategoryWriter(Category category) {
        this(category, Priority.INFO);
    }

    public CategoryWriter(Category category, Priority priority) {
        super((Writer)new InternalCategoryWriter(category, priority), true);
    }

    static class InternalCategoryWriter
    extends Writer {
        private Category category;
        private Priority priority;
        private boolean closed;

        public InternalCategoryWriter(Category category, Priority priority) {
            this.lock = category;
            this.category = category;
            this.priority = priority;
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            if (this.closed) {
                throw new IOException("Called write on closed Writer");
            }
            while (len > 0 && (cbuf[len - 1] == '\n' || cbuf[len - 1] == '\r')) {
                --len;
            }
            if (len > 0) {
                this.category.log(this.priority, String.copyValueOf(cbuf, off, len));
            }
        }

        public void flush() throws IOException {
            if (this.closed) {
                throw new IOException("Called flush on closed Writer");
            }
        }

        public void close() {
            this.closed = true;
        }
    }
}

