/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.rulebase.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import jp.sourceforge.gnp.prorate.export.Prorate;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseException;
import jp.sourceforge.gnp.rulebase.xml.RuleCacheElement;
import jp.sourceforge.gnp.rulebase.xml.RuleFoundException;
import jp.sourceforge.gnp.rulebase.xml.XmlRulebase;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class XmlRulebaseCache
extends XmlRulebase {
    RuleCacheElement selectedRecord;
    List appliedRules;

    public static synchronized void initialize() throws Exception {
        if (rulebaseList != null) {
            return;
        }
        String ruleDir = System.getProperty("GNP_RULE_DIR");
        if (ruleDir == null) {
            ClassLoader loader = Prorate.class.getClassLoader();
            InputStream is = loader.getResourceAsStream("jp/sourceforge/gnp/prorate.properties");
            Properties properties = new Properties();
            try {
                properties.load(is);
            }
            catch (IOException e1) {
                System.err.println("IOException in writeModel() : " + e1.getMessage());
                throw new ProrateRulebaseException("IOException in XmlRulebase.initialize() :" + e1.getMessage(), e1);
            }
            ruleDir = properties.getProperty("GNP_RULE_DIR", "/usr/local/gnp/rulebase");
        }
        rulebaseList = new Vector();
        if (!XmlRulebaseCache.ruleInstall("spa", ruleDir, "spa", 0, ".xml", (short)257)) {
            throw new Exception("proration service SPA rulebase initialization failed");
        }
        if (!XmlRulebaseCache.ruleInstall("apdp", ruleDir, "apdp", 1, ".xml", (short)258)) {
            throw new Exception("proration service APDP rulebase initialization failed");
        }
        if (!XmlRulebaseCache.ruleInstall("extf", ruleDir, "extf", 2, ".xml", (short)263)) {
            throw new Exception("proration service EXTF rulebase initialization failed");
        }
        if (!XmlRulebaseCache.ruleInstall("part", ruleDir, "part", 3, ".xml", (short)264)) {
            throw new Exception("proration service PART rulebase initialization failed");
        }
    }

    static boolean ruleInstall(String rule, String root, String dir, int index, String extent, short regist) throws ProrateRulebaseException {
        String dirName = root + System.getProperty("file.separator") + dir;
        File directory = new File(dirName);
        Object[] ruleFiles = directory.list();
        if (ruleFiles == null) {
            return false;
        }
        Arrays.sort(ruleFiles);
        Vector<RuleCacheElement> rules = new Vector<RuleCacheElement>();
        for (int i = 0; i < ruleFiles.length; ++i) {
            if (!((String)ruleFiles[i]).matches("[a-zA-Z0-9(),]*.xml")) continue;
            String fileName = dirName + System.getProperty("file.separator") + (String)ruleFiles[i];
            String name = null;
            String type = null;
            String carrier = null;
            String tkCarrier = null;
            String validStart = null;
            String validEnd = null;
            Date dateFrom = null;
            Date dateUntil = null;
            final String ruleName = rule;
            try {
                InputStreamReader reader = new InputStreamReader(new FileInputStream(fileName));
                String venderParserClass = "org.apache.xerces.parsers.SAXParser";
                XMLReader xmlReader = XMLReaderFactory.createXMLReader(venderParserClass);
                ContentHandler handler = new ContentHandler(){

                    @Override
                    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
                        if (localName.equals(ruleName)) {
                            RuleFoundException e = new RuleFoundException();
                            for (int i = 0; i < atts.getLength(); ++i) {
                                if (atts.getLocalName(i).equals("name")) {
                                    e.name = atts.getValue(i);
                                    continue;
                                }
                                if (atts.getLocalName(i).equals("type")) {
                                    e.type = atts.getValue(i);
                                    continue;
                                }
                                if (atts.getLocalName(i).equals("carrier")) {
                                    e.carrier = atts.getValue(i);
                                    continue;
                                }
                                if (atts.getLocalName(i).equals("tkCarrier")) {
                                    e.tkCarrier = atts.getValue(i);
                                    continue;
                                }
                                if (atts.getLocalName(i).equals("validStart")) {
                                    e.validStart = atts.getValue(i);
                                    continue;
                                }
                                if (!atts.getLocalName(i).equals("validEnd")) continue;
                                e.validEnd = atts.getValue(i);
                            }
                            throw e;
                        }
                    }

                    @Override
                    public void endDocument() throws SAXException {
                    }

                    @Override
                    public void startDocument() throws SAXException {
                    }

                    @Override
                    public void characters(char[] ch, int start, int length) throws SAXException {
                    }

                    @Override
                    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
                    }

                    @Override
                    public void endPrefixMapping(String prefix) throws SAXException {
                    }

                    @Override
                    public void skippedEntity(String name) throws SAXException {
                    }

                    @Override
                    public void setDocumentLocator(Locator locator) {
                    }

                    @Override
                    public void processingInstruction(String target, String data) throws SAXException {
                    }

                    @Override
                    public void startPrefixMapping(String prefix, String uri) throws SAXException {
                    }

                    @Override
                    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
                    }
                };
                xmlReader.setContentHandler(handler);
                InputSource inputSource = new InputSource(reader);
                xmlReader.parse(inputSource);
            }
            catch (RuleFoundException e) {
                name = e.name;
                type = e.type;
                carrier = e.carrier;
                tkCarrier = e.tkCarrier;
                validStart = e.validStart;
                validEnd = e.validEnd;
            }
            catch (SAXException e) {
                throw new ProrateRulebaseException("SAXException in ruleInstall() :" + e.getMessage(), e);
            }
            catch (FileNotFoundException e) {
                throw new ProrateRulebaseException(fileName + " : " + "file not found in ruleInstall() :" + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new ProrateRulebaseException("IOException in ruleInstall() :" + e.getMessage(), e);
            }
            if (validStart != null && !validStart.equals("")) {
                try {
                    dateFrom = dtFormat.parse(validStart);
                }
                catch (ParseException e) {
                    throw new ProrateRulebaseException(dateFrom + " : " + "ParseException in ruleInstall() :" + e.getMessage(), e);
                }
            }
            if (validEnd != null && !validEnd.equals("")) {
                try {
                    dateUntil = dtFormat.parse(validEnd);
                }
                catch (ParseException e) {
                    throw new ProrateRulebaseException(dateUntil + " : " + "ParseException in ruleInstall() :" + e.getMessage(), e);
                }
            }
            RuleCacheElement ruleElem = new RuleCacheElement(rule, name, type, carrier, tkCarrier, dateFrom, dateUntil, fileName, null);
            rules.add(ruleElem);
        }
        Object[] rulebase = rules.toArray();
        rulebaseList.add(rulebase);
        return true;
    }

    public XmlRulebaseCache() throws Exception {
        this.setAppliedRules(new Vector());
    }

    public XmlRulebaseCache(String in_filename) {
        super(in_filename);
    }

    @Override
    public boolean selectSPA(String carrier, String tkCarrier, String dateIssue) throws ProrateRulebaseException {
        if (dateIssue == null || dateIssue.equals("")) {
            return false;
        }
        Object[] rulebase = (Object[])rulebaseList.get(0);
        int index = Arrays.binarySearch(rulebase, new RuleCacheElement("spa", "", "", carrier, tkCarrier, null, null, null, null), new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((RuleCacheElement)o1).compareTo((RuleCacheElement)o2);
            }
        });
        if (index < 0) {
            return false;
        }
        int i = index;
        while (i > 0 && ((RuleCacheElement)rulebase[i]).match("spa", "", carrier, tkCarrier)) {
            index = i--;
        }
        Date date = null;
        try {
            date = dtFormat.parse(dateIssue);
        }
        catch (ParseException e) {
            throw new ProrateRulebaseException(dateIssue + " : " + "ParseException in selectSPA() :" + e.getMessage(), e);
        }
        for (int i2 = index; i2 < rulebase.length; ++i2) {
            if (!((RuleCacheElement)rulebase[i2]).match("spa", "", carrier, tkCarrier)) {
                return false;
            }
            if (!((RuleCacheElement)rulebase[i2]).match("spa", "", carrier, tkCarrier, date)) continue;
            this.setSelectedRecord((RuleCacheElement)rulebase[i2]);
            this.getAppliedRules().add(this.getSelectedRecord());
            this.setFilename(((RuleCacheElement)rulebase[i2]).filename);
            return true;
        }
        return false;
    }

    @Override
    public boolean selectAPDP(String carrier, String dateIssue) throws ProrateRulebaseException {
        if (dateIssue == null || dateIssue.equals("")) {
            return false;
        }
        Object[] rulebase = (Object[])rulebaseList.get(1);
        int index = Arrays.binarySearch(rulebase, new RuleCacheElement("apdp", "", "", carrier, "", null, null, null, null), new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((RuleCacheElement)o1).compareTo((RuleCacheElement)o2);
            }
        });
        if (index < 0) {
            return false;
        }
        int i = index;
        while (i > 0 && ((RuleCacheElement)rulebase[i]).match("apdp", "", carrier, "")) {
            index = i--;
        }
        Date date = null;
        try {
            date = dtFormat.parse(dateIssue);
        }
        catch (ParseException e) {
            throw new ProrateRulebaseException(dateIssue + " : " + "ParseException in selectAPDP() :" + e.getMessage(), e);
        }
        for (int i2 = index; i2 < rulebase.length; ++i2) {
            if (!((RuleCacheElement)rulebase[i2]).match("apdp", "", carrier, "")) {
                return false;
            }
            if (!((RuleCacheElement)rulebase[i2]).match("apdp", "", carrier, "", date)) continue;
            this.setSelectedRecord((RuleCacheElement)rulebase[i2]);
            this.getAppliedRules().add(this.getSelectedRecord());
            this.setFilename(((RuleCacheElement)rulebase[i2]).filename);
            return true;
        }
        return false;
    }

    @Override
    public boolean selectEXTF(String extfName) throws ProrateRulebaseException {
        int index;
        Object[] rulebase = (Object[])rulebaseList.get(2);
        int i = index = Arrays.binarySearch(rulebase, new RuleCacheElement("extf", extfName, "", "", "", null, null, null, null), new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((RuleCacheElement)o1).compareTo((RuleCacheElement)o2);
            }
        });
        while (i > 0 && ((RuleCacheElement)rulebase[i]).match("extf", extfName, "", "")) {
            index = i--;
        }
        i = index;
        if (i < rulebase.length) {
            if (!((RuleCacheElement)rulebase[i]).match("extf", extfName, "", "")) {
                throw new ProrateRulebaseException(extfName + " : " + "EXTF not found", null);
            }
            this.setSelectedRecord((RuleCacheElement)rulebase[i]);
            this.getAppliedRules().add(this.getSelectedRecord());
            this.setFilename(((RuleCacheElement)rulebase[i]).filename);
            return true;
        }
        return false;
    }

    @Override
    public boolean selectPART(String name) throws ProrateRulebaseException {
        int index;
        Object[] rulebase = (Object[])rulebaseList.get(3);
        int i = index = Arrays.binarySearch(rulebase, new RuleCacheElement("part", name, "", "", "", null, null, null, null), new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((RuleCacheElement)o1).compareTo((RuleCacheElement)o2);
            }
        });
        while (i > 0 && ((RuleCacheElement)rulebase[i]).match("part", name, "", "")) {
            index = i--;
        }
        i = index;
        if (i < rulebase.length) {
            if (!((RuleCacheElement)rulebase[i]).match("part", name, "", "")) {
                throw new ProrateRulebaseException(name + " : " + "PART not found", null);
            }
            this.setSelectedRecord((RuleCacheElement)rulebase[i]);
            this.getAppliedRules().add(this.getSelectedRecord());
            this.setFilename(((RuleCacheElement)rulebase[i]).filename);
            return true;
        }
        return false;
    }

    @Override
    public List read() throws ProrateRulebaseException {
        List rules = null;
        rules = this.getSelectedRecord().getRules();
        if (rules != null && rules.size() > 0) {
            this.getSelectedRecord().setCached(true);
            return rules;
        }
        try {
            rules = this.read(false);
        }
        catch (Exception e) {
            throw new ProrateRulebaseException("rulebase read error", e);
        }
        this.getSelectedRecord().setCached(false);
        this.getSelectedRecord().setRules(rules);
        return rules;
    }

    public RuleCacheElement getSelectedRecord() {
        return this.selectedRecord;
    }

    public void setSelectedRecord(RuleCacheElement selectedRecord) {
        this.selectedRecord = selectedRecord;
    }

    public List getAppliedRules() {
        return this.appliedRules;
    }

    public void setAppliedRules(List appliedRules) {
        this.appliedRules = appliedRules;
    }
}

