/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prubae;

import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;
import jp.sourceforge.gnp.prubae.PrubaeController;
import jp.sourceforge.gnp.prubae.PrubaeModel;
import jp.sourceforge.gnp.prubae.PrubaeModelCase;
import jp.sourceforge.gnp.prubae.PrubaeModelDo;
import jp.sourceforge.gnp.prubae.PrubaeModelSwitch;
import jp.sourceforge.gnp.prubae.PrubaeModelValue;
import jp.sourceforge.gnp.prubae.PrubaeModelValueStatement;

public class PrubaeControllerCase
extends PrubaeController {
    private JPanel argsCountPanel = null;
    private JLabel argsCountLabel = null;
    private JTextField argsCountField = null;
    private JButton argsCountButton = null;
    private int argsCount = 0;
    private List argsPanels = null;

    @Override
    public void initialize() {
        super.initialize();
        List actionList = ((PrubaeModelCase)this.getModel()).getActions();
        if (actionList != null) {
            for (int i = 0; i < actionList.size(); ++i) {
                DefaultMutableTreeNode node = ((PrubaeModel)actionList.get(i)).getController().getTreeNode();
                this.getTreeNode().add(node);
            }
        }
        this.setArgsCount(0);
    }

    @Override
    public void update() {
        ((PrubaeModelCase)this.getModel()).updateCases();
        super.update();
    }

    @Override
    public void createPanel() {
        super.createPanel();
        this.getPanel().add(new JLabel("CASE-BRANCH"));
        JButton deleteButton = new JButton("delete this case");
        deleteButton.setActionCommand("delete");
        deleteButton.addActionListener(this);
        JButton insertButton = new JButton("insert case before this");
        insertButton.setActionCommand("insert");
        insertButton.addActionListener(this);
        JButton actionButton = new JButton("add action");
        actionButton.setActionCommand("action");
        actionButton.addActionListener(this);
        JPanel commandPanel = new JPanel();
        commandPanel.setLayout(new BoxLayout(commandPanel, 1));
        commandPanel.add(deleteButton);
        commandPanel.add(insertButton);
        commandPanel.add(actionButton);
        this.panel.add(commandPanel);
        this.setArgsCountPanel(new JPanel());
        this.setArgsCountLabel(new JLabel("COUNT"));
        this.setArgsCountField(new JTextField("", 4));
        this.setArgsCountButton(new JButton("INPUT"));
        this.getArgsCountButton().setActionCommand("set cases");
        this.getArgsCountButton().addActionListener(this);
        this.getArgsCountPanel().setLayout(new BoxLayout(this.getArgsCountPanel(), 0));
        this.getArgsCountPanel().add(this.argsCountLabel);
        this.getArgsCountPanel().add(this.getArgsCountField());
        this.getArgsCountPanel().add(this.argsCountButton);
        this.getPanel().add(this.getArgsCountPanel());
    }

    @Override
    public void destroyPanel() {
        this.setArgsCountLabel(null);
        this.setArgsCountField(null);
        this.setArgsCountButton(null);
        this.setArgsCountPanel(null);
        this.setArgsPanels(null);
        super.destroyPanel();
    }

    protected void insert() {
        PrubaeModelCase newModel = new PrubaeModelCase();
        newModel.insertToParent(this.getModel().getParentList(), this.getModel().getParent(), this.getModel());
        DefaultMutableTreeNode treeParent = (DefaultMutableTreeNode)this.getTreeNode().getParent();
        newModel.getController().insertTreeNode(treeParent, this.getTreeNode());
    }

    private void addActions() {
        List actionsList = ((PrubaeModelCase)this.getModel()).getActions();
        if (actionsList != null) {
            Object last = null;
            if (actionsList.size() > 0) {
                last = (PrubaeModel)actionsList.get(actionsList.size() - 1);
            }
            if (last != null) {
                System.err.println("addActions() last class name " + last.getClass().getName());
            }
            if (last != null && last.getClass().getName().endsWith("PrubaeModelDo")) {
                return;
            }
            last = new PrubaeModelDo();
            ((PrubaeModel)last).addToParent(actionsList, this.getModel());
            ((PrubaeModel)last).getController().addTreeNode(this.getTreeNode());
        }
    }

    private void updateArgsCount() {
        ((PrubaeModelCase)this.getModel()).updateCases();
        int numArgs = 0;
        try {
            numArgs = Integer.parseInt(this.getArgsCountField().getText());
        }
        catch (NumberFormatException e) {
            return;
        }
        int oldArgsCount = this.getArgsCount();
        this.setArgsCount(numArgs);
        if (numArgs > oldArgsCount) {
            this.addArguments(oldArgsCount, numArgs);
        } else if (numArgs < oldArgsCount) {
            this.removeArguments(numArgs, oldArgsCount);
        }
    }

    private void addArguments(int minArgs, int numArgs) {
        if (((PrubaeModelCase)this.getModel()).getValues() == null) {
            ((PrubaeModelCase)this.getModel()).setValues(new Vector());
        }
        PrubaeModelSwitch parent = (PrubaeModelSwitch)this.getModel().getParent();
        for (int i = minArgs; i < numArgs; ++i) {
            PrubaeModelValue branch = new PrubaeModelValue();
            branch.setRegist((short)298);
            branch.setComment("");
            branch.setStatement("");
            branch.initialize(this.getEditor(), (PrubaeModelCase)this.getModel(), ((PrubaeModelCase)this.getModel()).getValues());
            ((PrubaeModelCase)this.getModel()).getValues().add(branch);
            for (int j = 0; j < parent.getVars().size(); ++j) {
                Object type = ((PrubaeModelValue)parent.getVars().get(j)).getType();
                PrubaeModelValueStatement ret = new PrubaeModelValueStatement();
                ret.setType(type);
                ret.setComment("");
                ret.setStatement("");
                ret.initialize(this.getEditor(), branch, branch.getValues());
                ((PrubaeModel)ret).openUI();
                branch.getValues().add(ret);
            }
        }
    }

    private void removeArguments(int minArgs, int numArgs) {
        for (int i = numArgs - 1; i >= minArgs; --i) {
            PrubaeModelValue branch = (PrubaeModelValue)((PrubaeModelCase)this.getModel()).getValues().get(i);
            for (int j = branch.getValues().size() - 1; j >= 0; --j) {
                PrubaeModelValue ret = (PrubaeModelValue)branch.getValues().get(j);
                ret.closeUI();
            }
            ((PrubaeModelCase)this.getModel()).getValues().remove(branch);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("delete")) {
            this.deleteAndUp();
        } else if (e.getActionCommand().equals("insert")) {
            this.insert();
        } else if (e.getActionCommand().equals("action")) {
            this.addActions();
        } else {
            System.err.println("action = " + e.getActionCommand());
            if (e.getActionCommand().equals("set cases")) {
                this.updateArgsCount();
            }
            this.getView().display();
        }
    }

    @Override
    public Object clone() {
        PrubaeControllerCase clone = null;
        clone = (PrubaeControllerCase)super.clone();
        if (this.getArgsCountPanel() != null) {
            clone.setArgsCountPanel(new JPanel());
        }
        if (this.getArgsCountField() != null) {
            clone.setArgsCountField(new JTextField());
        }
        clone.setArgsPanels((List)((Vector)this.getArgsPanels()).clone());
        return clone;
    }

    public void setArgsCountPanel(JPanel theArgsCountPanel) {
        this.argsCountPanel = theArgsCountPanel;
    }

    public JPanel getArgsCountPanel() {
        return this.argsCountPanel;
    }

    public void setArgsCountLabel(JLabel theArgsCountLabel) {
        this.argsCountLabel = theArgsCountLabel;
    }

    public JLabel getArgsCountLabel() {
        return this.argsCountLabel;
    }

    public void setArgsCountField(JTextField theArgsCountField) {
        this.argsCountField = theArgsCountField;
    }

    public JTextField getArgsCountField() {
        return this.argsCountField;
    }

    public void setArgsCountButton(JButton theArgsCountButton) {
        this.argsCountButton = theArgsCountButton;
    }

    public JButton getArgsCountButton() {
        return this.argsCountButton;
    }

    public void setArgsCount(int theArgsCount) {
        this.argsCount = theArgsCount;
    }

    public int getArgsCount() {
        return this.argsCount;
    }

    public void setArgsPanels(List theArgsPanels) {
        this.argsPanels = theArgsPanels;
    }

    public List getArgsPanels() {
        return this.argsPanels;
    }
}

