/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prorate.struts.service;

import java.util.List;
import jp.sourceforge.gnp.prorate.ProrateImpl;
import jp.sourceforge.gnp.prorate.ProrateRuleObjectFactory;
import jp.sourceforge.gnp.prorate.ProrateTraceString;
import jp.sourceforge.gnp.prorate.database.ProrateRdb;
import jp.sourceforge.gnp.prorate.export.Prorate;
import jp.sourceforge.gnp.prorate.export.ProrateAudit;
import jp.sourceforge.gnp.prorate.fcalc.ProrateFCalcImpl;
import jp.sourceforge.gnp.prorate.struts.service.ProrateService;
import jp.sourceforge.gnp.prorate.struts.view.ProrateView;
import jp.sourceforge.gnp.rulebase.xml.XmlRulebase;

public class ProrateServiceAll
extends ProrateService {
    @Override
    public ProrateView prorate(ProrateAudit audit) {
        ProrateImpl prorate = null;
        try {
            prorate = (ProrateImpl)this.createProrate();
        }
        catch (Exception e) {
            e.printStackTrace();
            ProrateView errorView = this.createErrorView(audit);
            errorView.setFatalError(true);
            errorView.setErrorString(e.getMessage());
            if (errorView.getErrorString() == null) {
                errorView.setErrorString(e.toString());
            }
            return errorView;
        }
        XmlRulebase rulebase = null;
        try {
            rulebase = new XmlRulebase();
            XmlRulebase.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
            ProrateView errorView = this.createErrorView(audit);
            errorView.setFatalError(true);
            errorView.setErrorString(e.getMessage());
            return errorView;
        }
        ProrateRuleObjectFactory factory = new ProrateRuleObjectFactory();
        rulebase.setElementFactory(factory);
        prorate.setRulebase(rulebase);
        prorate.setFcalc(new ProrateFCalcImpl());
        ProrateTraceString trace = new ProrateTraceString();
        trace.setData(audit);
        prorate.setTrace(trace);
        prorate.setDatabase(new ProrateRdb());
        if (!prorate.getDatabase().openDatabase()) {
            ProrateView errorView = this.createErrorView(audit);
            errorView.setErrorString("proration service database initialization failed");
            return errorView;
        }
        ProrateAudit auditRet = null;
        try {
            auditRet = prorate.prorate(audit);
        }
        catch (Exception e) {
            ProrateView errorView = this.createErrorView(audit);
            errorView.setFatalError(true);
            errorView.setErrorString(e.getMessage());
            if (errorView.getErrorString() == null) {
                errorView.setErrorString(e.toString());
            }
            return errorView;
        }
        List traceStrings = ((ProrateTraceString)prorate.getTrace()).getStrings();
        String[] traceStringsArray = new String[traceStrings.size()];
        for (int i = 0; i < traceStrings.size(); ++i) {
            traceStringsArray[i] = (String)traceStrings.get(i);
        }
        auditRet.setTraceStrings(traceStringsArray);
        prorate.getDatabase().closeDatabase();
        prorate.setDatabase(null);
        prorate.setTrace(null);
        prorate.setFcalc(null);
        prorate.setRulebase(null);
        ProrateView prorateView = this.createView(auditRet);
        return prorateView;
    }

    public Prorate createProrate() throws Exception {
        ProrateImpl prorate = new ProrateImpl();
        return prorate;
    }
}

