/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prorate.rmi;

import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.List;
import jp.sourceforge.gnp.prorate.ProrateImpl;
import jp.sourceforge.gnp.prorate.ProrateRuleObjectFactory;
import jp.sourceforge.gnp.prorate.ProrateTaxImpl;
import jp.sourceforge.gnp.prorate.ProrateTraceString;
import jp.sourceforge.gnp.prorate.database.ProrateRdb;
import jp.sourceforge.gnp.prorate.export.ProrateAudit;
import jp.sourceforge.gnp.prorate.fcalc.ProrateFCalcImpl;
import jp.sourceforge.gnp.prorate.rmi.RemoteProrate;
import jp.sourceforge.gnp.rulebase.xml.XmlRulebase;

public class RemoteProrateServer
extends UnicastRemoteObject
implements RemoteProrate {
    private static final long serialVersionUID = 1L;
    static ProrateImpl prorate = null;

    public static void main(String[] args) {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        try {
            RemoteProrateServer server = new RemoteProrateServer();
            if (!RemoteProrateServer.initialize()) {
                System.exit(1);
            }
            String name = System.getProperty("proratename", "RemoteProrate");
            Naming.rebind(name, server);
            System.out.println(name + " is open and ready for customers.");
        }
        catch (Exception e) {
            System.err.println(e);
            System.err.println("Usage: java [-Dproratename=<name>] RemoteProrateServer");
            System.exit(1);
        }
    }

    static boolean initialize() {
        XmlRulebase rulebase = null;
        try {
            rulebase = new XmlRulebase();
            XmlRulebase.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("proration service rulebase initialization failed:" + e.getMessage());
            return false;
        }
        ProrateRuleObjectFactory factory = new ProrateRuleObjectFactory();
        rulebase.setElementFactory(factory);
        prorate = new ProrateImpl();
        prorate.setRulebase(rulebase);
        prorate.setFcalc(new ProrateFCalcImpl());
        prorate.setTax(new ProrateTaxImpl());
        ProrateTraceString trace = new ProrateTraceString();
        prorate.setTrace(trace);
        prorate.setDatabase(new ProrateRdb());
        if (!prorate.getDatabase().openDatabase()) {
            System.err.println("proration service database initialization failed:" + prorate.getDatabase().getErrMessage());
            return false;
        }
        return true;
    }

    @Override
    public ProrateAudit prorate(ProrateAudit audit) throws Exception {
        prorate.getTrace().setData(audit);
        ProrateAudit auditRet = prorate.prorate(audit);
        prorate.getTrace().close();
        List traceStrings = ((ProrateTraceString)prorate.getTrace()).getStrings();
        String[] traceStringsArray = new String[traceStrings.size()];
        for (int i = 0; i < traceStrings.size(); ++i) {
            traceStringsArray[i] = (String)traceStrings.get(i);
        }
        auditRet.setTraceStrings(traceStringsArray);
        return auditRet;
    }
}

