/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prorate;

import jp.sourceforge.gnp.prorate.ProrateRuleNumber;
import jp.sourceforge.gnp.prorate.ProrateRuleObject;
import jp.sourceforge.gnp.prorate.ProrateRuntime;
import jp.sourceforge.gnp.prorate.ProrateVar;

class ProrateVarDiscount
extends ProrateVar {
    ProrateVarDiscount() {
    }

    @Override
    public ProrateRuleObject eval(ProrateRuntime runtime) {
        ProrateRuleNumber ret = null;
        ret = runtime.isSPA ? new ProrateRuleNumber(runtime.sector.getSpaDiscountRate()) : new ProrateRuleNumber(runtime.sector.getApdpDiscountRate());
        this.setEvaluatedObject(ret);
        return ret;
    }

    @Override
    public ProrateRuleObject copy(ProrateRuntime runtime) {
        if (this.isCopied) {
            return this;
        }
        ProrateVarDiscount pobj = new ProrateVarDiscount();
        pobj.isCopied = true;
        return pobj;
    }

    @Override
    public void dump() {
        System.out.print("$DISCOUNT");
    }

    public String toString() {
        return "$DISCOUNT";
    }

    @Override
    String traceStr() {
        return this.toString();
    }

    @Override
    ProrateRuleObject set(ProrateRuleObject value, ProrateRuntime runtime) {
        if (!value.isNumber()) {
            this.error(7, runtime);
            return value;
        }
        if (runtime.isSPA) {
            runtime.sector.setSpaDiscountRate(runtime.sector.getSpaDiscountRate() * ((ProrateRuleNumber)value).getValue());
            ((ProrateRuleNumber)value).setValue(runtime.sector.getSpaDiscountRate());
        } else {
            runtime.sector.setApdpDiscountRate(runtime.sector.getApdpDiscountRate() * ((ProrateRuleNumber)value).getValue());
            ((ProrateRuleNumber)value).setValue(runtime.sector.getApdpDiscountRate());
        }
        return value;
    }
}

