/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prorate;

import java.io.Serializable;
import jp.sourceforge.gnp.prorate.ProrateRule;
import jp.sourceforge.gnp.prorate.ProrateRuleObject;
import jp.sourceforge.gnp.prorate.ProrateRuntime;
import jp.sourceforge.gnp.prorate.ProrateTrace;
import jp.sourceforge.gnp.prorate.export.ProrateAudit;
import jp.sourceforge.gnp.prorate.export.ProrateFareComponent;
import jp.sourceforge.gnp.prorate.export.ProrateSector;

public abstract class ProrateTraceImpl
implements ProrateTrace,
Serializable {
    int maxLevel = -1;
    int level = -1;
    ProrateAudit audit = null;
    int sequenceNo = -1;

    @Override
    public boolean setData(Object data) {
        this.setAudit((ProrateAudit)data);
        this.setMaxLevel(this.getAudit().getTraceLevel());
        return true;
    }

    @Override
    public boolean trace(ProrateFareComponent fcomp, int index, double localValue, double roeRate, double day5Rate) {
        this.setLevel(0);
        if (this.getMaxLevel() < this.getLevel()) {
            return true;
        }
        String traceStr = "Fare Component(";
        traceStr = traceStr + index;
        traceStr = traceStr + ") {";
        for (int i = 0; i < fcomp.getSectors().length; ++i) {
            traceStr = traceStr + fcomp.getSectors()[i].getDepCode();
            traceStr = traceStr + "-";
            traceStr = traceStr + fcomp.getSectors()[i].getDestCode();
            traceStr = traceStr + " ";
        }
        traceStr = traceStr + "} ";
        traceStr = traceStr + fcomp.getValue();
        traceStr = traceStr + " <- ";
        traceStr = traceStr + localValue;
        traceStr = traceStr + " * ";
        traceStr = traceStr + roeRate;
        traceStr = traceStr + "(roe) / ";
        traceStr = traceStr + day5Rate;
        traceStr = traceStr + "(5dy)";
        return this.trace(traceStr, -1);
    }

    @Override
    public boolean trace(ProrateRuntime runtime, String rule, String carrier, String tkCarrier) {
        this.setLevel(0);
        if (this.getMaxLevel() < this.getLevel()) {
            return true;
        }
        ProrateAudit audit = runtime.audit;
        ProrateSector sector = runtime.sector;
        String traceStr = rule;
        boolean apply = rule.equals("SPA") ? (runtime.sector.getProrationType() & 0x1000000) != 0 : (runtime.sector.getProrationType() & 0x100) != 0;
        traceStr = apply ? traceStr + " applied on [" : traceStr + " not applied on [";
        traceStr = traceStr + sector.getDepCode();
        traceStr = traceStr + " - ";
        traceStr = traceStr + sector.getDestCode();
        traceStr = traceStr + " ";
        traceStr = traceStr + carrier;
        if (rule.equals("SPA")) {
            traceStr = traceStr + "/";
            traceStr = traceStr + tkCarrier;
        }
        traceStr = traceStr + " (";
        traceStr = traceStr + audit.getIssueDate();
        traceStr = traceStr + ")]";
        if (apply) {
            traceStr = traceStr + " ";
            traceStr = traceStr + (rule.equals("SPA") ? sector.getSpaDiscountRate() : sector.getApdpDiscountRate()) * 100.0;
            traceStr = traceStr + "%of ";
            traceStr = traceStr + (rule.equals("SPA") ? sector.getSpaBaseAmtType() : sector.getApdpBaseAmtType());
            traceStr = traceStr + (rule.equals("SPA") ? sector.getSpaBaseAmt() : sector.getApdpBaseAmt());
            traceStr = traceStr + "(NUC)";
            traceStr = traceStr + (rule.equals("SPA") ? sector.getSpaNuc() : sector.getApdpNuc());
        }
        return this.trace(traceStr, sector.getSequenceNo());
    }

    @Override
    public boolean trace(ProrateRule rule, ProrateSector sector, int level) {
        if (this.getMaxLevel() < level) {
            return true;
        }
        return rule.trace(sector, this, level);
    }

    @Override
    public boolean trace(ProrateRuleObject pobj, ProrateSector sector, int level) {
        if (this.getMaxLevel() < level) {
            return true;
        }
        this.setLevel(level);
        return pobj.trace(sector, this, level);
    }

    @Override
    public boolean trace(String traceMessage, int sequenceNo, int level) {
        this.setLevel(level);
        this.trace(traceMessage, sequenceNo);
        return true;
    }

    @Override
    public boolean trace(String traceMessage, int sequenceNo) {
        this.setSequenceNo(sequenceNo);
        this.trace(traceMessage);
        return true;
    }

    @Override
    public abstract boolean trace(String var1);

    @Override
    public boolean close() {
        return true;
    }

    @Override
    public boolean traceFixedFareCheck(boolean pass, ProrateFareComponent fcomp) {
        this.setLevel(0);
        if (this.getMaxLevel() < this.getLevel()) {
            return true;
        }
        String traceStr = "checkFixedFare";
        traceStr = traceStr + (pass ? " pass: " : " fail: ");
        traceStr = traceStr + fcomp.getSectors()[0].getFixedFareCheck();
        traceStr = traceStr + " >= ";
        traceStr = traceStr + fcomp.getAudit().getFixedFare();
        traceStr = traceStr + " * ";
        traceStr = traceStr + fcomp.getFixedFareDiscount();
        this.trace(traceStr, -1);
        return true;
    }

    @Override
    public boolean traceValue(ProrateFareComponent fcomp, int i) {
        this.setLevel(0);
        if (this.getMaxLevel() < this.getLevel()) {
            return true;
        }
        String traceStr = "prorateValue set by ";
        double nuc = 0.0;
        double rest = 0.0;
        if ((fcomp.getSectors()[i].getProrationType() & 0x1000000) != 0) {
            traceStr = traceStr + "SPA: ";
            nuc = fcomp.getSectors()[i].getSpaNuc();
            rest = fcomp.getSectors()[i].getProratedClassDiff() + fcomp.getSectors()[i].getProratedSecureCharge();
        } else if ((fcomp.getSectors()[i].getProrationType() & 0x2000000) != 0) {
            traceStr = traceStr + "APDP: ";
            nuc = fcomp.getSectors()[i].getApdpNuc();
            rest = fcomp.getSectors()[i].getProratedClassDiff() + fcomp.getSectors()[i].getProratedSecureCharge();
        } else {
            traceStr = traceStr + "SRP: ";
            nuc = fcomp.getSectors()[i].getSrpNuc();
            rest = fcomp.getSectors()[i].getProratedClassDiff() + fcomp.getSectors()[i].getProratedSecureCharge();
        }
        traceStr = traceStr + fcomp.getSectors()[i].getProrateValue();
        traceStr = traceStr + " = ";
        traceStr = traceStr + nuc;
        traceStr = traceStr + "(NUC) + ";
        traceStr = traceStr + rest;
        this.trace(traceStr, fcomp.getSectors()[i].getSequenceNo());
        return true;
    }

    @Override
    public boolean traceRest(ProrateAudit audit, double rest, double totalProrateFactor, int i) {
        this.setLevel(0);
        if (this.getMaxLevel() < this.getLevel()) {
            return true;
        }
        String traceStr = "set rest to proratevalue ";
        traceStr = traceStr + audit.getSectors()[i].getProrateValue();
        traceStr = traceStr + " <-(+=) ";
        if (totalProrateFactor == 0.0) {
            traceStr = traceStr + rest;
        } else {
            traceStr = traceStr + rest;
            traceStr = traceStr + " * ";
            traceStr = traceStr + audit.getSectors()[i].getProrateFactor();
            traceStr = traceStr + " / ";
            traceStr = traceStr + totalProrateFactor;
        }
        this.trace(traceStr, audit.getSectors()[i].getSequenceNo());
        return true;
    }

    @Override
    public boolean traceRest(ProrateFareComponent fcomp, double rest, double totalProrateFactor, int i) {
        this.setLevel(0);
        if (this.getMaxLevel() < this.getLevel()) {
            return true;
        }
        String traceStr = "set rest to proratevalue in fcomp ";
        traceStr = traceStr + fcomp.getSectors()[i].getProrateValue();
        traceStr = traceStr + " <-(+=) ";
        if (totalProrateFactor == 0.0) {
            traceStr = traceStr + rest;
        } else {
            traceStr = traceStr + rest;
            traceStr = traceStr + " * ";
            traceStr = traceStr + fcomp.getSectors()[i].getProrateFactor();
            traceStr = traceStr + " / ";
            traceStr = traceStr + totalProrateFactor;
        }
        this.trace(traceStr, fcomp.getSectors()[i].getSequenceNo());
        return true;
    }

    @Override
    public boolean traceDiscount(ProrateAudit audit, double rest, boolean add_p, double totalProrateFactor, int i) {
        this.setLevel(0);
        if (this.getMaxLevel() < this.getLevel()) {
            return true;
        }
        String traceStr = "discount ";
        traceStr = traceStr + audit.getSectors()[i].getProrateValue();
        traceStr = traceStr + (add_p ? " <-(+=) " : " <-(=) ");
        if (totalProrateFactor == 0.0) {
            traceStr = traceStr + rest;
        } else {
            traceStr = traceStr + rest;
            traceStr = traceStr + " * ";
            traceStr = traceStr + audit.getSectors()[i].getProrateFactor();
            traceStr = traceStr + " / ";
            traceStr = traceStr + totalProrateFactor;
        }
        this.trace(traceStr, audit.getSectors()[i].getSequenceNo());
        return true;
    }

    @Override
    public boolean traceTax(ProrateAudit audit, double taxValue, String type, double amount, int sectors, double error, int i) {
        this.setLevel(0);
        if (this.getMaxLevel() < this.getLevel()) {
            return true;
        }
        String traceStr = "tax ";
        traceStr = traceStr + type;
        traceStr = traceStr + " set ";
        traceStr = traceStr + audit.getSectors()[i].getTax();
        traceStr = traceStr + " <-(+=) ";
        traceStr = traceStr + taxValue;
        traceStr = traceStr + " (";
        traceStr = traceStr + amount;
        traceStr = traceStr + " / ";
        traceStr = traceStr + sectors;
        traceStr = traceStr + ")";
        if (error != 0.0) {
            traceStr = traceStr + " + (";
            traceStr = traceStr + error;
            traceStr = traceStr + ")";
        }
        this.trace(traceStr, audit.getSectors()[i].getSequenceNo());
        return true;
    }

    @Override
    public boolean traceCommission(ProrateAudit audit, boolean noAmt, int restIndex, double rest) {
        this.setLevel(0);
        if (this.getMaxLevel() < this.getLevel()) {
            return true;
        }
        if (audit.isOwnAudit() && audit.isTicketing()) {
            for (int i = 0; i < audit.getSectors().length; ++i) {
                String traceStr = "commission set ";
                traceStr = traceStr + audit.getSectors()[i].getCommission();
                traceStr = traceStr + " <- ";
                traceStr = traceStr + audit.getSectors()[i].getProrateValue();
                traceStr = traceStr + " * ";
                traceStr = traceStr + audit.getCommissionAmt();
                if (noAmt) {
                    traceStr = traceStr + "(";
                    traceStr = traceStr + audit.getSalesFare();
                    traceStr = traceStr + "*";
                    traceStr = traceStr + audit.getCommissionRate();
                    traceStr = traceStr + "/100)";
                }
                traceStr = traceStr + " / ";
                traceStr = traceStr + audit.getSalesFare();
                if (i == restIndex) {
                    traceStr = traceStr + " + (";
                    traceStr = traceStr + rest;
                    traceStr = traceStr + ")";
                }
                this.trace(traceStr, audit.getSectors()[i].getSequenceNo());
                traceStr = "invoiceValue set ";
                traceStr = traceStr + audit.getSectors()[i].getInvoiceValue();
                traceStr = traceStr + " <- ";
                traceStr = traceStr + audit.getSectors()[i].getProrateValue();
                traceStr = traceStr + " + ";
                traceStr = traceStr + audit.getSectors()[i].getTax();
                traceStr = traceStr + " - ";
                traceStr = traceStr + audit.getSectors()[i].getCommission();
                this.trace(traceStr, audit.getSectors()[i].getSequenceNo());
            }
        } else {
            for (int i = 0; i < audit.getSectors().length; ++i) {
                String traceStr = "commission set ";
                traceStr = traceStr + audit.getSectors()[i].getCommission();
                traceStr = traceStr + " <- ";
                traceStr = traceStr + audit.getSectors()[i].getProrateValue();
                traceStr = traceStr + " * ";
                traceStr = traceStr + audit.getCommissionRate();
                traceStr = traceStr + " / 100";
                this.trace(traceStr, audit.getSectors()[i].getSequenceNo());
                traceStr = "invoiceValue set ";
                traceStr = traceStr + audit.getSectors()[i].getInvoiceValue();
                traceStr = traceStr + " <- ";
                traceStr = traceStr + audit.getSectors()[i].getProrateValue();
                traceStr = traceStr + " + ";
                traceStr = traceStr + audit.getSectors()[i].getTax();
                traceStr = traceStr + " - ";
                traceStr = traceStr + audit.getSectors()[i].getCommission();
                this.trace(traceStr, audit.getSectors()[i].getSequenceNo());
            }
        }
        return true;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    @Override
    public void setMaxLevel(int maxLevel) {
        this.maxLevel = maxLevel;
    }

    public int getSequenceNo() {
        return this.sequenceNo;
    }

    public void setSequenceNo(int sequenceNo) {
        this.sequenceNo = sequenceNo;
    }

    public ProrateAudit getAudit() {
        return this.audit;
    }

    public int getLevel() {
        return this.level;
    }

    @Override
    public void setAudit(ProrateAudit audit) {
        this.audit = audit;
    }

    public void setLevel(int level) {
        this.level = level;
    }
}

