/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prorate;

import java.util.List;
import java.util.Vector;
import jp.sourceforge.gnp.prorate.ProrateRuleObject;
import jp.sourceforge.gnp.prorate.ProrateRuntime;
import jp.sourceforge.gnp.prorate.ProrateTrace;
import jp.sourceforge.gnp.prorate.export.ProrateSector;

class ProrateRulePart
extends ProrateRuleObject {
    protected String name;
    protected List rules;

    public ProrateRulePart() {
        this.rules = new Vector();
    }

    public ProrateRulePart(String name, List in_rules) {
        this.name = name;
        this.rules = in_rules;
    }

    @Override
    public ProrateRuleObject eval(ProrateRuntime runtime) throws Exception {
        ProrateRuleObject ret = null;
        for (int i = 0; i < this.rules.size(); ++i) {
            this.rules.set(i, ((ProrateRuleObject)this.rules.get(i)).copy(runtime));
            ret = ((ProrateRuleObject)this.rules.get(i)).eval(runtime);
            if (!runtime.apply) break;
        }
        this.setEvaluatedObject(this);
        return this.evaluatedObject;
    }

    @Override
    public ProrateRuleObject copy(ProrateRuntime runtime) {
        if (this.isCopied) {
            return this;
        }
        ProrateRulePart pobj = new ProrateRulePart();
        pobj.name = this.name;
        pobj.rules = new Vector(this.rules);
        pobj.isCopied = true;
        return pobj;
    }

    @Override
    public void dump() {
        System.out.println("PART(" + this.name + ")");
        for (int i = 0; i < this.rules.size(); ++i) {
            ((ProrateRuleObject)this.rules.get(i)).dump();
        }
    }

    @Override
    public boolean trace(ProrateSector sector, ProrateTrace trace, int level) {
        if (!this.isEvaluated()) {
            return false;
        }
        StringBuffer traceStr = new StringBuffer("PART");
        traceStr.append("(");
        traceStr.append(this.name);
        traceStr.append(")");
        if (!trace.trace(traceStr.toString(), sector.getSequenceNo(), level)) {
            return false;
        }
        for (int i = 0; i < this.rules.size(); ++i) {
            if (trace.trace((ProrateRuleObject)this.rules.get(i), sector, level + 1)) continue;
            return false;
        }
        return true;
    }
}

