/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prorate;

import java.util.List;
import java.util.Vector;
import jp.sourceforge.gnp.prorate.ProrateDatabase;
import jp.sourceforge.gnp.prorate.ProrateFunc;
import jp.sourceforge.gnp.prorate.ProrateRuleAmount;
import jp.sourceforge.gnp.prorate.ProrateRuleBool;
import jp.sourceforge.gnp.prorate.ProrateRuleNumber;
import jp.sourceforge.gnp.prorate.ProrateRuleObject;
import jp.sourceforge.gnp.prorate.ProrateRuntime;

class ProrateFuncHighSpaFix
extends ProrateFunc {
    ProrateFuncHighSpaFix(List in_args) {
        super(in_args);
    }

    @Override
    public ProrateRuleObject eval(ProrateRuntime runtime) {
        if (!this.checkArgnum(1, "High_spa_fix", runtime)) {
            return null;
        }
        this.args.set(0, ((ProrateRuleObject)this.args.get(0)).copy(runtime));
        ProrateRuleObject valueObj = (ProrateRuleObject)this.args.get(0);
        if (valueObj == null) {
            this.setErrorObject();
            return null;
        }
        if (!valueObj.isNumber() && !valueObj.isAmount()) {
            this.error(2, "High_spa_fix:1", runtime);
            return null;
        }
        if (valueObj.isAmount()) {
            double day5Rate = 0.0;
            ProrateDatabase db = runtime.getAuditImpl().database;
            String currency = ((ProrateRuleAmount)valueObj).getCurrency();
            day5Rate = db.getMeanRate(currency, runtime.audit.getInvoiceMonth());
            if (day5Rate <= 0.0 && (day5Rate = db.get5dayRate(currency, runtime.audit.getInvoiceMonth())) < 0.0) {
                if (runtime.audit.getDay5Rate() <= 0.0) {
                    if (db.getResult() > 1) {
                        this.DBError(runtime, "get5dayRate", currency, runtime.audit.getInvoiceMonth());
                        return null;
                    }
                    int errorNo = 69;
                    StringBuffer errorMessage = new StringBuffer(currency);
                    errorMessage.append(":");
                    errorMessage.append(runtime.audit.getInvoiceMonth());
                    this.error(errorNo, errorMessage.toString(), runtime);
                    return null;
                }
                day5Rate = runtime.audit.getDay5Rate();
            }
            runtime.sector.setFixValue(((ProrateRuleAmount)valueObj).getValue() / day5Rate);
            runtime.sector.setFixCurrency(((ProrateRuleAmount)valueObj).getCurrency());
            runtime.sector.setFixAmount(((ProrateRuleAmount)valueObj).getValue());
        } else {
            runtime.sector.setFixValue(((ProrateRuleNumber)valueObj).getValue());
            runtime.sector.setFixCurrency("");
            runtime.sector.setFixAmount(0.0);
        }
        runtime.sector.setProrationType(runtime.sector.getProrationType() | 0x40000000);
        this.setEvaluatedObject(new ProrateRuleBool(true));
        return this.evaluatedObject;
    }

    @Override
    public ProrateRuleObject copy(ProrateRuntime runtime) {
        if (this.isCopied) {
            return this;
        }
        ProrateFuncHighSpaFix pobj = new ProrateFuncHighSpaFix(new Vector(this.args));
        pobj.isCopied = true;
        return pobj;
    }

    @Override
    public void dump() {
        System.out.print("HighSpaFix(");
        super.dump();
    }

    @Override
    public String operatorString() {
        return "HighSpaFix";
    }
}

